/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.util.PrefUtil;

public class WorkbenchPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button stickyCycleButton;
    private Button doubleClickButton;
    private Button singleClickButton;
    private Button selectOnHoverButton;
    private Button openAfterDelayButton;
    private Button showUserDialogButton;
    private Button renameModeInlineButton;
    private Button renameModeDialogButton;
    private IntegerFieldEditor saveInterval;
    private boolean openOnSingleClick;
    private boolean renameModeInline;
    private boolean selectOnHover;
    private boolean openAfterDelay;
    private Button showHeapStatusButton;
    protected static int MAX_SAVE_INTERVAL = 9999;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.workbench_preference_page_context");
        Composite composite = this.createComposite(parent);
        this.createSettings(composite);
        WorkbenchPreferencePage.createSpace(composite);
        this.createOpenModeGroup(composite);
        this.applyDialogFont(composite);
        return composite;
    }

    protected void createSettings(Composite composite) {
        this.createShowUserDialogPref(composite);
        this.createStickyCyclePref(composite);
        this.createHeapStatusPref(composite);
        this.createSaveIntervalGroup(composite);
    }

    protected void createShowUserDialogPref(Composite composite) {
        this.showUserDialogButton = new Button(composite, 32);
        this.showUserDialogButton.setText(WorkbenchMessages.WorkbenchPreference_RunInBackgroundButton);
        this.showUserDialogButton.setToolTipText(WorkbenchMessages.WorkbenchPreference_RunInBackgroundToolTip);
        this.showUserDialogButton.setSelection(WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("RUN_IN_BACKGROUND"));
    }

    protected void createHeapStatusPref(Composite composite) {
        this.showHeapStatusButton = new Button(composite, 32);
        this.showHeapStatusButton.setText(WorkbenchMessages.WorkbenchPreference_HeapStatusButton);
        this.showHeapStatusButton.setToolTipText(WorkbenchMessages.WorkbenchPreference_HeapStatusButtonToolTip);
        this.showHeapStatusButton.setSelection(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_MEMORY_MONITOR"));
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        return composite;
    }

    protected void createStickyCyclePref(Composite composite) {
        this.stickyCycleButton = new Button(composite, 32);
        this.stickyCycleButton.setText(WorkbenchMessages.WorkbenchPreference_stickyCycleButton);
        this.stickyCycleButton.setSelection(this.getPreferenceStore().getBoolean("STICKY_CYCLE"));
    }

    private void createSaveIntervalGroup(Composite composite) {
        Composite groupComposite = new Composite(composite, 16384);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        groupComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupComposite.setLayoutData((Object)gd);
        this.saveInterval = new IntegerFieldEditor("WORKBENCH_SAVE_INTERVAL", WorkbenchMessages.WorkbenchPreference_workbenchSaveInterval, groupComposite);
        this.saveInterval.setPreferenceStore(this.getPreferenceStore());
        this.saveInterval.setPage((DialogPage)this);
        this.saveInterval.setTextLimit(Integer.toString(MAX_SAVE_INTERVAL).length());
        this.saveInterval.setErrorMessage(NLS.bind((String)WorkbenchMessages.WorkbenchPreference_workbenchSaveIntervalError, (Object)MAX_SAVE_INTERVAL));
        this.saveInterval.setValidateStrategy(0);
        this.saveInterval.setValidRange(0, MAX_SAVE_INTERVAL);
        this.saveInterval.load();
        this.saveInterval.setPropertyChangeListener(event -> {
            if (event.getProperty().equals("field_editor_is_valid")) {
                this.setValid(this.saveInterval.isValid());
            }
        });
    }

    protected void createOpenModeGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = new Group(composite, 16384);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setText(WorkbenchMessages.WorkbenchPreference_openMode);
        String label = WorkbenchMessages.WorkbenchPreference_doubleClick;
        this.doubleClickButton = WorkbenchPreferencePage.createRadioButton((Composite)buttonComposite, label);
        this.doubleClickButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.selectClickMode(this.singleClickButton.getSelection())));
        this.doubleClickButton.setSelection(!this.openOnSingleClick);
        label = WorkbenchMessages.WorkbenchPreference_singleClick;
        this.singleClickButton = WorkbenchPreferencePage.createRadioButton((Composite)buttonComposite, label);
        this.singleClickButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.selectClickMode(this.singleClickButton.getSelection())));
        this.singleClickButton.setSelection(this.openOnSingleClick);
        label = WorkbenchMessages.WorkbenchPreference_singleClick_SelectOnHover;
        this.selectOnHoverButton = new Button((Composite)buttonComposite, 16416);
        this.selectOnHoverButton.setText(label);
        this.selectOnHoverButton.setEnabled(this.openOnSingleClick);
        this.selectOnHoverButton.setSelection(this.selectOnHover);
        this.selectOnHoverButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.selectOnHover = this.selectOnHoverButton.getSelection();
        }));
        data = new GridData();
        data.horizontalIndent = LayoutConstants.getIndent();
        this.selectOnHoverButton.setLayoutData((Object)data);
        label = WorkbenchMessages.WorkbenchPreference_singleClick_OpenAfterDelay;
        this.openAfterDelayButton = new Button((Composite)buttonComposite, 16416);
        this.openAfterDelayButton.setText(label);
        this.openAfterDelayButton.setEnabled(this.openOnSingleClick);
        this.openAfterDelayButton.setSelection(this.openAfterDelay);
        this.openAfterDelayButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.openAfterDelay = this.openAfterDelayButton.getSelection();
        }));
        data = new GridData();
        data.horizontalIndent = LayoutConstants.getIndent();
        this.openAfterDelayButton.setLayoutData((Object)data);
        this.createNoteComposite(font, (Composite)buttonComposite, WorkbenchMessages.Preference_note, WorkbenchMessages.WorkbenchPreference_noEffectOnAllViews);
    }

    protected void createRenameModeGroup(Composite composite) {
        Group buttonComposite = new Group(composite, 16384);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setText(WorkbenchMessages.WorkbenchPreference_renameMode);
        String label = WorkbenchMessages.WorkbenchPreference_renameModeInline;
        this.renameModeInlineButton = WorkbenchPreferencePage.createRadioButton((Composite)buttonComposite, label);
        this.renameModeInlineButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.renameModeInline = this.renameModeInlineButton.getSelection();
        }));
        this.renameModeInlineButton.setSelection(this.renameModeInline);
        label = WorkbenchMessages.WorkbenchPreference_renameModeDialog;
        this.renameModeDialogButton = WorkbenchPreferencePage.createRadioButton((Composite)buttonComposite, label);
        this.renameModeDialogButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.renameModeInline = !this.renameModeDialogButton.getSelection();
        }));
        this.renameModeDialogButton.setSelection(!this.renameModeInline);
    }

    private void selectClickMode(boolean singleClick) {
        this.openOnSingleClick = singleClick;
        this.selectOnHoverButton.setEnabled(this.openOnSingleClick);
        this.openAfterDelayButton.setEnabled(this.openOnSingleClick);
    }

    protected static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        return button;
    }

    protected static Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected static void createSpace(Composite parent) {
        Label vfiller = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        vfiller.setLayoutData((Object)gridData);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    @Override
    public void init(IWorkbench aWorkbench) {
        IPreferenceStore store = this.getPreferenceStore();
        this.openOnSingleClick = store.getBoolean("OPEN_ON_SINGLE_CLICK");
        this.selectOnHover = store.getBoolean("SELECT_ON_HOVER");
        this.openAfterDelay = store.getBoolean("OPEN_AFTER_DELAY");
        this.readRenameModeFromPreferences();
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.saveInterval.loadDefault();
        this.stickyCycleButton.setSelection(store.getBoolean("STICKY_CYCLE"));
        this.openOnSingleClick = store.getDefaultBoolean("OPEN_ON_SINGLE_CLICK");
        this.selectOnHover = store.getDefaultBoolean("SELECT_ON_HOVER");
        this.openAfterDelay = store.getDefaultBoolean("OPEN_AFTER_DELAY");
        this.singleClickButton.setSelection(this.openOnSingleClick);
        this.doubleClickButton.setSelection(!this.openOnSingleClick);
        this.selectOnHoverButton.setSelection(this.selectOnHover);
        this.openAfterDelayButton.setSelection(this.openAfterDelay);
        this.selectOnHoverButton.setEnabled(this.openOnSingleClick);
        this.openAfterDelayButton.setEnabled(this.openOnSingleClick);
        this.stickyCycleButton.setSelection(store.getDefaultBoolean("STICKY_CYCLE"));
        this.showUserDialogButton.setSelection(store.getDefaultBoolean("RUN_IN_BACKGROUND"));
        this.showHeapStatusButton.setSelection(PrefUtil.getAPIPreferenceStore().getDefaultBoolean("SHOW_MEMORY_MONITOR"));
        String defaultRenameMode = store.getDefaultString("RESOURCE_RENAME_MODE");
        this.renameModeInline = !"dialog".equals(defaultRenameMode);
        this.renameModeInlineButton.setSelection(this.renameModeInline);
        this.renameModeDialogButton.setSelection(!this.renameModeInline);
        super.performDefaults();
    }

    public boolean performOk() {
        int singleClickMethod;
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("STICKY_CYCLE", this.stickyCycleButton.getSelection());
        store.setValue("OPEN_ON_SINGLE_CLICK", this.openOnSingleClick);
        store.setValue("SELECT_ON_HOVER", this.selectOnHover);
        store.setValue("OPEN_AFTER_DELAY", this.openAfterDelay);
        store.setValue("RUN_IN_BACKGROUND", this.showUserDialogButton.getSelection());
        store.setValue("WORKBENCH_SAVE_INTERVAL", this.saveInterval.getIntValue());
        String renameModeValue = "inline";
        if (!this.renameModeInline) {
            renameModeValue = "dialog";
        }
        store.setValue("RESOURCE_RENAME_MODE", renameModeValue);
        PrefUtil.getAPIPreferenceStore().setValue("SHOW_MEMORY_MONITOR", this.showHeapStatusButton.getSelection());
        this.updateHeapStatus(this.showHeapStatusButton.getSelection());
        int n = singleClickMethod = this.openOnSingleClick ? 1 : 0;
        if (this.openOnSingleClick) {
            if (this.selectOnHover) {
                singleClickMethod |= 2;
            }
            if (this.openAfterDelay) {
                singleClickMethod |= 4;
            }
        }
        OpenStrategy.setOpenMethod((int)singleClickMethod);
        PrefUtil.savePrefs();
        return true;
    }

    private void updateHeapStatus(boolean selection) {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            if (window instanceof WorkbenchWindow) {
                ((WorkbenchWindow)window).showHeapStatus(selection);
            }
            ++n2;
        }
    }

    private void readRenameModeFromPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        String renameMode = store.getString("RESOURCE_RENAME_MODE");
        this.renameModeInline = !"dialog".equals(renameMode);
    }
}

