/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.internal.util.Tracing;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.ICompositeOperation;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationApprover2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;

public final class DefaultOperationHistory
implements IOperationHistory {
    public static boolean DEBUG_OPERATION_HISTORY_NOTIFICATION;
    public static boolean DEBUG_OPERATION_HISTORY_UNEXPECTED;
    public static boolean DEBUG_OPERATION_HISTORY_DISPOSE;
    public static boolean DEBUG_OPERATION_HISTORY_OPENOPERATION;
    public static boolean DEBUG_OPERATION_HISTORY_APPROVAL;
    static final int DEFAULT_LIMIT = 20;
    ListenerList<IOperationApprover> approvers = new ListenerList(1);
    private Map<IUndoContext, Integer> limits = Collections.synchronizedMap(new HashMap());
    ListenerList<IOperationHistoryListener> listeners = new ListenerList(1);
    private List<IUndoableOperation> redoList = Collections.synchronizedList(new ArrayList());
    private List<IUndoableOperation> undoList = Collections.synchronizedList(new ArrayList());
    final Object undoRedoHistoryLock = new Object();
    private ICompositeOperation openComposite;
    final Object openCompositeLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(IUndoableOperation operation) {
        Assert.isNotNull((Object)operation);
        Object object = this.openCompositeLock;
        synchronized (object) {
            if (this.openComposite != null && this.openComposite != operation) {
                this.openComposite.add(operation);
                return;
            }
        }
        if (this.checkUndoLimit(operation)) {
            IUndoContext[] contexts;
            object = this.undoRedoHistoryLock;
            synchronized (object) {
                this.undoList.add(operation);
            }
            this.notifyAdd(operation);
            IUndoContext[] iUndoContextArray = contexts = operation.getContexts();
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                IUndoContext context = iUndoContextArray[n2];
                this.flushRedo(context);
                ++n2;
            }
        } else {
            operation.dispose();
        }
    }

    @Override
    public void addOperationApprover(IOperationApprover approver) {
        this.approvers.add((Object)approver);
    }

    @Override
    public void addOperationHistoryListener(IOperationHistoryListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public boolean canRedo(IUndoContext context) {
        IUndoableOperation operation = this.getRedoOperation(context);
        return operation != null && operation.canRedo();
    }

    @Override
    public boolean canUndo(IUndoContext context) {
        IUndoableOperation operation = this.getUndoOperation(context);
        return operation != null && operation.canUndo();
    }

    private boolean checkRedoLimit(IUndoableOperation operation) {
        IUndoContext[] contexts;
        IUndoContext[] iUndoContextArray = contexts = operation.getContexts();
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IUndoContext context = iUndoContextArray[n2];
            int limit = this.getLimit(context);
            if (limit > 0) {
                this.forceRedoLimit(context, limit - 1);
            } else {
                operation.removeContext(context);
            }
            ++n2;
        }
        return operation.getContexts().length > 0;
    }

    private boolean checkUndoLimit(IUndoableOperation operation) {
        IUndoContext[] contexts;
        IUndoContext[] iUndoContextArray = contexts = operation.getContexts();
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IUndoContext context = iUndoContextArray[n2];
            int limit = this.getLimit(context);
            if (limit > 0) {
                this.forceUndoLimit(context, limit - 1);
            } else {
                operation.removeContext(context);
            }
            ++n2;
        }
        return operation.getContexts().length > 0;
    }

    @Override
    public void dispose(IUndoContext context, boolean flushUndo, boolean flushRedo, boolean flushContext) {
        if (flushContext) {
            if (DEBUG_OPERATION_HISTORY_DISPOSE) {
                Tracing.printTrace("OPERATIONHISTORY", "Flushing context " + context);
            }
            this.flushUndo(context);
            this.flushRedo(context);
            this.limits.remove(context);
            return;
        }
        if (flushUndo) {
            this.flushUndo(context);
        }
        if (flushRedo) {
            this.flushRedo(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus doRedo(IProgressMonitor monitor, IAdaptable info, IUndoableOperation operation) throws ExecutionException {
        IStatus status = this.getRedoApproval(operation, info);
        if (status.isOK()) {
            this.notifyAboutToRedo(operation);
            try {
                status = operation.redo(monitor, info);
            }
            catch (OperationCanceledException operationCanceledException) {
                status = Status.CANCEL_STATUS;
            }
            catch (ExecutionException e) {
                this.notifyNotOK(operation);
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    Tracing.printTrace("OPERATIONHISTORY", "ExecutionException while redoing " + operation);
                }
                throw e;
            }
            catch (Exception e) {
                this.notifyNotOK(operation);
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    Tracing.printTrace("OPERATIONHISTORY", "Exception while redoing " + operation);
                }
                throw new ExecutionException("While redoing the operation, an exception occurred", e);
            }
        }
        if (status.isOK()) {
            boolean addedToUndo = true;
            Object object = this.undoRedoHistoryLock;
            synchronized (object) {
                this.redoList.remove(operation);
                if (this.checkUndoLimit(operation)) {
                    this.undoList.add(operation);
                } else {
                    addedToUndo = false;
                }
            }
            if (!addedToUndo) {
                operation.dispose();
            }
            this.notifyRedone(operation);
        } else {
            this.notifyNotOK(operation, status);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus doUndo(IProgressMonitor monitor, IAdaptable info, IUndoableOperation operation) throws ExecutionException {
        IStatus status = this.getUndoApproval(operation, info);
        if (status.isOK()) {
            this.notifyAboutToUndo(operation);
            try {
                status = operation.undo(monitor, info);
            }
            catch (OperationCanceledException operationCanceledException) {
                status = Status.CANCEL_STATUS;
            }
            catch (ExecutionException e) {
                this.notifyNotOK(operation);
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    Tracing.printTrace("OPERATIONHISTORY", "ExecutionException while undoing " + operation);
                }
                throw e;
            }
            catch (Exception e) {
                this.notifyNotOK(operation);
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    Tracing.printTrace("OPERATIONHISTORY", "Exception while undoing " + operation);
                }
                throw new ExecutionException("While undoing the operation, an exception occurred", e);
            }
        }
        if (status.isOK()) {
            boolean addedToRedo = true;
            Object object = this.undoRedoHistoryLock;
            synchronized (object) {
                this.undoList.remove(operation);
                if (this.checkRedoLimit(operation)) {
                    this.redoList.add(operation);
                } else {
                    addedToRedo = false;
                }
            }
            if (!addedToRedo) {
                operation.dispose();
            }
            this.notifyUndone(operation);
        } else {
            this.notifyNotOK(operation, status);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus execute(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Assert.isNotNull((Object)operation);
        if (!operation.canExecute()) {
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }
        IStatus status = this.getExecuteApproval(operation, info);
        if (!status.isOK()) {
            return status;
        }
        boolean merging = false;
        Object object = this.openCompositeLock;
        synchronized (object) {
            if (this.openComposite != null) {
                if (this.openComposite == operation) {
                    return IOperationHistory.OPERATION_INVALID_STATUS;
                }
                this.openComposite.add(operation);
                merging = true;
            }
        }
        if (!merging) {
            this.notifyAboutToExecute(operation);
        }
        try {
            status = operation.execute(monitor, info);
        }
        catch (OperationCanceledException operationCanceledException) {
            status = Status.CANCEL_STATUS;
        }
        catch (ExecutionException e) {
            this.notifyNotOK(operation);
            throw e;
        }
        catch (Exception e) {
            this.notifyNotOK(operation);
            throw new ExecutionException("While executing the operation, an exception occurred", e);
        }
        if (!merging) {
            if (status.isOK()) {
                this.notifyDone(operation);
                this.add(operation);
            } else {
                this.notifyNotOK(operation, status);
                operation.dispose();
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IUndoableOperation[] filter(List<IUndoableOperation> list, IUndoContext context) {
        ArrayList<IUndoableOperation> filtered = new ArrayList<IUndoableOperation>();
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            for (IUndoableOperation operation : list) {
                if (!operation.hasContext(context)) continue;
                filtered.add(operation);
            }
        }
        return filtered.toArray(new IUndoableOperation[filtered.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushRedo(IUndoContext context) {
        if (DEBUG_OPERATION_HISTORY_DISPOSE) {
            Tracing.printTrace("OPERATIONHISTORY", "Flushing redo history for " + context);
        }
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            IUndoableOperation[] filtered;
            IUndoableOperation[] iUndoableOperationArray = filtered = this.filter(this.redoList, context);
            int n = filtered.length;
            int n2 = 0;
            while (n2 < n) {
                IUndoableOperation element;
                IUndoableOperation operation = element = iUndoableOperationArray[n2];
                if (context == GLOBAL_UNDO_CONTEXT || operation.getContexts().length == 1) {
                    this.redoList.remove(operation);
                    this.internalRemove(operation);
                } else {
                    IUndoContext[] iUndoContextArray = operation.getContexts();
                    int n3 = iUndoContextArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IUndoContext undoContext = iUndoContextArray[n4];
                        if (undoContext.matches(context)) {
                            operation.removeContext(undoContext);
                        }
                        ++n4;
                    }
                    if (operation.getContexts().length == 0) {
                        this.redoList.remove(operation);
                        this.internalRemove(operation);
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushUndo(IUndoContext context) {
        if (DEBUG_OPERATION_HISTORY_DISPOSE) {
            Tracing.printTrace("OPERATIONHISTORY", "Flushing undo history for " + context);
        }
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            IUndoableOperation[] filtered;
            IUndoableOperation[] iUndoableOperationArray = filtered = this.filter(this.undoList, context);
            int n = filtered.length;
            int n2 = 0;
            while (n2 < n) {
                IUndoableOperation element;
                IUndoableOperation operation = element = iUndoableOperationArray[n2];
                if (context == GLOBAL_UNDO_CONTEXT || operation.getContexts().length == 1) {
                    this.undoList.remove(operation);
                    this.internalRemove(operation);
                } else {
                    IUndoContext[] iUndoContextArray = operation.getContexts();
                    int n3 = iUndoContextArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IUndoContext undoContext = iUndoContextArray[n4];
                        if (undoContext.matches(context)) {
                            operation.removeContext(undoContext);
                        }
                        ++n4;
                    }
                    if (operation.getContexts().length == 0) {
                        this.undoList.remove(operation);
                        this.internalRemove(operation);
                    }
                }
                ++n2;
            }
        }
        ICompositeOperation endedComposite = null;
        Object object2 = this.openCompositeLock;
        synchronized (object2) {
            if (this.openComposite != null && this.openComposite.hasContext(context)) {
                if (context == GLOBAL_UNDO_CONTEXT || this.openComposite.getContexts().length == 1) {
                    endedComposite = this.openComposite;
                    this.openComposite = null;
                } else {
                    this.openComposite.removeContext(context);
                }
            }
        }
        if (endedComposite != null) {
            this.notifyNotOK(endedComposite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceRedoLimit(IUndoContext context, int max) {
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            IUndoableOperation[] filtered = this.filter(this.redoList, context);
            int size = filtered.length;
            if (size > 0) {
                int index = 0;
                while (size > max) {
                    IUndoableOperation removed = filtered[index];
                    if (context == GLOBAL_UNDO_CONTEXT || removed.getContexts().length == 1) {
                        this.redoList.remove(removed);
                        this.internalRemove(removed);
                    } else {
                        removed.removeContext(context);
                    }
                    --size;
                    ++index;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceUndoLimit(IUndoContext context, int max) {
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            IUndoableOperation[] filtered = this.filter(this.undoList, context);
            int size = filtered.length;
            if (size > 0) {
                int index = 0;
                while (size > max) {
                    IUndoableOperation removed = filtered[index];
                    if (context == GLOBAL_UNDO_CONTEXT || removed.getContexts().length == 1) {
                        this.undoList.remove(removed);
                        this.internalRemove(removed);
                    } else {
                        removed.removeContext(context);
                    }
                    --size;
                    ++index;
                }
            }
        }
    }

    @Override
    public int getLimit(IUndoContext context) {
        if (!this.limits.containsKey(context)) {
            return 20;
        }
        return this.limits.get(context);
    }

    private IStatus getRedoApproval(IUndoableOperation operation, IAdaptable info) {
        for (IOperationApprover approver : this.approvers) {
            IStatus approval = approver.proceedRedoing(operation, this, info);
            if (approval.isOK()) continue;
            if (DEBUG_OPERATION_HISTORY_APPROVAL) {
                Tracing.printTrace("OPERATIONHISTORY", "Redo not approved by " + approver + "for operation " + operation + " approved by " + approval);
            }
            return approval;
        }
        return Status.OK_STATUS;
    }

    @Override
    public IUndoableOperation[] getRedoHistory(IUndoContext context) {
        Assert.isNotNull((Object)context);
        return this.filter(this.redoList, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IUndoableOperation getRedoOperation(IUndoContext context) {
        Assert.isNotNull((Object)context);
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            int i = this.redoList.size() - 1;
            while (i >= 0) {
                IUndoableOperation operation = this.redoList.get(i);
                if (operation.hasContext(context)) {
                    return operation;
                }
                --i;
            }
        }
        return null;
    }

    private IStatus getUndoApproval(IUndoableOperation operation, IAdaptable info) {
        for (IOperationApprover approver : this.approvers) {
            IStatus approval = approver.proceedUndoing(operation, this, info);
            if (approval.isOK()) continue;
            if (DEBUG_OPERATION_HISTORY_APPROVAL) {
                Tracing.printTrace("OPERATIONHISTORY", "Undo not approved by " + approver + "for operation " + operation + " with status " + approval);
            }
            return approval;
        }
        return Status.OK_STATUS;
    }

    @Override
    public IUndoableOperation[] getUndoHistory(IUndoContext context) {
        Assert.isNotNull((Object)context);
        return this.filter(this.undoList, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IUndoableOperation getUndoOperation(IUndoContext context) {
        Assert.isNotNull((Object)context);
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            int i = this.undoList.size() - 1;
            while (i >= 0) {
                IUndoableOperation operation = this.undoList.get(i);
                if (operation.hasContext(context)) {
                    return operation;
                }
                --i;
            }
        }
        return null;
    }

    private IStatus getExecuteApproval(IUndoableOperation operation, IAdaptable info) {
        for (IOperationApprover tmp : this.approvers) {
            IOperationApprover2 approver;
            IStatus approval;
            if (!(tmp instanceof IOperationApprover2) || (approval = (approver = (IOperationApprover2)tmp).proceedExecuting(operation, this, info)).isOK()) continue;
            if (DEBUG_OPERATION_HISTORY_APPROVAL) {
                Tracing.printTrace("OPERATIONHISTORY", "Execute not approved by " + approver + "for operation " + operation + " with status " + approval);
            }
            return approval;
        }
        return Status.OK_STATUS;
    }

    private void internalRemove(IUndoableOperation operation) {
        operation.dispose();
        this.notifyRemoved(operation);
    }

    private void notifyListeners(final OperationHistoryEvent event) {
        if (event.getOperation() instanceof IAdvancedUndoableOperation) {
            final IAdvancedUndoableOperation advancedOp = (IAdvancedUndoableOperation)((Object)event.getOperation());
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                        Tracing.printTrace("OPERATIONHISTORY", "Exception during notification callback " + exception);
                    }
                }

                public void run() throws Exception {
                    advancedOp.aboutToNotify(event);
                }
            });
        }
        for (final IOperationHistoryListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                        Tracing.printTrace("OPERATIONHISTORY", "Exception during notification callback " + exception);
                    }
                }

                public void run() throws Exception {
                    listener.historyNotification(event);
                }
            });
        }
    }

    private void notifyAboutToExecute(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "ABOUT_TO_EXECUTE " + operation);
        }
        this.notifyListeners(new OperationHistoryEvent(1, this, operation));
    }

    private void notifyAboutToRedo(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "ABOUT_TO_REDO " + operation);
        }
        this.notifyListeners(new OperationHistoryEvent(2, this, operation));
    }

    private void notifyAboutToUndo(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "ABOUT_TO_UNDO " + operation);
        }
        this.notifyListeners(new OperationHistoryEvent(3, this, operation));
    }

    private void notifyAdd(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "OPERATION_ADDED " + operation);
        }
        this.notifyListeners(new OperationHistoryEvent(5, this, operation));
    }

    private void notifyDone(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "DONE " + operation);
        }
        this.notifyListeners(new OperationHistoryEvent(4, this, operation));
    }

    private void notifyNotOK(IUndoableOperation operation) {
        this.notifyNotOK(operation, null);
    }

    private void notifyNotOK(IUndoableOperation operation, IStatus status) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "OPERATION_NOT_OK " + operation);
        }
        this.notifyListeners(new OperationHistoryEvent(7, this, operation, status));
    }

    private void notifyRedone(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "REDONE " + operation);
        }
        this.notifyListeners(new OperationHistoryEvent(9, this, operation));
    }

    private void notifyRemoved(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "OPERATION_REMOVED " + operation);
        }
        this.notifyListeners(new OperationHistoryEvent(8, this, operation));
    }

    private void notifyUndone(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "UNDONE " + operation);
        }
        this.notifyListeners(new OperationHistoryEvent(10, this, operation));
    }

    private void notifyChanged(IUndoableOperation operation) {
        if (DEBUG_OPERATION_HISTORY_NOTIFICATION) {
            Tracing.printTrace("OPERATIONHISTORY", "OPERATION_CHANGED " + operation);
        }
        this.notifyListeners(new OperationHistoryEvent(6, this, operation));
    }

    @Override
    public IStatus redo(IUndoContext context, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Assert.isNotNull((Object)context);
        IUndoableOperation operation = this.getRedoOperation(context);
        if (operation == null) {
            return IOperationHistory.NOTHING_TO_REDO_STATUS;
        }
        if (!operation.canRedo()) {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                Tracing.printTrace("OPERATIONHISTORY", "Redo operation not valid - " + operation);
            }
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }
        return this.doRedo(monitor, info, operation);
    }

    @Override
    public IStatus redoOperation(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status;
        Assert.isNotNull((Object)operation);
        if (operation.canRedo()) {
            status = this.doRedo(monitor, info, operation);
        } else {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                Tracing.printTrace("OPERATIONHISTORY", "Redo operation not valid - " + operation);
            }
            status = IOperationHistory.OPERATION_INVALID_STATUS;
        }
        return status;
    }

    @Override
    public void removeOperationApprover(IOperationApprover approver) {
        this.approvers.remove((Object)approver);
    }

    @Override
    public void removeOperationHistoryListener(IOperationHistoryListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceOperation(IUndoableOperation operation, IUndoableOperation[] replacements) {
        Object replacement;
        IUndoContext opContext;
        int n;
        int n2;
        IUndoContext[] iUndoContextArray;
        IUndoContext[] opContexts;
        int n3;
        IUndoableOperation[] iUndoableOperationArray;
        ArrayList<IUndoContext> allContexts2;
        int index;
        boolean inUndo = false;
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            index = this.undoList.indexOf(operation);
            if (index > -1) {
                inUndo = true;
                this.undoList.remove(operation);
                allContexts2 = new ArrayList<IUndoContext>(replacements.length);
                iUndoableOperationArray = replacements;
                n3 = replacements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IUndoableOperation replacement2 = iUndoableOperationArray[n4];
                    iUndoContextArray = opContexts = replacement2.getContexts();
                    n2 = opContexts.length;
                    n = 0;
                    while (n < n2) {
                        opContext = iUndoContextArray[n];
                        allContexts2.add(opContext);
                        ++n;
                    }
                    this.undoList.add(index, replacement2);
                    ++n4;
                }
                int i = 0;
                while (i < allContexts2.size()) {
                    IUndoContext context = (IUndoContext)allContexts2.get(i);
                    this.forceUndoLimit(context, this.getLimit(context));
                    ++i;
                }
            }
        }
        if (inUndo) {
            this.internalRemove(operation);
            IUndoableOperation[] i = replacements;
            int allContexts2 = replacements.length;
            index = 0;
            while (index < allContexts2) {
                replacement = i[index];
                this.notifyAdd((IUndoableOperation)replacement);
                ++index;
            }
            return;
        }
        replacement = this.undoRedoHistoryLock;
        synchronized (replacement) {
            index = this.redoList.indexOf(operation);
            if (index == -1) {
                return;
            }
            allContexts2 = new ArrayList(replacements.length);
            this.redoList.remove(operation);
            iUndoableOperationArray = replacements;
            n3 = replacements.length;
            int context = 0;
            while (context < n3) {
                IUndoableOperation replacement3 = iUndoableOperationArray[context];
                iUndoContextArray = opContexts = replacement3.getContexts();
                n2 = opContexts.length;
                n = 0;
                while (n < n2) {
                    opContext = iUndoContextArray[n];
                    allContexts2.add(opContext);
                    ++n;
                }
                this.redoList.add(index, replacement3);
                ++context;
            }
            int i = 0;
            while (i < allContexts2.size()) {
                IUndoContext context2 = (IUndoContext)allContexts2.get(i);
                this.forceRedoLimit(context2, this.getLimit(context2));
                ++i;
            }
        }
        this.internalRemove(operation);
        IUndoableOperation[] iUndoableOperationArray2 = replacements;
        int n5 = replacements.length;
        int n6 = 0;
        while (n6 < n5) {
            replacement = iUndoableOperationArray2[n6];
            this.notifyAdd((IUndoableOperation)replacement);
            ++n6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLimit(IUndoContext context, int limit) {
        Assert.isTrue((limit >= 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)context);
        this.limits.put(context, limit);
        Object object = this.undoRedoHistoryLock;
        synchronized (object) {
            this.forceUndoLimit(context, limit);
            this.forceRedoLimit(context, limit);
        }
    }

    @Override
    public IStatus undo(IUndoContext context, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Assert.isNotNull((Object)context);
        IUndoableOperation operation = this.getUndoOperation(context);
        if (operation == null) {
            return IOperationHistory.NOTHING_TO_UNDO_STATUS;
        }
        if (!operation.canUndo()) {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                Tracing.printTrace("OPERATIONHISTORY", "Undo operation not valid - " + operation);
            }
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }
        return this.doUndo(monitor, info, operation);
    }

    @Override
    public IStatus undoOperation(IUndoableOperation operation, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status;
        Assert.isNotNull((Object)operation);
        if (operation.canUndo()) {
            status = this.doUndo(monitor, info, operation);
        } else {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                Tracing.printTrace("OPERATIONHISTORY", "Undo operation not valid - " + operation);
            }
            status = IOperationHistory.OPERATION_INVALID_STATUS;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openOperation(ICompositeOperation operation, int mode) {
        Object object = this.openCompositeLock;
        synchronized (object) {
            if (this.openComposite != null && this.openComposite != operation) {
                if (DEBUG_OPERATION_HISTORY_UNEXPECTED) {
                    Tracing.printTrace("OPERATIONHISTORY", "Open operation called while another operation is open.  old: " + this.openComposite + "; new:  " + operation);
                }
                throw new IllegalStateException("Cannot open an operation while one is already open");
            }
            this.openComposite = operation;
        }
        if (DEBUG_OPERATION_HISTORY_OPENOPERATION) {
            Tracing.printTrace("OPERATIONHISTORY", "Opening operation " + this.openComposite);
        }
        if (mode == 1) {
            this.notifyAboutToExecute(this.openComposite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOperation(boolean operationOK, boolean addToHistory, int mode) {
        ICompositeOperation endedComposite = null;
        Object object = this.openCompositeLock;
        synchronized (object) {
            if (DEBUG_OPERATION_HISTORY_UNEXPECTED && this.openComposite == null) {
                Tracing.printTrace("OPERATIONHISTORY", "Attempted to close operation when none was open");
                return;
            }
            if (this.openComposite != null) {
                if (DEBUG_OPERATION_HISTORY_OPENOPERATION) {
                    Tracing.printTrace("OPERATIONHISTORY", "Closing operation " + this.openComposite);
                }
                endedComposite = this.openComposite;
                this.openComposite = null;
            }
        }
        if (endedComposite != null) {
            if (operationOK) {
                if (mode == 1) {
                    this.notifyDone(endedComposite);
                }
                if (addToHistory) {
                    this.add(endedComposite);
                }
            } else if (mode == 1) {
                this.notifyNotOK(endedComposite);
            }
        }
    }

    @Override
    public void operationChanged(IUndoableOperation operation) {
        if (this.undoList.contains(operation) || this.redoList.contains(operation)) {
            this.notifyChanged(operation);
        }
    }
}

