/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.AntFilterStore;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchReporter;
import org.eclipse.pde.api.tools.internal.provisional.search.IMetadata;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.SkippedComponent;
import org.eclipse.pde.api.tools.internal.search.XmlReferenceDescriptorWriter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSearchReporter
implements IApiSearchReporter {
    private String fLocation = null;
    private DocumentBuilder parser = null;
    private boolean debug = false;
    private int referenceCount = 0;
    private int illegalCount = 0;
    private int internalCount = 0;

    public XmlSearchReporter(String location, boolean debug) {
        this.fLocation = location;
        this.debug = debug;
        try {
            this.parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.parser.setErrorHandler(new DefaultHandler());
        }
        catch (FactoryConfigurationError fce) {
            ApiPlugin.log(fce);
        }
        catch (ParserConfigurationException pce) {
            ApiPlugin.log(pce);
        }
    }

    @Override
    public void reportResults(IApiElement element, IReference[] references) {
        if (references.length == 0) {
            return;
        }
        HashSet<IReferenceDescriptor> writtenReferences = new HashSet<IReferenceDescriptor>();
        XmlReferenceDescriptorWriter writer = new XmlReferenceDescriptorWriter(this.fLocation);
        ArrayList<IReferenceDescriptor> descriptors = new ArrayList<IReferenceDescriptor>(references.length + 1);
        IReference[] iReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IReference referenceInterface = iReferenceArray[n2];
            Reference reference = (Reference)referenceInterface;
            try {
                IReferenceDescriptor descriptor = reference.getReferenceDescriptor();
                descriptors.add(descriptor);
                if (!writtenReferences.contains(descriptor)) {
                    ++this.referenceCount;
                    if ((referenceInterface.getReferenceFlags() & 1) > 0) {
                        ++this.illegalCount;
                    }
                    if (descriptor.getVisibility() == 2) {
                        ++this.internalCount;
                    }
                    writtenReferences.add(descriptor);
                }
            }
            catch (CoreException e) {
                ApiPlugin.log(e.getStatus());
            }
            ++n2;
        }
        writer.writeReferences(descriptors.toArray(new IReferenceDescriptor[descriptors.size()]));
    }

    String getId(IApiComponent component) throws CoreException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(component.getSymbolicName()).append(" ").append('(').append(component.getVersion()).append(')');
        return buffer.toString();
    }

    @Override
    public void reportNotSearched(IApiElement[] elements) {
        if (elements == null) {
            return;
        }
        if (this.debug) {
            System.out.println("Writing file for projects that were not searched...");
        }
        File rootfile = new File(this.fLocation);
        File file = new File(rootfile, "not_searched.xml");
        try {
            if (!rootfile.exists()) {
                rootfile.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            Document doc = Util.newDocument();
            Element root = doc.createElement("components");
            doc.appendChild(root);
            Element comp = null;
            SkippedComponent component = null;
            IApiElement[] iApiElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IApiElement element = iApiElementArray[n2];
                component = (SkippedComponent)element;
                comp = doc.createElement("component");
                comp.setAttribute("id", component.getComponentId());
                comp.setAttribute("version", component.getVersion());
                comp.setAttribute("details", component.getErrorDetails());
                root.appendChild(comp);
                ++n2;
            }
            Throwable throwable = null;
            Object var9_13 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                writer.write(Util.serializeDocument(doc));
                writer.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            ApiPlugin.log("Failed to report missing projects into " + file, e);
        }
    }

    @Override
    public void reportMetadata(IMetadata data) {
        if (data == null) {
            return;
        }
        try {
            File file;
            File rootfile;
            if (this.debug) {
                System.out.println("Writing file for projects that were not searched...");
            }
            if (!(rootfile = new File(this.fLocation)).exists()) {
                rootfile.mkdirs();
            }
            if (!(file = new File(rootfile, "meta.xml")).exists()) {
                file.createNewFile();
            }
            data.serializeToFile(file);
        }
        catch (FileNotFoundException fnfe) {
            ApiPlugin.log(fnfe);
        }
        catch (IOException ioe) {
            ApiPlugin.log(ioe);
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
        }
    }

    @Override
    public void reportCounts() {
        if (this.debug) {
            System.out.println("Writing file for counting total references...");
        }
        File rootfile = new File(this.fLocation);
        File file = new File(rootfile, "counts.xml");
        try {
            if (!rootfile.exists()) {
                rootfile.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            Document doc = Util.newDocument();
            Element root = doc.createElement("reportedcount");
            doc.appendChild(root);
            root.setAttribute("total", Integer.toString(this.referenceCount));
            root.setAttribute("illegal", Integer.toString(this.illegalCount));
            root.setAttribute("internal", Integer.toString(this.internalCount));
            root.setAttribute("filtered", Integer.toString(AntFilterStore.filteredAPIProblems.size()));
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                writer.write(Util.serializeDocument(doc));
                writer.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            ApiPlugin.log("Failed to report tota counts into " + file, e);
        }
    }
}

