/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.registry.internal;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.equinox.http.registry.internal.ExtensionPointTracker;
import org.eclipse.equinox.http.registry.internal.HttpRegistryManager;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FilterManager
implements ExtensionPointTracker.Listener {
    private static final String FILTERS_EXTENSION_POINT = "org.eclipse.equinox.http.registry.filters";
    private static final String HTTPCONTEXT_NAME = "httpcontext-name";
    private static final String PARAM_VALUE = "value";
    private static final String PARAM_NAME = "name";
    private static final String INIT_PARAM = "init-param";
    private static final String ALIAS = "alias";
    private static final String LOAD_ON_STARTUP = "load-on-startup";
    private static final String HTTPCONTEXT_ID = "httpcontextId";
    private static final String SERVICESELECTOR = "serviceSelector";
    private static final String CLASS = "class";
    private static final String FILTER = "filter";
    private ExtensionPointTracker tracker;
    private HttpRegistryManager httpRegistryManager;
    private Map registered = new HashMap();
    private ServiceReference reference;

    public FilterManager(HttpRegistryManager httpRegistryManager, ServiceReference reference, IExtensionRegistry registry) {
        this.httpRegistryManager = httpRegistryManager;
        this.reference = reference;
        this.tracker = new ExtensionPointTracker(registry, FILTERS_EXTENSION_POINT, this);
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    public void added(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement serviceSelectorElement = elements[i];
            if (SERVICESELECTOR.equals(serviceSelectorElement.getName())) {
                Filter serviceSelector = null;
                String clazz = serviceSelectorElement.getAttribute(CLASS);
                if (clazz != null) {
                    try {
                        serviceSelector = (Filter)serviceSelectorElement.createExecutableExtension(CLASS);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                String filter = serviceSelectorElement.getAttribute(FILTER);
                if (filter == null) {
                    return;
                }
                try {
                    serviceSelector = FrameworkUtil.createFilter((String)filter);
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                    return;
                }
                if (serviceSelector.match(this.reference)) break;
                return;
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            IConfigurationElement filterElement = elements[i];
            if (FILTER.equals(filterElement.getName())) {
                FilterWrapper wrapper = new FilterWrapper(filterElement);
                String alias = filterElement.getAttribute(ALIAS);
                if (alias != null) {
                    String httpContextId;
                    Hashtable<String, String> initparams = new Hashtable<String, String>();
                    IConfigurationElement[] initParams = filterElement.getChildren(INIT_PARAM);
                    int j = 0;
                    while (j < initParams.length) {
                        String paramName = initParams[j].getAttribute(PARAM_NAME);
                        String paramValue = initParams[j].getAttribute(PARAM_VALUE);
                        ((Dictionary)initparams).put(paramName, paramValue);
                        ++j;
                    }
                    boolean loadOnStartup = Boolean.valueOf(filterElement.getAttribute(LOAD_ON_STARTUP));
                    if (loadOnStartup) {
                        wrapper.setLoadOnStartup();
                    }
                    if ((httpContextId = filterElement.getAttribute(HTTPCONTEXT_ID)) == null) {
                        httpContextId = filterElement.getAttribute(HTTPCONTEXT_NAME);
                    }
                    if (httpContextId != null && httpContextId.indexOf(46) == -1) {
                        httpContextId = String.valueOf(filterElement.getNamespaceIdentifier()) + "." + httpContextId;
                    }
                    if (this.httpRegistryManager.addFilterContribution(alias, wrapper, initparams, httpContextId, extension.getContributor())) {
                        this.registered.put(filterElement, wrapper);
                    }
                }
            }
            ++i;
        }
    }

    public void removed(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement filterElement = elements[i];
            javax.servlet.Filter filter = (javax.servlet.Filter)this.registered.remove(filterElement);
            if (filter != null) {
                this.httpRegistryManager.removeFilterContribution(filter);
            }
            ++i;
        }
    }

    private static class FilterWrapper
    implements javax.servlet.Filter {
        private IConfigurationElement element;
        private javax.servlet.Filter delegate;
        private FilterConfig config;
        private boolean loadOnStartup = false;

        public FilterWrapper(IConfigurationElement element) {
            this.element = element;
        }

        public void setLoadOnStartup() {
            this.loadOnStartup = true;
        }

        public void init(FilterConfig filterConfig) throws ServletException {
            this.config = filterConfig;
            if (this.loadOnStartup) {
                this.initializeDelegate();
            }
        }

        public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain chain) throws ServletException, IOException {
            this.initializeDelegate();
            this.delegate.doFilter(arg0, arg1, chain);
        }

        public void destroy() {
            this.destroyDelegate();
        }

        private synchronized void initializeDelegate() throws ServletException {
            if (this.delegate == null) {
                try {
                    javax.servlet.Filter newDelegate = (javax.servlet.Filter)this.element.createExecutableExtension(FilterManager.CLASS);
                    newDelegate.init(this.config);
                    this.delegate = newDelegate;
                }
                catch (CoreException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }

        private synchronized void destroyDelegate() {
            if (this.delegate != null) {
                javax.servlet.Filter doomedDelegate = this.delegate;
                this.delegate = null;
                doomedDelegate.destroy();
            }
        }
    }
}

