/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.trace;

import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.trace.ITraceLocation;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;

public enum GitTraceLocation implements ITraceLocation
{
    CORE("/debug/core"),
    INDEXDIFFCACHE("/debug/core/indexdiffcache"),
    JSCH("/debug/core/jsch");

    private final String location;
    private final String fullPath;
    private boolean active = false;
    private static DebugTrace myTrace;

    public static void initializeFromOptions(DebugOptions options, boolean pluginIsDebugging) {
        if (pluginIsDebugging) {
            myTrace = options.newDebugTrace(Activator.getPluginId());
            GitTraceLocation[] gitTraceLocationArray = GitTraceLocation.values();
            int n = gitTraceLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                GitTraceLocation loc = gitTraceLocationArray[n2];
                boolean active = options.getBooleanOption(loc.getFullPath(), false);
                loc.setActive(active);
                ++n2;
            }
        } else {
            GitTraceLocation[] gitTraceLocationArray = GitTraceLocation.values();
            int n = gitTraceLocationArray.length;
            int n3 = 0;
            while (n3 < n) {
                GitTraceLocation loc = gitTraceLocationArray[n3];
                loc.setActive(false);
                ++n3;
            }
        }
    }

    private GitTraceLocation(String path) {
        this.fullPath = String.valueOf(Activator.getPluginId()) + path;
        this.location = path;
    }

    public static DebugTrace getTrace() {
        return myTrace;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    private void setActive(boolean active) {
        this.active = active;
    }
}

