/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.logging.Q7LoggingManager;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.ui.PropertyNode;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeType;
import org.eclipse.rcptt.tesla.core.ui.UiFactory;
import org.eclipse.rcptt.tesla.swt.reflection.MemberValueHelper;
import org.eclipse.rcptt.util.ReflectionUtil;

public class JavaMembersHelper {
    public static final String NULL_CONST = "null";
    public static final String VOID_CONST = "void";
    public static final String CLASS_NAME_PROPERTY = "getClassName";
    public static final String CLASS_NAME_PROPERTY_CAPTION = "getClassName()";
    public static final String ARRAY_LENGTH_PROPERTY_CAPTION = "length";
    private static final List<String> allowedFileds = new ArrayList<String>();
    private static final List<String> excludedFileds = new ArrayList<String>();
    private static final List<String> allowedMethods = new ArrayList<String>();
    private static final List<String> excludedMethods = new ArrayList<String>();
    private static final Pattern indexedPattern;

    static {
        allowedFileds.add(".*");
        excludedFileds.add("handle");
        allowedMethods.add("get.*");
        allowedMethods.add("is.*");
        allowedMethods.add("has.*");
        allowedMethods.add("size");
        excludedMethods.add("getClass");
        excludedMethods.add("getDisplay");
        excludedMethods.add("getDevice");
        excludedMethods.add("getMonitor");
        excludedMethods.add("isDisposed");
        excludedMethods.add("java.lang.Object.hashCode");
        excludedMethods.add("org.eclipse.swt.widgets.Shell.getToolBar");
        indexedPattern = Pattern.compile("(.*)\\[(\\d+)\\]");
    }

    public static Object getRawPropertyValue(Object object, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyValue value = PropertyPath.fromString(nodePath).getValue(object);
        return value.isProperty() ? value.getStringValue() : value.getRawValue();
    }

    public static String getPropertyValue(Object object, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyValue value = PropertyPath.fromString(nodePath).getValue(object);
        return value.isProperty() ? value.getStringValue() : null;
    }

    public static boolean fillProperties(Object object, String nodePath, EList<PropertyNode> propertiesNodes) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object node = PropertyPath.fromString((String)nodePath).getValue((Object)object).rawValue;
        if (node != null) {
            JavaMembersHelper.fillProperties(node, propertiesNodes);
            return true;
        }
        return false;
    }

    public static void fillProperties(Object object, EList<PropertyNode> propertiesNodes) throws IllegalArgumentException {
        if (object == null) {
            return;
        }
        PropertyNode classNode = UiFactory.eINSTANCE.createPropertyNode();
        classNode.setName(CLASS_NAME_PROPERTY_CAPTION);
        classNode.setType(PropertyNodeType.PROPERTY);
        classNode.setValue(MemberValueHelper.getClassName(object));
        propertiesNodes.add((Object)classNode);
        if (object.getClass().isArray()) {
            JavaMembersHelper.fillArrayProperties(object, propertiesNodes);
        }
        if (object instanceof List) {
            JavaMembersHelper.fillListProperties(object, propertiesNodes);
        }
        MembersContainer members = JavaMembersHelper.collectObjectMembers(object);
        for (Field field : members.getFields()) {
            if (TeslaFeatures.isActivityLogging()) {
                Q7LoggingManager.logMessage((String)"widget.properties", (String)("\t\tprocess field: " + object.getClass().getName() + "." + field.getName()));
            }
            JavaMembersHelper.processField(field, object, propertiesNodes);
        }
        for (Method method : members.getMethods()) {
            if (TeslaFeatures.isActivityLogging()) {
                Q7LoggingManager.logMessage((String)"widget.properties", (String)("\t\tprocess method: " + object.getClass().getName() + "." + method.getName()));
            }
            JavaMembersHelper.processMethod(method, object, propertiesNodes);
        }
        JavaMembersHelper.mapToString(object, propertiesNodes);
    }

    private static void mapToString(Object object, List<PropertyNode> nodes) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray() || object instanceof List) {
            return;
        }
        nodes.size();
        Method toString = ReflectionUtil.findMethod(object.getClass(), (String)"toString");
        if (toString == null || toString.getDeclaringClass().equals(Object.class)) {
            return;
        }
        String value = null;
        try {
            value = (String)toString.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return;
        }
        if (value != null && value.length() > 16384) {
            return;
        }
        PropertyNode stringNode = UiFactory.eINSTANCE.createPropertyNode();
        stringNode.setName("toString()");
        stringNode.setType(PropertyNodeType.PROPERTY);
        stringNode.setValue(value == null ? NULL_CONST : value);
        nodes.add(stringNode);
    }

    private static void fillArrayProperties(Object object, EList<PropertyNode> propertiesNodes) {
        int length = Array.getLength(object);
        PropertyNode lenghtNode = UiFactory.eINSTANCE.createPropertyNode();
        lenghtNode.setName(ARRAY_LENGTH_PROPERTY_CAPTION);
        lenghtNode.setType(PropertyNodeType.PROPERTY);
        lenghtNode.setValue(Integer.toString(length));
        propertiesNodes.add((Object)lenghtNode);
        Class<?> itemsType = object.getClass().getComponentType();
        int i = 0;
        while (i < length) {
            Object item = Array.get(object, i);
            String strValue = MemberValueHelper.getFormattedValue(item, "", item.getClass(), object);
            PropertyNodeType type = MemberValueHelper.detectType(item.getClass());
            if (PropertyNodeType.REFERENCE.equals((Object)type) && NULL_CONST.equals(strValue)) {
                type = PropertyNodeType.PROPERTY;
            }
            PropertyNode propertyNode = UiFactory.eINSTANCE.createPropertyNode();
            propertyNode.setName(String.valueOf(itemsType.getSimpleName()) + "[" + i + "]");
            propertyNode.setType(type);
            if (type.equals((Object)PropertyNodeType.PROPERTY)) {
                propertyNode.setValue(strValue);
            }
            propertiesNodes.add((Object)propertyNode);
            ++i;
        }
    }

    private static void fillListProperties(Object object, EList<PropertyNode> propertiesNodes) {
        List list = (List)object;
        int idx = 0;
        for (Object item : list) {
            String strValue = MemberValueHelper.getFormattedValue(item, "", item.getClass(), object);
            PropertyNodeType type = MemberValueHelper.detectType(item.getClass());
            if (PropertyNodeType.REFERENCE.equals((Object)type) && NULL_CONST.equals(strValue)) {
                type = PropertyNodeType.PROPERTY;
            }
            PropertyNode propertyNode = UiFactory.eINSTANCE.createPropertyNode();
            propertyNode.setName(String.valueOf(item.getClass().getSimpleName()) + "[" + idx + "]");
            propertyNode.setType(type);
            if (type.equals((Object)PropertyNodeType.PROPERTY)) {
                propertyNode.setValue(strValue);
            }
            propertiesNodes.add((Object)propertyNode);
            ++idx;
        }
    }

    private static void processField(Field field, Object object, EList<PropertyNode> propertiesNodes) {
        Object value = null;
        String strValue = null;
        PropertyNodeType type = null;
        try {
            value = field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
        strValue = MemberValueHelper.getFormattedValue(value, field.getName(), field.getType(), object);
        type = MemberValueHelper.detectType(field.getType());
        if (PropertyNodeType.REFERENCE.equals((Object)type) && NULL_CONST.equals(strValue)) {
            type = PropertyNodeType.PROPERTY;
        }
        PropertyNode propertyNode = UiFactory.eINSTANCE.createPropertyNode();
        propertyNode.setName(field.getName());
        propertyNode.setType(type);
        if (type.equals((Object)PropertyNodeType.PROPERTY)) {
            propertyNode.setValue(strValue);
        }
        propertiesNodes.add((Object)propertyNode);
    }

    private static void processMethod(Method method, Object object, EList<PropertyNode> propertiesNodes) {
        Object value = null;
        String strValue = null;
        PropertyNodeType type = null;
        try {
            value = method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        strValue = MemberValueHelper.getFormattedValue(value, method.getName(), method.getReturnType(), object);
        type = MemberValueHelper.detectType(method.getReturnType());
        if (PropertyNodeType.REFERENCE.equals((Object)type) && NULL_CONST.equals(strValue)) {
            type = PropertyNodeType.PROPERTY;
        }
        PropertyNode propertyNode = UiFactory.eINSTANCE.createPropertyNode();
        propertyNode.setName(String.valueOf(method.getName()) + "()");
        propertyNode.setType(type);
        if (type.equals((Object)PropertyNodeType.PROPERTY)) {
            propertyNode.setValue(strValue);
        }
        propertiesNodes.add((Object)propertyNode);
    }

    private static MembersContainer collectObjectMembers(Object object) {
        if (object == null) {
            return null;
        }
        MembersContainer container = new MembersContainer();
        JavaMembersHelper.collectMembers(object.getClass(), container);
        return container;
    }

    private static void collectMembers(Class<?> clazz, MembersContainer acc) {
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            if (JavaMembersHelper.checkField(field)) {
                field.setAccessible(true);
                acc.addField(field);
            }
            ++n2;
        }
        accessibleObjectArray = clazz.getDeclaredMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject method = accessibleObjectArray[n2];
            if (JavaMembersHelper.checkMethod((Method)method)) {
                ((Method)method).setAccessible(true);
                acc.addMethod((Method)method);
            }
            ++n2;
        }
        Class<?> parent = clazz.getSuperclass();
        if (parent != null) {
            JavaMembersHelper.collectMembers(parent, acc);
        }
    }

    private static boolean isVisible(Member member) {
        int modifiers = member.getModifiers();
        if ((modifiers & 8) != 0) {
            return false;
        }
        if ((modifiers & 1) != 0) {
            return true;
        }
        return (modifiers & 4) != 0 && TeslaFeatures.isProtectedEnabled();
    }

    private static boolean checkField(Field field) {
        if (!JavaMembersHelper.isVisible(field)) {
            return false;
        }
        for (String pattern : excludedFileds) {
            if (!JavaMembersHelper.matchesExclusion(field, pattern)) continue;
            return false;
        }
        for (String pattern : allowedFileds) {
            if (!field.getName().matches(pattern)) continue;
            return true;
        }
        return true;
    }

    private static boolean checkMethod(Method method) {
        if (!JavaMembersHelper.isVisible(method)) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        String name = method.getName();
        for (String pattern : excludedMethods) {
            if (!JavaMembersHelper.matchesExclusion(method, pattern)) continue;
            return false;
        }
        for (String pattern : allowedMethods) {
            if (!name.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesExclusion(Member slot, String exclusion) {
        String className;
        int lastDotIndex = exclusion.lastIndexOf(".");
        String methodName = lastDotIndex == -1 ? exclusion : exclusion.substring(lastDotIndex + 1);
        String string = className = lastDotIndex == -1 ? null : exclusion.substring(0, lastDotIndex);
        if (!methodName.equals(slot.getName())) {
            return false;
        }
        if (className == null) {
            return true;
        }
        return JavaMembersHelper.typeMatches(slot.getDeclaringClass(), className);
    }

    private static boolean typeMatches(Class<?> clazz, String name) {
        if (clazz == null) {
            return false;
        }
        if (clazz.getName().equals(name)) {
            return true;
        }
        if (JavaMembersHelper.typeMatches(clazz.getSuperclass(), name)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            if (JavaMembersHelper.typeMatches(iface, name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static class FieldNode
    extends Node {
        public FieldNode(String fieldName) {
            super(fieldName);
        }

        @Override
        PropertyValue getValue(Object object) throws IllegalArgumentException, IllegalAccessException {
            if (object.getClass().isArray() && JavaMembersHelper.ARRAY_LENGTH_PROPERTY_CAPTION.equals(this.memberName)) {
                return new PropertyValue(object, Array.getLength(object), this.memberName, Integer.TYPE);
            }
            Field field = ReflectionUtil.findField(object.getClass(), (String)this.memberName);
            field.setAccessible(true);
            Object value = field.get(object);
            return new PropertyValue(object, value, this.memberName, field.getType());
        }
    }

    private static class IndexNode
    extends Node {
        final int index;
        final String elementType;

        public IndexNode(Node parent, String elementType, int index) {
            super(parent == null ? "" : parent.memberName);
            this.elementType = elementType;
            this.index = index;
        }

        @Override
        PropertyValue getValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Object value = null;
            if (object.getClass().isArray()) {
                value = Array.get(object, this.index);
            } else if (object instanceof List) {
                value = ((List)object).get(this.index);
            } else {
                throw new IllegalArgumentException("Can't get indexed value from object of type " + object.getClass().getName());
            }
            return new PropertyValue(object, value, this.elementType, object.getClass().isArray() ? object.getClass().getComponentType() : (value == null ? Object.class : value.getClass()));
        }
    }

    private static class MembersContainer {
        private final List<Field> fields = new ArrayList<Field>();
        private final List<Method> methods = new ArrayList<Method>();
        private final Set<String> memberNames = new HashSet<String>();

        private MembersContainer() {
        }

        public void addField(Field field) {
            String name = field.getName();
            if (this.memberNames.contains(name)) {
                return;
            }
            this.memberNames.add(name);
            this.fields.add(field);
        }

        public void addMethod(Method method) {
            String name = method.getName();
            if (this.memberNames.contains(name)) {
                return;
            }
            this.memberNames.add(name);
            this.methods.add(method);
        }

        public Iterable<Field> getFields() {
            return this.fields;
        }

        public Iterable<Method> getMethods() {
            return this.methods;
        }
    }

    private static class MethodNode
    extends Node {
        public MethodNode(String methodName) {
            super(methodName);
        }

        @Override
        PropertyValue getValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.memberName.equals(JavaMembersHelper.CLASS_NAME_PROPERTY)) {
                return new PropertyValue(object, MemberValueHelper.getClassName(object), JavaMembersHelper.CLASS_NAME_PROPERTY, String.class);
            }
            Method method = ReflectionUtil.findMethod(object.getClass(), (String)this.memberName);
            method.setAccessible(true);
            Object value = method.invoke(object, new Object[0]);
            return new PropertyValue(object, value, this.memberName, method.getReturnType());
        }
    }

    private static abstract class Node {
        final String memberName;

        public Node(String memberName) {
            this.memberName = memberName;
        }

        abstract PropertyValue getValue(Object var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

        final PropertyValue getValue(PropertyValue parent) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return this.getValue(parent.rawValue);
        }
    }

    private static class PropertyPath {
        private final Node[] nodes;

        public static PropertyPath fromString(String nodePath) {
            if (nodePath.length() == 0) {
                return new PropertyPath(new Node[0]);
            }
            String[] items = nodePath.split("\\.");
            ArrayList<Node> nodes = new ArrayList<Node>();
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.endsWith("()")) {
                    nodes.add(new MethodNode(item.substring(0, item.length() - 2)));
                } else {
                    Matcher m = indexedPattern.matcher(item);
                    if (m.matches()) {
                        IndexNode node = new IndexNode(nodes.isEmpty() ? null : (Node)nodes.get(nodes.size() - 1), m.group(1), Integer.parseInt(m.group(2)));
                        nodes.add(node);
                    } else {
                        nodes.add(new FieldNode(item));
                    }
                }
                ++n2;
            }
            return new PropertyPath(nodes.toArray(new Node[nodes.size()]));
        }

        private PropertyPath(Node[] nodes) {
            this.nodes = nodes;
        }

        public PropertyValue getValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            PropertyValue result = PropertyValue.fromObject(object);
            Node[] nodeArray = this.nodes;
            int n = this.nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                result = node.getValue(result);
                ++n2;
            }
            return result;
        }
    }

    private static class PropertyValue {
        final Object parent;
        final Object rawValue;
        final String memberName;
        final Class<?> declaredType;

        public PropertyValue(Object parent, Object rawValue, String memberName, Class<?> declaredType) {
            this.rawValue = rawValue;
            this.memberName = memberName;
            this.declaredType = declaredType;
            this.parent = parent;
        }

        public static PropertyValue fromObject(Object value) {
            return new PropertyValue(null, value, "", value.getClass());
        }

        public boolean isProperty() {
            return this.rawValue == null || MemberValueHelper.detectType(this.declaredType) == PropertyNodeType.PROPERTY;
        }

        public String getStringValue() {
            return MemberValueHelper.getFormattedValue(this.rawValue, this.memberName, this.declaredType, this.parent);
        }

        public Object getRawValue() {
            return this.rawValue;
        }
    }
}

