/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.wizards.TeamWizardPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ExportProjectSetMainPage
extends TeamWizardPage {
    PageBook book;
    ProjectPage projectPage;
    WorkingSetPage workingSetPage;
    IExportProjectSetPage selectedPage;
    Button exportWorkingSets;
    ArrayList<IProject> passedInSelectedProjects = new ArrayList();

    private IProject[] getProjectsForObject(Object object) {
        ResourceMapping resourceMapping = Utils.getResourceMapping(object);
        if (resourceMapping != null) {
            return resourceMapping.getProjects();
        }
        IResource resource = Utils.getResource(object);
        if (resource != null && resource.getType() != 8) {
            return new IProject[]{resource.getProject()};
        }
        return null;
    }

    private IProject[] getProjectsForAdaptables(IAdaptable[] adaptable) {
        HashSet<IProject> projectSet = new HashSet<IProject>();
        int i = 0;
        while (i < adaptable.length) {
            IProject[] projects = this.getProjectsForObject(adaptable[i]);
            if (projects != null) {
                projectSet.addAll(Arrays.asList(projects));
            }
            ++i;
        }
        if (!projectSet.isEmpty()) {
            return projectSet.toArray(new IProject[0]);
        }
        return null;
    }

    private static boolean isWorkingSetSupported(IWorkingSet workingSet) {
        if (!workingSet.isEmpty() && !workingSet.isAggregateWorkingSet()) {
            IAdaptable[] elements = workingSet.getElements();
            int i = 0;
            while (i < elements.length) {
                IResource resource = ResourceUtil.getResource((Object)elements[i]);
                if (resource != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isProjectExportable(IProject project) {
        return RepositoryProvider.getProvider((IProject)project) != null;
    }

    public ExportProjectSetMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(TeamUIMessages.ExportProjectSetMainPage_Initial_description);
    }

    public void createControl(Composite parent) {
        Composite c = SWTUtils.createHVFillComposite(parent, 0);
        this.exportWorkingSets(c);
        this.book = new PageBook(c, 0);
        this.book.setLayoutData((Object)SWTUtils.createHVFillGridData());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.book, "org.eclipse.team.ui.export_project_set_page_context");
        this.workingSetPage = new WorkingSetPage();
        this.workingSetPage.createControl((Composite)this.book);
        this.projectPage = new ProjectPage();
        ArrayList<IProject> passedInExportableProjects = new ArrayList<IProject>();
        for (IProject project : this.passedInSelectedProjects) {
            if (!this.isProjectExportable(project)) continue;
            passedInExportableProjects.add(project);
        }
        this.projectPage.getSelectedProjects().addAll(passedInExportableProjects);
        this.projectPage.getReferenceCountProjects().addAll(passedInExportableProjects);
        this.projectPage.createControl((Composite)this.book);
        this.setControl((Control)c);
        this.book.showPage(this.projectPage.getControl());
        this.selectedPage = this.projectPage;
        Dialog.applyDialogFont((Control)parent);
    }

    private void exportWorkingSets(Composite composite) {
        this.exportWorkingSets = new Button(composite, 16416);
        this.exportWorkingSets.setText(TeamUIMessages.ExportProjectSetMainPage_ExportWorkingSets);
        this.exportWorkingSets.setSelection(false);
        this.exportWorkingSets.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    ExportProjectSetMainPage.this.book.showPage(ExportProjectSetMainPage.this.workingSetPage.getControl());
                    ExportProjectSetMainPage.this.selectedPage = ExportProjectSetMainPage.this.workingSetPage;
                    ExportProjectSetMainPage.this.workingSetPage.refresh();
                    ExportProjectSetMainPage.this.workingSetPage.updateEnablement();
                } else {
                    ExportProjectSetMainPage.this.book.showPage(ExportProjectSetMainPage.this.projectPage.getControl());
                    ExportProjectSetMainPage.this.selectedPage = ExportProjectSetMainPage.this.projectPage;
                    ExportProjectSetMainPage.this.projectPage.updateEnablement();
                }
            }
        });
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this.selectedPage.getWorkingSet().toArray(new IWorkingSet[this.selectedPage.getWorkingSet().size()]);
    }

    public IProject[] getSelectedProjects() {
        return this.selectedPage.getSelectedProjects().toArray(new IProject[this.selectedPage.getSelectedProjects().size()]);
    }

    public IProject[] getReferenceCountProjects() {
        return this.selectedPage.getReferenceCountProjects().toArray(new IProject[this.selectedPage.getReferenceCountProjects().size()]);
    }

    public void setSelectedProjects(IProject[] selectedProjects) {
        this.passedInSelectedProjects.addAll(Arrays.asList(selectedProjects));
    }

    private class ExportProjectSetLabelProvider
    extends WorkbenchLabelProvider {
        private ExportProjectSetLabelProvider() {
        }

        public Color getForeground(Object element) {
            if (element instanceof IProject && !ExportProjectSetMainPage.this.isProjectExportable((IProject)element)) {
                return Display.getCurrent().getSystemColor(18);
            }
            return super.getForeground(element);
        }
    }

    private static interface IExportProjectSetPage {
        public HashSet getSelectedProjects();

        public ArrayList getReferenceCountProjects();

        public ArrayList getWorkingSet();
    }

    class ProjectContentProvider
    implements ITreePathContentProvider {
        ProjectContentProvider() {
        }

        public Object[] getChildren(TreePath parentPath) {
            Object obj = parentPath.getLastSegment();
            if (obj instanceof IWorkingSet) {
                return ((IWorkingSet)obj).getElements();
            }
            return null;
        }

        public TreePath[] getParents(Object element) {
            if (element instanceof IProject) {
                ArrayList<IWorkingSet> treePaths = new ArrayList<IWorkingSet>();
                IWorkingSet[] workingSets = TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager().getWorkingSets();
                int i = 0;
                while (i < workingSets.length) {
                    IAdaptable[] elements = workingSets[i].getElements();
                    int j = 0;
                    while (j < elements.length) {
                        if (elements[j].equals(element)) {
                            treePaths.add(workingSets[i]);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                return treePaths.toArray(new TreePath[treePaths.size()]);
            }
            return null;
        }

        public boolean hasChildren(TreePath path) {
            Object obj = path.getLastSegment();
            return obj instanceof IWorkingSet;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IWorkspaceRoot) {
                IWorkspaceRoot root = (IWorkspaceRoot)inputElement;
                ArrayList<IProject> projectList = new ArrayList<IProject>();
                IProject[] workspaceProjects = root.getProjects();
                int i = 0;
                while (i < workspaceProjects.length) {
                    if (ExportProjectSetMainPage.this.isProjectExportable(workspaceProjects[i])) {
                        projectList.add(workspaceProjects[i]);
                    }
                    ++i;
                }
                return projectList.toArray(new IProject[projectList.size()]);
            }
            if (inputElement instanceof IWorkingSetManager) {
                IWorkingSetManager manager = (IWorkingSetManager)inputElement;
                IWorkingSet[] allSets = manager.getAllWorkingSets();
                ArrayList<IWorkingSet> resourceSets = new ArrayList<IWorkingSet>();
                int i = 0;
                while (i < allSets.length) {
                    if (ExportProjectSetMainPage.isWorkingSetSupported(allSets[i])) {
                        resourceSets.add(allSets[i]);
                    }
                    ++i;
                }
                return resourceSets.toArray(new IWorkingSet[resourceSets.size()]);
            }
            if (inputElement instanceof IAdaptable) {
                Object[] tempProjects = ExportProjectSetMainPage.this.getProjectsForObject(inputElement);
                if (tempProjects != null) {
                    return tempProjects;
                }
            } else {
                if (inputElement instanceof IAdaptable[]) {
                    IAdaptable[] tempAdaptable = (IAdaptable[])inputElement;
                    return ExportProjectSetMainPage.this.getProjectsForAdaptables(tempAdaptable);
                }
                if (inputElement instanceof HashSet) {
                    HashSet<IProject> tempList = new HashSet<IProject>();
                    HashSet inputElementSet = (HashSet)inputElement;
                    Iterator iterator = inputElementSet.iterator();
                    while (iterator.hasNext()) {
                        IProject[] projects = ExportProjectSetMainPage.this.getProjectsForObject(iterator.next());
                        if (projects == null) continue;
                        tempList.addAll(Arrays.asList(projects));
                    }
                    return tempList.toArray(new IProject[tempList.size()]);
                }
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ProjectPage
    extends Page
    implements IExportProjectSetPage {
        private Composite projectComposite;
        private CheckboxTableViewer tableViewer;
        private Table table;
        HashSet selectedProjects = new HashSet();
        ArrayList referenceCountProjects = new ArrayList();
        ArrayList selectedWorkingSet = new ArrayList();

        private ProjectPage() {
        }

        public void createControl(Composite parent) {
            this.projectComposite = SWTUtils.createHVFillComposite(parent, 1);
            ExportProjectSetMainPage.this.initializeDialogUnits((Control)this.projectComposite);
            this.addProjectSection(this.projectComposite);
            this.initializeProjects();
            ExportProjectSetMainPage.this.setPageComplete(this.selectedProjects.size() > 0);
        }

        public Control getControl() {
            return this.projectComposite;
        }

        public void setFocus() {
            this.projectComposite.setFocus();
        }

        private void addProjectSection(Composite composite) {
            ExportProjectSetMainPage.this.createLabel(composite, TeamUIMessages.ExportProjectSetMainPage_Select_the_projects_to_include_in_the_project_set__2);
            this.table = new Table(composite, 2848);
            this.tableViewer = new CheckboxTableViewer(this.table);
            this.table.setLayout((Layout)new TableLayout());
            GridData data = new GridData(1808);
            data.heightHint = 300;
            this.table.setLayoutData((Object)data);
            this.tableViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.tableViewer.setComparator((ViewerComparator)new ResourceComparator(1));
            this.tableViewer.addCheckStateListener(event -> {
                Object temp = event.getElement();
                if (temp instanceof IProject) {
                    IProject project = (IProject)event.getElement();
                    if (event.getChecked()) {
                        this.selectedProjects.add(project);
                        this.referenceCountProjects.add(project);
                    } else {
                        this.selectedProjects.remove(project);
                        this.referenceCountProjects.remove(project);
                    }
                } else if (temp instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)temp;
                    if (event.getChecked()) {
                        IAdaptable[] elements1 = workingSet.getElements();
                        int i1 = 0;
                        while (i1 < elements1.length) {
                            this.selectedProjects.add(elements1[i1]);
                            ++i1;
                        }
                    } else {
                        IAdaptable[] elements2 = workingSet.getElements();
                        int i2 = 0;
                        while (i2 < elements2.length) {
                            this.selectedProjects.remove(elements2[i2]);
                            ++i2;
                        }
                    }
                }
                this.updateEnablement();
            });
            Composite buttonComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            buttonComposite.setLayout((Layout)layout);
            data = new GridData(4, 4, true, false);
            buttonComposite.setLayoutData((Object)data);
            Button selectAll = new Button(buttonComposite, 8);
            data = new GridData();
            data.verticalAlignment = 1;
            data.horizontalAlignment = 3;
            int widthHint = ExportProjectSetMainPage.this.convertHorizontalDLUsToPixels(61);
            data.widthHint = Math.max(widthHint, selectAll.computeSize((int)-1, (int)-1, (boolean)true).x);
            selectAll.setLayoutData((Object)data);
            selectAll.setText(TeamUIMessages.ExportProjectSetMainPage_SelectAll);
            selectAll.addListener(13, event -> {
                this.tableViewer.setAllChecked(true);
                this.selectedProjects.removeAll(this.selectedProjects);
                Object[] checked = this.tableViewer.getCheckedElements();
                int i = 0;
                while (i < checked.length) {
                    this.selectedProjects.add(checked[i]);
                    ++i;
                }
                this.updateEnablement();
            });
            Button deselectAll = new Button(buttonComposite, 8);
            data = new GridData();
            data.verticalAlignment = 1;
            data.horizontalAlignment = 3;
            widthHint = ExportProjectSetMainPage.this.convertHorizontalDLUsToPixels(61);
            data.widthHint = Math.max(widthHint, deselectAll.computeSize((int)-1, (int)-1, (boolean)true).x);
            deselectAll.setLayoutData((Object)data);
            deselectAll.setText(TeamUIMessages.ExportProjectSetMainPage_DeselectAll);
            deselectAll.addListener(13, event -> {
                this.tableViewer.setAllChecked(false);
                this.selectedProjects.removeAll(this.selectedProjects);
                this.updateEnablement();
            });
        }

        private void initializeProjects() {
            this.tableViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            if (this.selectedProjects != null) {
                this.tableViewer.setCheckedElements((Object[])this.selectedProjects.toArray(new IProject[this.selectedProjects.size()]));
            }
        }

        private void updateEnablement() {
            boolean complete;
            boolean bl = complete = this.selectedProjects.size() > 0;
            if (complete) {
                ExportProjectSetMainPage.this.setErrorMessage(null);
                ExportProjectSetMainPage.this.setDescription(TeamUIMessages.ExportProjectSetMainPage_description);
            } else {
                ExportProjectSetMainPage.this.setErrorMessage(TeamUIMessages.ExportProjectSetMainPage_A_project_must_be_selected);
            }
            ExportProjectSetMainPage.this.setPageComplete(complete);
        }

        @Override
        public ArrayList getReferenceCountProjects() {
            return this.referenceCountProjects;
        }

        @Override
        public HashSet getSelectedProjects() {
            return this.selectedProjects;
        }

        @Override
        public ArrayList getWorkingSet() {
            return this.selectedWorkingSet;
        }
    }

    private class WorkingSetPage
    extends Page
    implements IExportProjectSetPage {
        private Composite projectComposite;
        private Table wsTable;
        private CheckboxTableViewer wsTableViewer;
        private Table table;
        private TableViewer tableViewer;
        HashSet<IProject> selectedProjects = new HashSet();
        ArrayList<IProject> referenceCountProjects = new ArrayList();
        ArrayList selectedWorkingSet = new ArrayList();
        private boolean pageShown = false;

        private WorkingSetPage() {
        }

        public void createControl(Composite parent) {
            this.projectComposite = SWTUtils.createHVFillComposite(parent, 1);
            ExportProjectSetMainPage.this.initializeDialogUnits((Control)this.projectComposite);
            Label label = ExportProjectSetMainPage.this.createLabel(this.projectComposite, TeamUIMessages.ExportProjectSetMainPage_SelectButton);
            GridData grid = (GridData)label.getLayoutData();
            label.setData((Object)grid);
            SashForm form = new SashForm(this.projectComposite, 256);
            form.setLayout((Layout)new FillLayout());
            GridData data = new GridData(1808);
            form.setLayoutData((Object)data);
            this.addWorkingSetSection((Composite)form);
            this.addProjectSection((Composite)form);
            form.setWeights(new int[]{50, 50});
            this.addButtons(this.projectComposite);
            ExportProjectSetMainPage.this.setPageComplete(false);
        }

        private void addProjectSection(Composite composite) {
            this.table = new Table(composite, 2816);
            this.tableViewer = new TableViewer(this.table);
            this.table.setLayout((Layout)new TableLayout());
            GridData data = new GridData(1808);
            data.heightHint = 300;
            this.table.setLayoutData((Object)data);
            this.tableViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new ExportProjectSetLabelProvider());
            this.tableViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        }

        private void addWorkingSetSection(Composite projectComposite) {
            this.wsTable = new Table(projectComposite, 2848);
            this.wsTableViewer = new CheckboxTableViewer(this.wsTable);
            this.wsTable.setLayout((Layout)new TableLayout());
            GridData data = new GridData(1808);
            data.heightHint = 300;
            this.wsTable.setLayoutData((Object)data);
            this.wsTableViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
            this.wsTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.wsTableViewer.addCheckStateListener(event -> {
                Object temp = event.getElement();
                if (temp instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)temp;
                    if (event.getChecked()) {
                        this.workingSetAdded(workingSet);
                        this.tableViewer.setInput(this.selectedProjects);
                    } else {
                        this.workingSetRemoved(workingSet);
                        this.tableViewer.setInput(this.selectedProjects);
                    }
                }
                this.updateEnablement();
            });
            this.wsTableViewer.setInput((Object)TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager());
        }

        private void addButtons(Composite projectComposite) {
            Composite buttonComposite = new Composite(projectComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            buttonComposite.setLayout((Layout)layout);
            GridData data = new GridData(4, 4, false, false);
            buttonComposite.setLayoutData((Object)data);
            Button selectAll = new Button(buttonComposite, 8);
            data = new GridData();
            data.verticalAlignment = 4;
            data.horizontalAlignment = 4;
            int widthHint = ExportProjectSetMainPage.this.convertHorizontalDLUsToPixels(61);
            data.widthHint = Math.max(widthHint, selectAll.computeSize((int)-1, (int)-1, (boolean)true).x);
            selectAll.setLayoutData((Object)data);
            selectAll.setText(TeamUIMessages.ExportProjectSetMainPage_SelectAll);
            selectAll.addListener(13, event -> {
                this.wsTableViewer.setAllChecked(true);
                this.selectedProjects.removeAll(this.selectedProjects);
                this.selectedWorkingSet.removeAll(this.selectedWorkingSet);
                Object[] checked = this.wsTableViewer.getCheckedElements();
                int i = 0;
                while (i < checked.length) {
                    this.selectedWorkingSet.add(checked[i]);
                    if (checked[i] instanceof IWorkingSet) {
                        IWorkingSet ws = (IWorkingSet)checked[i];
                        IAdaptable[] elements = ws.getElements();
                        this.addProjects(elements);
                    }
                    this.tableViewer.setInput(this.selectedProjects);
                    ++i;
                }
                this.updateEnablement();
            });
            Button deselectAll = new Button(buttonComposite, 8);
            data = new GridData();
            data.verticalAlignment = 4;
            data.horizontalAlignment = 4;
            widthHint = ExportProjectSetMainPage.this.convertHorizontalDLUsToPixels(61);
            data.widthHint = Math.max(widthHint, deselectAll.computeSize((int)-1, (int)-1, (boolean)true).x);
            deselectAll.setLayoutData((Object)data);
            deselectAll.setText(TeamUIMessages.ExportProjectSetMainPage_DeselectAll);
            deselectAll.addListener(13, event -> {
                this.wsTableViewer.setAllChecked(false);
                this.selectedWorkingSet.removeAll(this.selectedWorkingSet);
                this.selectedProjects.removeAll(this.selectedProjects);
                this.referenceCountProjects.removeAll(this.referenceCountProjects);
                this.tableViewer.setInput(this.selectedProjects);
                this.updateEnablement();
            });
            Button newWorkingSet = new Button(buttonComposite, 8);
            data = new GridData();
            data.verticalAlignment = 4;
            data.horizontalAlignment = 4;
            widthHint = ExportProjectSetMainPage.this.convertHorizontalDLUsToPixels(61);
            data.widthHint = Math.max(widthHint, deselectAll.computeSize((int)-1, (int)-1, (boolean)true).x);
            newWorkingSet.setLayoutData((Object)data);
            newWorkingSet.setText(TeamUIMessages.ExportProjectSetMainPage_EditButton);
            newWorkingSet.addListener(13, event -> {
                IWorkingSetManager workingSetManager = TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager();
                IWorkingSetSelectionDialog wsWizard = workingSetManager.createWorkingSetSelectionDialog(ExportProjectSetMainPage.this.getShell(), false);
                if (wsWizard != null) {
                    IPropertyChangeListener propListener = null;
                    try {
                        propListener = event1 -> {};
                        workingSetManager.addPropertyChangeListener(propListener);
                        wsWizard.open();
                        this.selectedWorkingSet.removeAll(this.selectedWorkingSet);
                        this.referenceCountProjects.removeAll(this.selectedProjects);
                        this.selectedProjects.removeAll(this.selectedProjects);
                        this.wsTableViewer.setInput((Object)workingSetManager);
                        Object[] checked = this.wsTableViewer.getCheckedElements();
                        int i = 0;
                        while (i < checked.length) {
                            this.selectedWorkingSet.add(checked[i]);
                            if (checked[i] instanceof IWorkingSet) {
                                IWorkingSet ws = (IWorkingSet)checked[i];
                                IAdaptable[] elements = ws.getElements();
                                this.addProjects(elements);
                            }
                            ++i;
                        }
                        this.wsTableViewer.setInput((Object)workingSetManager);
                        this.tableViewer.setInput(this.selectedProjects);
                    }
                    finally {
                        if (propListener != null) {
                            workingSetManager.removePropertyChangeListener(propListener);
                        }
                    }
                }
            });
        }

        public Control getControl() {
            return this.projectComposite;
        }

        public void setFocus() {
            this.projectComposite.setFocus();
        }

        public void refresh() {
            this.wsTableViewer.setInput((Object)TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager());
        }

        private void updateEnablement() {
            boolean complete;
            boolean allExportable = complete = this.selectedProjects.size() > 0 && this.selectedWorkingSet.size() > 0;
            if (complete || !this.pageShown) {
                complete = false;
                for (IProject selectedProject : this.selectedProjects) {
                    if (ExportProjectSetMainPage.this.isProjectExportable(selectedProject)) {
                        complete = true;
                        continue;
                    }
                    allExportable = false;
                }
                if (!complete && !this.pageShown) {
                    ExportProjectSetMainPage.this.setErrorMessage(null);
                    ExportProjectSetMainPage.this.setMessage(TeamUIMessages.ExportProjectSetMainPage_Initial_description);
                } else if (complete || !this.pageShown) {
                    if (allExportable) {
                        ExportProjectSetMainPage.this.setErrorMessage(null);
                        ExportProjectSetMainPage.this.setMessage(TeamUIMessages.ExportProjectSetMainPage_description);
                    } else {
                        ExportProjectSetMainPage.this.setErrorMessage(null);
                        ExportProjectSetMainPage.this.setMessage(TeamUIMessages.ExportProjectSetMainPage_warning, 2);
                    }
                } else {
                    ExportProjectSetMainPage.this.setErrorMessage(TeamUIMessages.ExportProjectSetMainPage_None_of_the_selected_working_sets_have_an_available_project_to_export);
                }
            } else {
                ExportProjectSetMainPage.this.setErrorMessage(TeamUIMessages.ExportProjectSetMainPage_A_working_set_must_be_selected);
            }
            ExportProjectSetMainPage.this.setPageComplete(complete);
            this.pageShown = true;
        }

        @Override
        public ArrayList getReferenceCountProjects() {
            return this.referenceCountProjects;
        }

        @Override
        public HashSet getSelectedProjects() {
            return this.selectedProjects;
        }

        @Override
        public ArrayList getWorkingSet() {
            return this.selectedWorkingSet;
        }

        private void workingSetAdded(IWorkingSet workingSet) {
            IAdaptable[] elements = workingSet.getElements();
            this.selectedWorkingSet.add(workingSet);
            this.addProjects(elements);
        }

        private void workingSetRemoved(IWorkingSet workingSet) {
            IAdaptable[] elements = workingSet.getElements();
            this.selectedWorkingSet.remove(workingSet);
            HashSet<IProject> tempSet = new HashSet<IProject>();
            int i = 0;
            while (i < elements.length) {
                IProject[] iProjectArray = ExportProjectSetMainPage.this.getProjectsForObject(elements[i]);
                if (iProjectArray != null) {
                    tempSet.addAll(Arrays.asList(iProjectArray));
                }
                ++i;
            }
            if (!tempSet.isEmpty()) {
                this.selectedProjects.removeAll(tempSet);
                for (Object e : tempSet) {
                    this.referenceCountProjects.remove(e);
                }
                this.selectedProjects.addAll(this.referenceCountProjects);
            }
        }

        private void addProjects(IAdaptable[] elements) {
            HashSet<IProject> tempSet = new HashSet<IProject>();
            int j = 0;
            while (j < elements.length) {
                IProject[] projects = ExportProjectSetMainPage.this.getProjectsForObject(elements[j]);
                if (projects != null) {
                    tempSet.addAll(Arrays.asList(projects));
                }
                ++j;
            }
            this.selectedProjects.addAll(tempSet);
            this.referenceCountProjects.addAll(tempSet);
        }
    }
}

