/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.breadcrumb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.BreadcrumbItem;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.IBreadcrumbDropDownSite;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class BreadcrumbViewer
extends StructuredViewer {
    private static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());
    private final int fStyle;
    private final Composite fContainer;
    private final ArrayList<BreadcrumbItem> fBreadcrumbItems;
    private final ListenerList<MenuDetectListener> fMenuListeners;
    private Image fGradientBackground;
    private BreadcrumbItem fSelectedItem;

    public BreadcrumbViewer(Composite parent, int style) {
        this.fStyle = style;
        this.fBreadcrumbItems = new ArrayList();
        this.fMenuListeners = new ListenerList();
        this.fContainer = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 128, true, false);
        this.fContainer.setLayoutData((Object)layoutData);
        this.fContainer.addTraverseListener(e -> {
            boolean bl = e.doit = true;
        });
        this.fContainer.setBackgroundMode(1);
        this.hookControl((Control)this.fContainer);
        int columns = 1000;
        if ((0x200 & style) != 0) {
            columns = 2;
        }
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.fContainer.setLayout((Layout)gridLayout);
        this.fContainer.addListener(11, event -> {
            this.updateSize();
            this.fContainer.layout(true, true);
        });
    }

    int getStyle() {
        return this.fStyle;
    }

    protected abstract Control createDropDown(Composite var1, IBreadcrumbDropDownSite var2, TreePath var3);

    public Control getControl() {
        return this.fContainer;
    }

    public void reveal(Object element) {
    }

    public void setFocus() {
        this.fContainer.setFocus();
        if (this.fSelectedItem != null) {
            this.fSelectedItem.setFocus(true);
        } else {
            if (this.fBreadcrumbItems.size() == 0) {
                return;
            }
            BreadcrumbItem item = this.fBreadcrumbItems.get(this.fBreadcrumbItems.size() - 1);
            item.setFocus(true);
        }
    }

    public boolean isDropDownOpen() {
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem item = this.fBreadcrumbItems.get(i);
            if (item.isMenuShown()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Shell getDropDownShell() {
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem item = this.fBreadcrumbItems.get(i);
            if (item.isMenuShown()) {
                return item.getDropDownShell();
            }
            ++i;
        }
        return null;
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.fMenuListeners.add((Object)listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.fMenuListeners.remove((Object)listener);
    }

    protected void assertContentProviderType(IContentProvider provider) {
        super.assertContentProviderType(provider);
        Assert.isTrue((boolean)(provider instanceof ITreePathContentProvider));
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (this.fContainer.isDisposed()) {
            return;
        }
        this.disableRedraw();
        try {
            this.preservingSelection(() -> this.buildItemChain(input));
        }
        finally {
            this.enableRedraw();
        }
    }

    protected Widget doFindInputItem(Object element) {
        if (element == null) {
            return null;
        }
        if (element == this.getInput() || element.equals(this.getInput())) {
            return this.doFindItem(element);
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        if (element == null) {
            return null;
        }
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem item = this.fBreadcrumbItems.get(i);
            if (item.getData() == element || element.equals(item.getData())) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        this.myDoUpdateItem(widget, element, fullMap);
    }

    private boolean myDoUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof BreadcrumbItem) {
            BreadcrumbItem item = (BreadcrumbItem)widget;
            if (fullMap) {
                this.associate(element, item);
            } else {
                Object data = item.getData();
                if (data != null) {
                    this.unmapElement(data, (Widget)item);
                }
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            this.refreshItem(item);
        }
        return false;
    }

    public ISelection getSelection() {
        TreePath path;
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return TreeSelection.EMPTY;
        }
        if (this.fSelectedItem != null && (path = this.getTreePathFromItem(this.fSelectedItem)) != null) {
            return new TreeSelection(new TreePath[]{path});
        }
        return TreeSelection.EMPTY;
    }

    protected TreePath getTreePathFromItem(BreadcrumbItem item) {
        ArrayList<Object> elements = new ArrayList<Object>(this.fBreadcrumbItems.size());
        int i = 0;
        while (i < this.fBreadcrumbItems.size()) {
            elements.add(this.fBreadcrumbItems.get(i).getData());
            if (((Object)((Object)this.fBreadcrumbItems.get(i))).equals((Object)item)) {
                return new TreePath(elements.toArray());
            }
            ++i;
        }
        return null;
    }

    protected List getSelectionFromWidget() {
        if (this.fSelectedItem == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.fSelectedItem.getData() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.fSelectedItem.getData());
        return result;
    }

    protected void internalRefresh(Object element) {
        this.disableRedraw();
        try {
            boolean layoutChanged = false;
            BreadcrumbItem item = (BreadcrumbItem)this.doFindItem(element);
            if (item == null || element != null && element.equals(this.getInput())) {
                int i = 0;
                int size = this.fBreadcrumbItems.size();
                while (i < size) {
                    BreadcrumbItem item1 = this.fBreadcrumbItems.get(i);
                    layoutChanged = this.refreshItem(item1) || layoutChanged;
                    ++i;
                }
            } else {
                boolean bl = layoutChanged = this.refreshItem(item) || layoutChanged;
            }
            if (layoutChanged) {
                this.updateSize();
                this.fContainer.layout(true, true);
            }
        }
        finally {
            this.enableRedraw();
        }
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        BreadcrumbItem item;
        BreadcrumbItem focusItem = null;
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            item = this.fBreadcrumbItems.get(i);
            if (item.hasFocus()) {
                focusItem = item;
            }
            item.setSelected(false);
            ++i;
        }
        if (l == null) {
            l = Collections.EMPTY_LIST;
        }
        this.fSelectedItem = null;
        for (Object element : l) {
            item = (BreadcrumbItem)this.doFindItem(element);
            if (item == null) continue;
            item.setSelected(true);
            this.fSelectedItem = item;
            if (item != focusItem) continue;
            focusItem = null;
        }
        if (this.fSelectedItem != null && focusItem != null) {
            focusItem.setFocus(false);
        }
    }

    void selectItem(BreadcrumbItem item) {
        if (this.fSelectedItem != null) {
            this.fSelectedItem.setSelected(false);
        }
        this.fSelectedItem = item;
        this.setSelectionToWidget(this.getSelection(), false);
        this.setFocus();
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    int getItemCount() {
        return this.fBreadcrumbItems.size();
    }

    BreadcrumbItem getItem(int index) {
        return this.fBreadcrumbItems.get(index);
    }

    int getIndexOfItem(BreadcrumbItem item) {
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem pItem = this.fBreadcrumbItems.get(i);
            if (pItem == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void fireDoubleClick() {
        this.fireDoubleClick(new DoubleClickEvent((Viewer)this, this.getSelection()));
    }

    void fireOpen() {
        this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
    }

    void fireMenuSelection(ISelection selection) {
        this.fireOpen(new OpenEvent((Viewer)this, selection));
    }

    void fireMenuDetect(MenuDetectEvent event) {
        for (MenuDetectListener menuDetectListener : this.fMenuListeners) {
            menuDetectListener.menuDetected(event);
        }
    }

    void doTraverse(boolean next) {
        if (this.fSelectedItem == null) {
            return;
        }
        int index = this.fBreadcrumbItems.indexOf((Object)this.fSelectedItem);
        if (next) {
            if (index == this.fBreadcrumbItems.size() - 1) {
                BreadcrumbItem current = this.fBreadcrumbItems.get(index);
                current.openDropDownMenu();
                current.getDropDownShell().setFocus();
            } else {
                BreadcrumbItem nextItem = this.fBreadcrumbItems.get(index + 1);
                this.selectItem(nextItem);
            }
        } else if (index == 0) {
            BreadcrumbItem root = this.fBreadcrumbItems.get(index);
            root.openDropDownMenu();
            root.getDropDownShell().setFocus();
        } else {
            this.selectItem(this.fBreadcrumbItems.get(index - 1));
        }
    }

    private void buildItemChain(Object input) {
        if (this.fBreadcrumbItems.size() > 0) {
            BreadcrumbItem last = this.fBreadcrumbItems.get(this.fBreadcrumbItems.size() - 1);
            last.setIsLastItem(false);
        }
        int index = 0;
        boolean updateLayout = false;
        if (input != null) {
            ITreePathContentProvider contentProvider = (ITreePathContentProvider)this.getContentProvider();
            TreePath path = new TreePath(new Object[0]);
            Object[] children = contentProvider.getElements(input);
            Object element = children != null && children.length != 0 ? children[0] : null;
            while (element != null) {
                path = path.createChildPath(element);
                children = contentProvider.getChildren(path);
                if ((this.getStyle() & 0x200) == 0 || children == null || children.length == 0) {
                    boolean bl = updateLayout = this.updateOrCreateItem(index++, path, element) || updateLayout;
                }
                if (children == null || children.length == 0) break;
                element = children[0];
            }
        }
        BreadcrumbItem last = null;
        if (index <= this.fBreadcrumbItems.size()) {
            last = this.fBreadcrumbItems.get(index - 1);
            last.setIsLastItem(true);
        }
        while (index < this.fBreadcrumbItems.size()) {
            updateLayout = true;
            BreadcrumbItem item = this.fBreadcrumbItems.remove(this.fBreadcrumbItems.size() - 1);
            if (item.hasFocus() && last != null) {
                last.setFocus(true);
            }
            if (item == this.fSelectedItem) {
                this.selectItem(null);
            }
            if (item.getData() != null) {
                this.unmapElement(item.getData());
            }
            item.dispose();
        }
        if (updateLayout) {
            this.updateSize();
            this.fContainer.layout(true, true);
        }
    }

    private boolean refreshItem(BreadcrumbItem item) {
        boolean layoutChanged = false;
        TreePath path = this.getTreePathFromItem(item);
        ViewerLabel label = new ViewerLabel(item.getText(), item.getImage());
        ((ITreePathLabelProvider)this.getLabelProvider()).updateLabel(label, path);
        if (label.hasNewText()) {
            item.setText(label.getText());
            layoutChanged = true;
        }
        if (label.hasNewImage()) {
            item.setImage(label.getImage());
            layoutChanged = true;
        }
        if (label.hasNewTooltipText()) {
            item.setToolTip(label.getTooltipText());
        }
        return layoutChanged;
    }

    private boolean updateOrCreateItem(int index, TreePath path, Object element) {
        BreadcrumbItem item;
        if (this.fBreadcrumbItems.size() > index) {
            item = this.fBreadcrumbItems.get(index);
            if (item.getData() != null) {
                this.unmapElement(item.getData());
            }
        } else {
            item = new BreadcrumbItem(this, this.fContainer);
            this.fBreadcrumbItems.add(item);
        }
        boolean updateLayout = false;
        if (this.equals(element, item.getData())) {
            item.setPath(path);
            updateLayout = this.myDoUpdateItem((Widget)item, element, false);
        } else {
            item.setData(element);
            item.setPath(path);
            this.mapElement(element, (Widget)item);
            updateLayout = this.refreshItem(item);
        }
        return updateLayout;
    }

    private boolean updateSize() {
        boolean requiresLayout;
        block7: {
            int currentWidth;
            int width;
            block6: {
                width = this.fContainer.getClientArea().width;
                currentWidth = this.getCurrentWidth();
                requiresLayout = false;
                if (currentWidth <= width) break block6;
                int index = 0;
                while (currentWidth > width && index < this.fBreadcrumbItems.size() - 1) {
                    BreadcrumbItem viewer = this.fBreadcrumbItems.get(index);
                    if (viewer.isShowText()) {
                        viewer.setShowText(false);
                        currentWidth = this.getCurrentWidth();
                        requiresLayout = true;
                    }
                    ++index;
                }
                break block7;
            }
            if (currentWidth >= width) break block7;
            int index = this.fBreadcrumbItems.size() - 1;
            while (currentWidth < width && index >= 0) {
                BreadcrumbItem viewer = this.fBreadcrumbItems.get(index);
                if (!viewer.isShowText()) {
                    viewer.setShowText(true);
                    currentWidth = this.getCurrentWidth();
                    if (currentWidth > width) {
                        viewer.setShowText(false);
                        index = 0;
                    } else {
                        requiresLayout = true;
                    }
                }
                --index;
            }
        }
        return requiresLayout;
    }

    private int getCurrentWidth() {
        int result = 0;
        int i = 0;
        int size = this.fBreadcrumbItems.size();
        while (i < size) {
            BreadcrumbItem viewer = this.fBreadcrumbItems.get(i);
            result += viewer.getWidth();
            ++i;
        }
        return result;
    }

    private void enableRedraw() {
        if (IS_GTK) {
            return;
        }
        this.fContainer.setRedraw(true);
    }

    private void disableRedraw() {
        if (IS_GTK) {
            return;
        }
        this.fContainer.setRedraw(false);
    }

    public static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = BreadcrumbViewer.blend(c1.red, c2.red, ratio);
        int g = BreadcrumbViewer.blend(c1.green, c2.green, ratio);
        int b = BreadcrumbViewer.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.fGradientBackground != null) {
            this.fGradientBackground.dispose();
            this.fGradientBackground = null;
        }
        if (this.fBreadcrumbItems != null) {
            for (BreadcrumbItem item : this.fBreadcrumbItems) {
                item.dispose();
            }
        }
        super.handleDispose(event);
    }
}

