/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.rap;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.rcptt.launching.rap.RAPLaunchConfig;
import org.eclipse.rcptt.launching.rap.URLBuilder;

public class RAPLaunchConfigValidator {
    public static final int ERR_SERVLET_PATH = 6001;
    public static final int ERR_PORT = 6004;
    public static final int ERR_URL = 6005;
    public static final int ERR_TIMEOUT = 6007;
    public static final int ERR_ENTRY_POINT = 6008;
    public static final int ERR_SERVLET_BUNDLE = 6009;
    public static final int ERR_DATA_LOCATION = 6010;
    public static final int ERR_CONTEXT_PATH = 6011;
    public static final int ERR_SERVLET_PATH_LEADING_SLASH = 60012;
    public static final int ERR_SERVLET_PATH_INVALID = 60013;
    public static final int ERR_CONTEXT_PATH_LEADING_SLASH = 60014;
    public static final int WARN_OSGI_FRAMEWORK = 7002;
    public static final int WARN_WS_WRONG = 7003;
    private static final String RAP_LAUNCH_CONFIG_TYPE = "org.eclipse.rap.ui.launch.RAPLauncher";
    private static final String EMPTY = "";
    private final RAPLaunchConfig config;

    public RAPLaunchConfigValidator(RAPLaunchConfig config) {
        this.config = config;
    }

    public IStatus[] validate() {
        ArrayList<IStatus> states = new ArrayList<IStatus>();
        try {
            this.addNonOKState(states, this.validateServletPath());
            this.addNonOKState(states, this.validatePort());
            this.addNonOKState(states, this.validateUniquePort());
            this.addNonOKState(states, this.validateContextPath());
            this.addNonOKState(states, this.validateURL());
            this.addNonOKState(states, this.validateSessionTimeout());
            this.addNonOKState(states, this.validateDataLocation());
        }
        catch (CoreException e) {
            String text = "An error occured while validating the launch configuration: {0}";
            Object[] args = new Object[]{e.getLocalizedMessage()};
            String msg = MessageFormat.format(text, args);
            states.add(this.createError(msg, 0, e));
        }
        IStatus[] result = new IStatus[states.size()];
        states.toArray(result);
        return result;
    }

    private IStatus validateDataLocation() throws CoreException {
        IStatus result = Status.OK_STATUS;
        String dataLocation = this.config.getDataLocation();
        if (dataLocation == null || dataLocation.length() == 0) {
            String msg = "Instance Area must not be empty.";
            result = this.createError(msg, 6010, null);
        }
        return result;
    }

    private IStatus validateServletPath() throws CoreException {
        IStatus result = Status.OK_STATUS;
        if (this.config.getOpenBrowser()) {
            String servletPath = this.config.getServletPath();
            if (servletPath == null || EMPTY.equals(servletPath)) {
                String msg = "The servlet path must not be empty";
                result = this.createError(msg, 6001, null);
            } else if (!servletPath.startsWith("/")) {
                String msg = "The servlet path must start with a slash.";
                result = this.createError(msg, 60012, null);
            } else if (RAPLaunchConfigValidator.containsChars(servletPath.substring(1), new char[]{'*', '/', '\\'})) {
                String msg = "The servlet path contains invalid characters.";
                result = this.createError(msg, 60013, null);
            }
        }
        return result;
    }

    private static boolean containsChars(String string, char[] chars) {
        boolean hasInvalidChar = false;
        String pattern = new String(chars);
        int i = 0;
        while (!hasInvalidChar && i < string.length()) {
            if (pattern.indexOf(string.charAt(i)) != -1) {
                hasInvalidChar = true;
            }
            ++i;
        }
        return hasInvalidChar;
    }

    private IStatus validateContextPath() throws CoreException {
        IStatus result = Status.OK_STATUS;
        if (this.config.getUseManualContextPath()) {
            String contextPath = this.config.getContextPath();
            if (!contextPath.startsWith("/")) {
                String msg = "The context path must start with a slash.";
                result = this.createError(msg, 60014, null);
            } else if (!this.isValidContextPath(contextPath)) {
                String unformatedMsg = "The context path contains invalid characters.";
                String msg = MessageFormat.format(unformatedMsg, contextPath);
                result = this.createError(msg, 6011, null);
            }
        }
        return result;
    }

    private boolean isValidContextPath(String contextPath) {
        boolean result = true;
        int length = contextPath.length();
        if (contextPath.indexOf("//") != -1) {
            result = false;
        }
        int i = 0;
        while (i < length && result) {
            boolean isValidSpecialChar;
            char ch = contextPath.charAt(i);
            boolean isLetterOrDigit = Character.isLetterOrDigit(ch);
            boolean bl = isValidSpecialChar = "/_-.".indexOf(ch) != -1;
            if (!isLetterOrDigit && !isValidSpecialChar) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    private IStatus validatePort() throws CoreException {
        int port;
        IStatus result = Status.OK_STATUS;
        if (this.config.getUseManualPort() && ((port = this.config.getPort()) < 0 || port > 65535)) {
            String text = "Port number must be between {0} and {1}";
            Object[] args = new Object[]{new Integer(0), new Integer(65535)};
            String msg = MessageFormat.format(text, args);
            result = this.createError(msg, 6004, null);
        }
        return result;
    }

    private IStatus validateUniquePort() throws CoreException {
        IStatus result = Status.OK_STATUS;
        if (this.config.getUseManualPort()) {
            RAPLaunchConfig duplicate = null;
            ILaunchConfiguration[] launchConfigs = RAPLaunchConfigValidator.getLaunchConfigs();
            int i = 0;
            while (duplicate == null && i < launchConfigs.length) {
                RAPLaunchConfig otherConfig = new RAPLaunchConfig(launchConfigs[i]);
                if (this.hasSamePort(otherConfig)) {
                    duplicate = otherConfig;
                }
                ++i;
            }
            if (duplicate != null) {
                String text = "The port {0,number,\\#} is already used by {1}";
                Object[] args = new Object[]{new Integer(this.config.getPort()), duplicate.getName()};
                String msg = MessageFormat.format(text, args);
                result = this.createWarning(msg, 0, null);
            }
        }
        return result;
    }

    private IStatus validateURL() throws CoreException {
        IStatus result = Status.OK_STATUS;
        try {
            String url = URLBuilder.fromLaunchConfig(this.config, 80, false);
            new URI(url);
        }
        catch (URISyntaxException exception) {
            String text = "Servlet path and/or context path cause a malformed URL.";
            result = this.createError(text, 6005, exception);
        }
        return result;
    }

    private IStatus validateSessionTimeout() throws CoreException {
        boolean isValid;
        IStatus result = Status.OK_STATUS;
        boolean bl = isValid = this.config.getSessionTimeout() >= 0;
        if (!isValid) {
            String msg = "Session timeout value must be a non-negative integer number.";
            result = this.createError(msg, 6007, null);
        }
        return result;
    }

    private void addNonOKState(List<IStatus> states, IStatus state) {
        if (state != null && !state.isOK()) {
            states.add(state);
        }
    }

    private IStatus createWarning(String msg, int code, Throwable thr) {
        String pluginId = "org.eclipse.rcptt.launching.rap";
        return new Status(2, pluginId, code, msg, thr);
    }

    private IStatus createError(String msg, int code, Throwable thr) {
        return new Status(4, "org.eclipse.rcptt.launching.rap", code, msg, thr);
    }

    private static ILaunchConfiguration[] getLaunchConfigs() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(RAP_LAUNCH_CONFIG_TYPE);
        return launchManager.getLaunchConfigurations(type);
    }

    private boolean hasSamePort(RAPLaunchConfig otherConfig) throws CoreException {
        return otherConfig.getUseManualPort() && !this.config.getName().equals(otherConfig.getName()) && this.config.getPort() == otherConfig.getPort();
    }
}

