/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup.browsers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class ArchiveFilter
extends ViewerFilter {
    private Set<IResource> fArchives;
    private List<ISourceContainer> fExisting;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.fArchives.contains(element) && !this.fExisting.contains(element);
    }

    public ArchiveFilter(List<ISourceContainer> objects) {
        this.fExisting = objects;
        this.init();
    }

    private void init() {
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), () -> {
            this.fArchives = new HashSet<IResource>();
            this.traverse((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.fArchives);
        });
    }

    private boolean traverse(IContainer container, Set<IResource> set) {
        boolean added = false;
        try {
            IResource[] resources = container.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    String ext = file.getFileExtension();
                    if (ext != null && (ext.equalsIgnoreCase("jar") || ext.equalsIgnoreCase("zip"))) {
                        set.add((IResource)file);
                        added = true;
                    }
                } else if (resource instanceof IContainer && this.traverse((IContainer)resource, set)) {
                    set.add(resource);
                    added = true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return added;
    }
}

