/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

abstract class PreloadingRepositoryHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        IProfileRegistry registry;
        String profileId = this.getProvisioningUI().getProfileId();
        IProvisioningAgent agent = this.getProvisioningUI().getSession().getProvisioningAgent();
        IProfile profile = null;
        if (agent != null && (registry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME)) != null) {
            profile = registry.getProfile(profileId);
        }
        if (profile == null) {
            MessageDialog.openInformation(null, (String)ProvSDKMessages.Handler_SDKUpdateUIMessageTitle, (String)ProvSDKMessages.Handler_CannotLaunchUI);
            StatusManager.getManager().handle(ProvSDKUIActivator.getNoSelfProfileStatus());
        } else {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> this.doExecuteAndLoad());
        }
        return null;
    }

    void doExecuteAndLoad() {
        if (this.preloadRepositories()) {
            Job.getJobManager().cancel(LoadMetadataRepositoryJob.LOAD_FAMILY);
            final LoadMetadataRepositoryJob loadJob = new LoadMetadataRepositoryJob(this.getProvisioningUI()){

                public IStatus runModal(IProgressMonitor monitor) {
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)PreloadingRepositoryHandler.this.getProgressTaskName(), (int)1000);
                    IStatus status = super.runModal((IProgressMonitor)sub.newChild(500));
                    if (status.getSeverity() == 8) {
                        return status;
                    }
                    try {
                        PreloadingRepositoryHandler.this.doPostLoadBackgroundWork((IProgressMonitor)sub.newChild(500));
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    if (this.shouldAccumulateFailures()) {
                        return Status.OK_STATUS;
                    }
                    return status;
                }
            };
            this.setLoadJobProperties((Job)loadJob);
            if (this.waitForPreload()) {
                loadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (PlatformUI.isWorkbenchRunning() && event.getResult().isOK()) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> PreloadingRepositoryHandler.this.doExecute(loadJob));
                        }
                    }
                });
                loadJob.setUser(true);
                loadJob.schedule();
            } else {
                loadJob.setSystem(true);
                loadJob.setUser(false);
                loadJob.schedule();
                this.doExecute(null);
            }
        } else {
            this.doExecute(null);
        }
    }

    protected abstract String getProgressTaskName();

    protected abstract void doExecute(LoadMetadataRepositoryJob var1);

    protected boolean preloadRepositories() {
        return true;
    }

    protected void doPostLoadBackgroundWork(IProgressMonitor monitor) throws OperationCanceledException {
    }

    protected boolean waitForPreload() {
        return true;
    }

    protected void setLoadJobProperties(Job loadJob) {
        loadJob.setProperty(LoadMetadataRepositoryJob.ACCUMULATE_LOAD_ERRORS, (Object)Boolean.toString(true));
    }

    protected ProvisioningUI getProvisioningUI() {
        return ProvisioningUI.getDefaultUI();
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
    }
}

