/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.storage.CommitFileRevision;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.ActionUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.blame.BlameOperation;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.FileDiffContentProvider;
import org.eclipse.egit.ui.internal.history.FileDiffLabelProvider;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.themes.ColorUtil;

public class CommitFileDiffViewer
extends TableViewer {
    private static final String LINESEP = System.getProperty("line.separator");
    private Clipboard clipboard;
    private IAction selectAll;
    private IAction copy;
    private IAction openThisVersion;
    private IAction openPreviousVersion;
    private IAction blame;
    private IAction openWorkingTreeVersion;
    private IAction compareWithPrevious;
    private IAction compareWorkingTreeVersion;
    private IAction showInHistory;
    private final IWorkbenchSite site;

    public CommitFileDiffViewer(Composite parent, IWorkbenchSite site) {
        this(parent, site, 68354);
    }

    public CommitFileDiffViewer(Composite parent, IWorkbenchSite site, int style) {
        super(parent, style);
        this.site = site;
        Table rawTable = this.getTable();
        Color fg = rawTable.getForeground();
        Color bg = rawTable.getBackground();
        RGB dimmedForegroundRgb = ColorUtil.blend((RGB)fg.getRGB(), (RGB)bg.getRGB(), (int)60);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
        this.setLabelProvider((IBaseLabelProvider)new FileDiffLabelProvider(dimmedForegroundRgb));
        this.setContentProvider((IContentProvider)new FileDiffContentProvider());
        this.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object left, Object right) {
                if (left instanceof FileDiff && right instanceof FileDiff) {
                    return FileDiff.PATH_COMPARATOR.compare((FileDiff)((Object)left), (FileDiff)((Object)right));
                }
                return super.compare(viewer, left, right);
            }
        });
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                FileDiff d = (FileDiff)((Object)iss.getFirstElement());
                if (Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_compare_mode")) {
                    CommitFileDiffViewer.this.showTwoWayFileDiff(d);
                } else if (d.getChange() == DiffEntry.ChangeType.DELETE) {
                    CommitFileDiffViewer.this.openPreviousVersionInEditor(d);
                } else {
                    CommitFileDiffViewer.this.openThisVersionInEditor(d);
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CommitFileDiffViewer.this.updateActionEnablement(event.getSelection());
            }
        });
        this.clipboard = new Clipboard(rawTable.getDisplay());
        rawTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitFileDiffViewer.this.clipboard.dispose();
            }
        });
        MenuManager mgr = new MenuManager();
        Control c = this.getControl();
        c.setMenu(mgr.createContextMenu(c));
        this.openThisVersion = new Action(UIText.CommitFileDiffViewer_OpenInEditorMenuLabel){

            public void run() {
                ISelection s = CommitFileDiffViewer.this.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                for (Object element : iss.toList()) {
                    CommitFileDiffViewer.this.openThisVersionInEditor((FileDiff)((Object)element));
                }
            }
        };
        this.openPreviousVersion = new Action(UIText.CommitFileDiffViewer_OpenPreviousInEditorMenuLabel){

            public void run() {
                ISelection s = CommitFileDiffViewer.this.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                for (Object element : iss.toList()) {
                    CommitFileDiffViewer.this.openPreviousVersionInEditor((FileDiff)((Object)element));
                }
            }
        };
        this.blame = new Action(UIText.CommitFileDiffViewer_ShowAnnotationsMenuLabel, UIIcons.ANNOTATE){

            public void run() {
                ISelection s = CommitFileDiffViewer.this.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                Iterator it = iss.iterator();
                while (it.hasNext()) {
                    CommitFileDiffViewer.this.showAnnotations((FileDiff)((Object)it.next()));
                }
            }
        };
        this.openWorkingTreeVersion = new Action(UIText.CommitFileDiffViewer_OpenWorkingTreeVersionInEditorMenuLabel){

            public void run() {
                ISelection s = CommitFileDiffViewer.this.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                for (FileDiff diff : iss) {
                    String relativePath = diff.getPath();
                    File file = new Path(diff.getRepository().getWorkTree().getAbsolutePath()).append(relativePath).toFile();
                    DiffViewer.openFileInEditor(file, -1);
                }
            }
        };
        this.compareWithPrevious = new Action(UIText.CommitFileDiffViewer_CompareMenuLabel){

            public void run() {
                ISelection s = CommitFileDiffViewer.this.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                FileDiff d = (FileDiff)((Object)iss.getFirstElement());
                CommitFileDiffViewer.this.showTwoWayFileDiff(d);
            }
        };
        this.compareWorkingTreeVersion = new Action(UIText.CommitFileDiffViewer_CompareWorkingDirectoryMenuLabel){

            public void run() {
                ISelection s = CommitFileDiffViewer.this.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                CommitFileDiffViewer.this.showWorkingDirectoryFileDiff((FileDiff)((Object)iss.getFirstElement()));
            }
        };
        this.showInHistory = new Action(UIText.CommitFileDiffViewer_ShowInHistoryLabel, UIIcons.HISTORY){

            public void run() {
                ShowInContext context = CommitFileDiffViewer.this.getShowInContext();
                if (context == null) {
                    return;
                }
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                IWorkbenchPart part = page.getActivePart();
                if (part instanceof IHistoryView) {
                    ((IShowInTarget)part).show(context);
                }
            }
        };
        mgr.add(this.openWorkingTreeVersion);
        mgr.add(this.openThisVersion);
        mgr.add(this.openPreviousVersion);
        mgr.add((IContributionItem)new Separator());
        mgr.add(this.compareWithPrevious);
        mgr.add(this.compareWorkingTreeVersion);
        mgr.add(this.blame);
        mgr.add((IContributionItem)new Separator());
        mgr.add(this.showInHistory);
        MenuManager showInSubMenu = UIUtils.createShowInMenu(site.getWorkbenchWindow());
        mgr.add((IContributionItem)showInSubMenu);
        mgr.add((IContributionItem)new Separator());
        this.selectAll = ActionUtils.createGlobalAction(ActionFactory.SELECT_ALL, () -> this.doSelectAll());
        this.selectAll.setEnabled(true);
        this.copy = ActionUtils.createGlobalAction(ActionFactory.COPY, () -> this.doCopy());
        this.copy.setText(UIText.CommitFileDiffViewer_CopyFilePathMenuLabel);
        this.copy.setEnabled(true);
        ActionUtils.setGlobalActions(this.getControl(), this.copy, this.selectAll);
        mgr.add(this.selectAll);
        mgr.add(this.copy);
        mgr.addMenuListener(manager -> {
            boolean bl = this.getControl().setFocus();
        });
    }

    private void updateActionEnablement(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        boolean allSelected = !sel.isEmpty() && sel.size() == this.getTable().getItemCount();
        boolean submoduleSelected = false;
        boolean addSelected = false;
        boolean deleteSelected = false;
        for (Object item : sel.toList()) {
            FileDiff fileDiff = (FileDiff)((Object)item);
            if (fileDiff.isSubmodule()) {
                submoduleSelected = true;
            }
            if (fileDiff.getChange() == DiffEntry.ChangeType.ADD) {
                addSelected = true;
                continue;
            }
            if (fileDiff.getChange() != DiffEntry.ChangeType.DELETE) continue;
            deleteSelected = true;
        }
        this.selectAll.setEnabled(!allSelected);
        this.copy.setEnabled(!sel.isEmpty());
        this.showInHistory.setEnabled(!sel.isEmpty());
        if (!submoduleSelected) {
            boolean oneOrMoreSelected = !sel.isEmpty();
            this.openThisVersion.setEnabled(oneOrMoreSelected && !deleteSelected);
            this.openPreviousVersion.setEnabled(oneOrMoreSelected && !addSelected);
            this.compareWithPrevious.setEnabled(sel.size() == 1 && !addSelected && !deleteSelected);
            this.blame.setEnabled(oneOrMoreSelected);
            if (sel.size() == 1) {
                FileDiff diff = (FileDiff)((Object)sel.getFirstElement());
                Repository repo = diff.getRepository();
                boolean workTreeFileExists = false;
                if (!repo.isBare()) {
                    String path = new Path(repo.getWorkTree().getAbsolutePath()).append(diff.getPath()).toOSString();
                    workTreeFileExists = new File(path).exists();
                }
                this.compareWorkingTreeVersion.setEnabled(workTreeFileExists);
                this.openWorkingTreeVersion.setEnabled(workTreeFileExists);
            } else {
                this.compareWorkingTreeVersion.setEnabled(false);
                this.openWorkingTreeVersion.setEnabled(oneOrMoreSelected);
            }
        } else {
            this.openThisVersion.setEnabled(false);
            this.openPreviousVersion.setEnabled(false);
            this.openWorkingTreeVersion.setEnabled(false);
            this.compareWithPrevious.setEnabled(false);
            this.blame.setEnabled(false);
            this.compareWorkingTreeVersion.setEnabled(false);
        }
    }

    public ShowInContext getShowInContext() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        ArrayList<Object> elements = new ArrayList<Object>();
        ArrayList<File> files = new ArrayList<File>();
        Repository repo = null;
        Path workTreePath = null;
        for (Object selectedElement : selection.toList()) {
            IPath path;
            IFile file;
            FileDiff fileDiff = (FileDiff)((Object)selectedElement);
            if (repo == null || workTreePath == null) {
                repo = fileDiff.getRepository();
                if (repo == null || repo.isBare()) {
                    return null;
                }
                workTreePath = new Path(repo.getWorkTree().getAbsolutePath());
            }
            if ((file = ResourceUtil.getFileForLocation((IPath)(path = workTreePath.append(fileDiff.getPath())), (boolean)false)) != null) {
                elements.add(file);
            } else {
                elements.add(path);
            }
            files.add(path.toFile());
        }
        HistoryPageInput historyPageInput = null;
        if (!files.isEmpty()) {
            historyPageInput = new HistoryPageInput(repo, files.toArray(new File[0]));
        }
        return new ShowInContext(historyPageInput, (ISelection)new StructuredSelection(elements));
    }

    private void openThisVersionInEditor(FileDiff d) {
        DiffViewer.openInEditor(d, DiffEntry.Side.NEW, -1);
    }

    private void openPreviousVersionInEditor(FileDiff d) {
        DiffViewer.openInEditor(d, DiffEntry.Side.OLD, -1);
    }

    private void showAnnotations(FileDiff d) {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            RevCommit commit = d.getChange().equals((Object)DiffEntry.ChangeType.DELETE) ? d.getCommit().getParent(0) : d.getCommit();
            String path = d.getPath();
            IFileRevision rev = CompareUtils.getFileRevision(path, commit, d.getRepository(), d.getChange().equals((Object)DiffEntry.ChangeType.DELETE) ? d.getBlobs()[0] : d.getBlobs()[d.getBlobs().length - 1]);
            if (rev instanceof CommitFileRevision) {
                BlameOperation op = new BlameOperation((CommitFileRevision)rev, window.getShell(), page);
                JobUtil.scheduleUserJob((IEGitOperation)op, (String)UIText.ShowBlameHandler_JobName, (Object)JobFamilies.BLAME);
            } else {
                String message = NLS.bind((String)UIText.DiffViewer_notContainedInCommit, (Object)path, (Object)d.getCommit().getId().getName());
                Activator.showError(message, null);
            }
        }
        catch (IOException e) {
            Activator.logError(UIText.GitHistoryPage_openFailed, e);
            Activator.showError(UIText.GitHistoryPage_openFailed, null);
        }
    }

    void showTwoWayFileDiff(FileDiff d) {
        if (d.getBlobs().length <= 2) {
            DiffViewer.showTwoWayFileDiff(d);
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)UIText.CommitFileDiffViewer_CanNotOpenCompareEditorTitle, (String)UIText.CommitFileDiffViewer_MergeCommitMultiAncestorMessage);
        }
    }

    void showWorkingDirectoryFileDiff(FileDiff d) {
        String p = d.getPath();
        RevCommit commit = d.getCommit();
        Repository repo = d.getRepository();
        if (commit == null || repo == null) {
            Activator.showError(UIText.GitHistoryPage_openFailed, null);
            return;
        }
        IWorkbenchPage activePage = this.site.getWorkbenchWindow().getActivePage();
        IFile file = ResourceUtil.getFileForLocation((Repository)repo, (String)p, (boolean)false);
        try {
            if (file != null) {
                IResource[] resources = new IResource[]{file};
                CompareUtils.compare(resources, repo, "HEAD", commit.getName(), true, activePage);
            } else {
                IPath path = new Path(repo.getWorkTree().getAbsolutePath()).append(p);
                File ioFile = path.toFile();
                if (ioFile.exists()) {
                    CompareUtils.compare(path, repo, "HEAD", commit.getName(), true, activePage);
                }
            }
        }
        catch (IOException e) {
            Activator.handleError(UIText.GitHistoryPage_openFailed, e, true);
        }
    }

    private void doSelectAll() {
        Object in = this.getInput();
        if (in == null) {
            return;
        }
        IStructuredContentProvider cp = (IStructuredContentProvider)this.getContentProvider();
        Object[] el = cp.getElements(in);
        if (el == null || el.length == 0) {
            return;
        }
        this.setSelection((ISelection)new StructuredSelection(el));
    }

    private void doCopy() {
        ISelection s = this.getSelection();
        if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iss = (IStructuredSelection)s;
        Iterator itr = iss.iterator();
        StringBuilder r = new StringBuilder();
        while (itr.hasNext()) {
            FileDiff d = (FileDiff)((Object)itr.next());
            if (r.length() > 0) {
                r.append(LINESEP);
            }
            r.append(d.getPath());
        }
        this.clipboard.setContents(new Object[]{r.toString()}, new Transfer[]{TextTransfer.getInstance()}, 1);
    }

    void setInterestingPaths(Collection<String> interestingPaths) {
        ((FileDiffContentProvider)this.getContentProvider()).setInterestingPaths(interestingPaths);
    }
}

