/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.io.IOException;
import java.net.URL;
import org.eclipse.equinox.service.weaving.CacheEntry;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IWeavingAdaptor;
import org.eclipse.equinox.weaving.hooks.AbstractWeavingBundleFile;
import org.eclipse.equinox.weaving.hooks.BundleAdaptorProvider;
import org.eclipse.equinox.weaving.hooks.CachedClassBundleEntry;
import org.eclipse.equinox.weaving.hooks.CachedGeneratedClassBundleEntry;
import org.eclipse.equinox.weaving.hooks.WeavingBundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;

public class WeavingBundleFile
extends AbstractWeavingBundleFile {
    private final URL url;

    public WeavingBundleFile(BundleAdaptorProvider bundleAdaptorProvider, BundleFile bundleFile) throws IOException {
        super(bundleAdaptorProvider, bundleFile);
        this.url = this.delegate.getBaseFile().toURL();
    }

    public BundleEntry getEntry(String string) {
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("> AspectJBundleFile.getEntry() path=" + string + ", url=" + this.url);
        }
        BundleEntry bundleEntry = this.delegate.getEntry(string);
        if (string.endsWith(".class") && bundleEntry != null) {
            int n = string.lastIndexOf(46);
            String string2 = string.substring(0, n).replace('/', '.');
            IWeavingAdaptor iWeavingAdaptor = this.getAdaptor();
            if (iWeavingAdaptor != null) {
                CacheEntry cacheEntry = iWeavingAdaptor.findClass(string2, this.url);
                if (cacheEntry == null) {
                    bundleEntry = new WeavingBundleEntry(iWeavingAdaptor, bundleEntry, this.url, false);
                    if (Debug.DEBUG_BUNDLE) {
                        Debug.println("- AspectJBundleFile.getEntry() path=" + string + ", entry=" + bundleEntry);
                    }
                } else {
                    bundleEntry = cacheEntry.getCachedBytes() != null ? new CachedClassBundleEntry(iWeavingAdaptor, bundleEntry, string, cacheEntry.getCachedBytes(), this.url) : new WeavingBundleEntry(iWeavingAdaptor, bundleEntry, this.url, cacheEntry.dontWeave());
                }
            }
        } else if (string.endsWith(".class") && bundleEntry == null) {
            CacheEntry cacheEntry;
            int n = string.lastIndexOf(46);
            String string3 = string.substring(0, n).replace('/', '.');
            IWeavingAdaptor iWeavingAdaptor = this.getAdaptor();
            if (iWeavingAdaptor != null && (cacheEntry = iWeavingAdaptor.findClass(string3, this.url)) != null && cacheEntry.getCachedBytes() != null) {
                bundleEntry = new CachedGeneratedClassBundleEntry(iWeavingAdaptor, string, cacheEntry.getCachedBytes(), this.url);
            }
        }
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("< AspectJBundleFile.getEntry() entry=" + bundleEntry);
        }
        return bundleEntry;
    }
}

