/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.folding;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.internal.genericeditor.folding.IndentFoldingStrategy;

public class DefaultFoldingReconciler
extends AbstractReconciler {
    private final IndentFoldingStrategy foldingStrategy = new IndentFoldingStrategy();

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        ProjectionViewer viewer = (ProjectionViewer)textViewer;
        this.foldingStrategy.setViewer(viewer);
    }

    public void uninstall() {
        super.uninstall();
        this.foldingStrategy.uninstall();
    }

    protected void process(DirtyRegion dirtyRegion) {
        this.foldingStrategy.reconcile(dirtyRegion, null);
    }

    protected void reconcilerDocumentChanged(IDocument newDocument) {
        this.foldingStrategy.setDocument(newDocument);
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return this.foldingStrategy;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        super.setProgressMonitor(monitor);
        this.foldingStrategy.setProgressMonitor(monitor);
    }

    protected void initialProcess() {
        super.initialProcess();
        this.foldingStrategy.initialReconcile();
    }
}

