/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.impl.manager.ExtendedServiceListener;
import org.apache.felix.scr.impl.manager.ExtendedServiceListenerContext;
import org.apache.felix.scr.impl.manager.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;

public class ServiceTracker<S, T, U extends ServiceEvent> {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter eventFilter;
    final ServiceTrackerCustomizer<S, T, U> customizer;
    final String initialReferenceFilterString;
    private volatile Tracked tracked;
    private boolean active;
    private ExtendedServiceListenerContext<U> extendedServiceListenerContext;
    private String classFilterString;

    public Tracked tracked() {
        return this.tracked;
    }

    public ServiceTracker(BundleContext context, ServiceTrackerCustomizer<S, T, U> customizer, boolean initialActive, ExtendedServiceListenerContext<U> bundleComponentActivator, Filter eventFilter, String classFilterString, String initialReferenceFilterString) {
        if (context == null) {
            throw new NullPointerException("BundleContext");
        }
        this.context = context;
        this.initialReferenceFilterString = initialReferenceFilterString;
        this.eventFilter = eventFilter;
        this.customizer = customizer;
        this.active = initialActive;
        this.extendedServiceListenerContext = bundleComponentActivator;
        this.classFilterString = classFilterString;
    }

    public void open(AtomicInteger trackingCount) {
        this.open(false, trackingCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean trackAllServices, AtomicInteger trackingCount) {
        Tracked t;
        ServiceTracker serviceTracker = this;
        synchronized (serviceTracker) {
            if (this.tracked != null) {
                return;
            }
            Tracked tracked = t = new Tracked(trackingCount);
            synchronized (tracked) {
                try {
                    this.extendedServiceListenerContext.addServiceListener(this.classFilterString, this.eventFilter, t);
                    ServiceReference<S>[] references = this.getInitialReferences(null, this.initialReferenceFilterString);
                    t.setInitial(references);
                }
                catch (InvalidSyntaxException e) {
                    throw new RuntimeException("unexpected InvalidSyntaxException: " + e.getMessage(), e);
                }
            }
            this.tracked = t;
        }
        t.trackInitial();
    }

    private ServiceReference<S>[] getInitialReferences(String className, String filterString) throws InvalidSyntaxException {
        ServiceReference[] result = this.context.getServiceReferences(className, filterString);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<ServiceReference<S>, T> close(AtomicInteger trackingCount) {
        Tracked outgoing;
        TreeMap map = new TreeMap(Collections.reverseOrder());
        Object object = this;
        synchronized (object) {
            outgoing = this.tracked;
            if (outgoing == null) {
                return map;
            }
            outgoing.close();
            Tracked tracked = outgoing;
            synchronized (tracked) {
                trackingCount.set(outgoing.getTrackingCount());
                outgoing.copyEntries(map);
            }
            try {
                this.extendedServiceListenerContext.removeServiceListener(this.classFilterString, this.eventFilter, outgoing);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.modified();
        object = outgoing;
        synchronized (object) {
            outgoing.notifyAll();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeClose(Map<ServiceReference<S>, T> toUntrack) {
        Tracked outgoing;
        ServiceTracker serviceTracker = this;
        synchronized (serviceTracker) {
            outgoing = this.tracked;
            if (outgoing == null) {
                return;
            }
        }
        for (ServiceReference serviceReference : toUntrack.keySet()) {
            outgoing.untrack(serviceReference, null);
        }
        this.tracked = null;
    }

    public T addingService(ServiceReference<S> reference, int trackingCount) {
        Object result = this.context.getService(reference);
        return (T)result;
    }

    public void modifiedService(ServiceReference<S> reference, T service, int trackingCount) {
    }

    public void removedService(ServiceReference<S> reference, T service, int trackingCount) {
        this.context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference<S>[] getServiceReferences() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length = t.size();
            if (length == 0) {
                return null;
            }
            ServiceReference[] result = new ServiceReference[length];
            return t.copyKeys(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getService(ServiceReference<S> reference) {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getCustomizedObject(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length;
            ServiceReference<S>[] references = this.getServiceReferences();
            int n = length = references == null ? 0 : references.length;
            if (length == 0) {
                return null;
            }
            Object[] objects = new Object[length];
            for (int i = 0; i < length; ++i) {
                objects[i] = this.getService(references[i]);
            }
            return objects;
        }
    }

    public void remove(ServiceReference<S> reference) {
        Tracked t = this.tracked();
        if (t == null) {
            return;
        }
        t.untrack(reference, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked t = this.tracked();
        if (t == null) {
            return 0;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked t = this.tracked();
        if (t == null) {
            return -1;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getTrackingCount();
        }
    }

    void modified() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<ServiceReference<S>, T> getTracked(Boolean activate, AtomicInteger trackingCount) {
        TreeMap map = new TreeMap(Collections.reverseOrder());
        Tracked t = this.tracked();
        if (t == null) {
            return map;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            if (activate != null) {
                this.active = activate;
            }
            trackingCount.set(t.getTrackingCount());
            return t.copyEntries(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        Tracked t = this.tracked();
        if (t == null) {
            return;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            this.active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Tracked t = this.tracked();
        if (t == null) {
            return true;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getServiceCount() {
        Tracked t = this.tracked();
        if (t == null) {
            return 0;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Tracked t = this.tracked();
        if (t == null) {
            return false;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] getServices(T[] array) {
        Tracked t = this.tracked();
        if (t == null) {
            if (array.length > 0) {
                array[0] = null;
            }
            return array;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length;
            ServiceReference<S>[] references = this.getServiceReferences();
            int n = length = references == null ? 0 : references.length;
            if (length == 0) {
                if (array.length > 0) {
                    array[0] = null;
                }
                return array;
            }
            if (length > array.length) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), length);
            }
            for (int i = 0; i < length; ++i) {
                array[i] = this.getService(references[i]);
            }
            if (array.length > length) {
                array[length] = null;
            }
            return array;
        }
    }

    abstract class AbstractTracked<S, T, R> {
        static final boolean DEBUG = false;
        private final Map<S, T> tracked = new HashMap<S, T>();
        private final AtomicInteger trackingCount;
        private final List<S> adding;
        volatile boolean closed;
        private final LinkedList<S> initial;

        AbstractTracked(AtomicInteger trackingCount) {
            this.trackingCount = trackingCount;
            this.adding = new ArrayList<S>(6);
            this.initial = new LinkedList();
            this.closed = false;
        }

        void setInitial(S[] list) {
            if (list == null) {
                return;
            }
            for (S item : list) {
                if (item == null) continue;
                this.initial.add(item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trackInitial() {
            while (true) {
                S item;
                AbstractTracked abstractTracked = this;
                synchronized (abstractTracked) {
                    if (this.closed || this.initial.size() == 0) {
                        return;
                    }
                    item = this.initial.removeFirst();
                    if (this.tracked.get(item) != null) {
                        continue;
                    }
                    if (this.adding.contains(item)) {
                        continue;
                    }
                    this.adding.add(item);
                }
                this.trackAdding(item, null);
            }
        }

        void close() {
            this.closed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void track(S item, R related) {
            T object;
            boolean tracking;
            int trackingCount = -1;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.closed) {
                    return;
                }
                tracking = this.tracked.containsKey(item);
                object = this.tracked.get(item);
                if (!tracking) {
                    if (this.adding.contains(item)) {
                        return;
                    }
                    this.adding.add(item);
                } else {
                    trackingCount = this.modified();
                }
            }
            if (!tracking) {
                this.trackAdding(item, related);
            } else {
                this.customizerModified(item, related, object, trackingCount);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trackAdding(S item, R related) {
            T object = null;
            boolean becameUntracked = false;
            int trackingCount = -1;
            int serviceCount = -1;
            try {
                object = this.customizerAdding(item, related);
            }
            finally {
                AbstractTracked abstractTracked = this;
                synchronized (abstractTracked) {
                    if (this.adding.remove(item) && !this.closed) {
                        this.tracked.put(item, object);
                        trackingCount = this.modified();
                        serviceCount = this.tracked.size();
                        this.notifyAll();
                    } else {
                        becameUntracked = true;
                    }
                }
            }
            if (becameUntracked) {
                this.customizerRemoved(item, related, object, trackingCount);
            } else {
                this.customizerAdded(item, related, object, trackingCount, serviceCount);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void untrack(S item, R related) {
            int trackingCount;
            T object;
            AbstractTracked abstractTracked = this;
            synchronized (abstractTracked) {
                if (this.initial.remove(item)) {
                    return;
                }
                if (this.adding.remove(item)) {
                    return;
                }
                object = this.tracked.remove(item);
                if (object == null) {
                    return;
                }
                trackingCount = this.modified();
            }
            this.customizerRemoved(item, related, object, trackingCount);
        }

        int size() {
            return this.tracked.size();
        }

        boolean isEmpty() {
            return this.tracked.isEmpty();
        }

        T getCustomizedObject(S item) {
            return this.tracked.get(item);
        }

        S[] copyKeys(S[] list) {
            return this.tracked.keySet().toArray(list);
        }

        int modified() {
            return this.trackingCount.incrementAndGet();
        }

        int getTrackingCount() {
            return this.trackingCount.get();
        }

        <M extends Map<? super S, ? super T>> M copyEntries(M map) {
            map.putAll(this.tracked);
            return map;
        }

        abstract T customizerAdding(S var1, R var2);

        abstract void customizerAdded(S var1, R var2, T var3, int var4, int var5);

        abstract void customizerModified(S var1, R var2, T var3, int var4);

        abstract void customizerRemoved(S var1, R var2, T var3, int var4);
    }

    private class Tracked
    extends AbstractTracked<ServiceReference<S>, T, U>
    implements ExtendedServiceListener<U> {
        Tracked(AtomicInteger trackingCount) {
            super(trackingCount);
        }

        @Override
        public final void serviceChanged(U event) {
            if (this.closed) {
                return;
            }
            ServiceReference reference = event.getServiceReference();
            switch (event.getType()) {
                case 1: 
                case 2: {
                    this.track(reference, event);
                    break;
                }
                case 4: 
                case 8: {
                    this.untrack(reference, event);
                    break;
                }
                default: {
                    System.out.println("Unrecognized event type: ServiceTracker.Tracked.serviceChanged[" + event.getType() + "]: " + reference);
                }
            }
        }

        @Override
        final int modified() {
            int trackingCount = super.modified();
            ServiceTracker.this.modified();
            return trackingCount;
        }

        @Override
        final T customizerAdding(ServiceReference<S> item, U related) {
            return ServiceTracker.this.customizer.addingService(item);
        }

        @Override
        final void customizerAdded(ServiceReference<S> item, U related, T object, int trackingCount, int serviceCount) {
            ServiceTracker.this.customizer.addedService(item, object, trackingCount, serviceCount, related);
        }

        @Override
        final void customizerModified(ServiceReference<S> item, U related, T object, int trackingCount) {
            ServiceTracker.this.customizer.modifiedService(item, object, trackingCount, related);
        }

        @Override
        final void customizerRemoved(ServiceReference<S> item, U related, T object, int trackingCount) {
            ServiceTracker.this.customizer.removedService(item, object, trackingCount, related);
        }
    }
}

