/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.internal.ecl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Pipeline;
import org.eclipse.rcptt.ecl.core.util.ScriptletFactory;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.IMLSelectData;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectData;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandToElementEntry;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaScenario;
import org.eclipse.rcptt.tesla.core.utils.TeslaPathUtils;
import org.eclipse.rcptt.tesla.ecl.TeslaScriptletFactory;
import org.eclipse.rcptt.tesla.ecl.model.GetColumnHeader;
import org.eclipse.rcptt.tesla.ecl.model.GetEclipseWindow;
import org.eclipse.rcptt.tesla.ecl.model.GetPropertyTab;
import org.eclipse.rcptt.tesla.ecl.model.GetRegion;
import org.eclipse.rcptt.tesla.ecl.model.Selector;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.tesla.ecl.model.TeslaPackage;
import org.eclipse.rcptt.tesla.recording.core.ecl.ISelectorParserExtension;
import org.eclipse.rcptt.tesla.recording.core.ecl.TeslaRecordingPlugin;
import org.eclipse.rcptt.tesla.recording.core.ecl.parser.TeslaParserUtil;
import org.eclipse.rcptt.util.Base64;

public class TeslaSelectorParser
extends TeslaScriptletFactory {
    private static final String EXTENSION_ID = "org.eclipse.rcptt.tesla.recording.core.ecl.selectorExtension";
    static final List<ISelectorParserExtension> extensions = new ArrayList<ISelectorParserExtension>();
    protected Map<String, Command> elements = new HashMap<String, Command>();
    protected TeslaScenario scenario;

    static {
        TeslaSelectorParser.initExtensions();
    }

    private static void initExtensions() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                Object extension = element.createExecutableExtension("class");
                if (extension instanceof ISelectorParserExtension) {
                    extensions.add((ISelectorParserExtension)extension);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            TeslaRecordingPlugin.log("Error while get selector extension.", e);
        }
    }

    public TeslaSelectorParser(TeslaScenario scenario) {
        this.scenario = scenario;
    }

    public void parse() {
        this.init();
        this.process();
    }

    protected void init() {
    }

    protected void process() {
        EList entries = this.scenario.getElementMapping();
        for (CommandToElementEntry entry : entries) {
            String id;
            Command e;
            org.eclipse.rcptt.tesla.core.protocol.raw.Command command = entry.getCommand();
            if (!(command instanceof SelectCommand) || (e = this.element((SelectCommand)command, id = ((Element)entry.getElements().get(0)).getId())) == null) continue;
            this.save(id, e);
        }
    }

    protected void save(String id, Command e) {
        Command oldVal = this.elements.put(id, e);
        if (oldVal != null && !EcoreUtil.equals((EObject)e, (EObject)oldVal)) {
            throw new IllegalArgumentException("Elements with duplicate id=" + id + " are detected");
        }
    }

    protected Command element(SelectCommand command, String id) {
        Command selector;
        EList indexes;
        ElementKind kind;
        SelectData data = command.getData();
        if (data.getKind().equals("CompositeRuler")) {
            data.setKind(ElementKind.VerticalRuler.name());
        }
        if (data.getKind().equals("OverviewRuler")) {
            data.setKind(ElementKind.RightRuler.name());
        }
        if ((kind = ElementKind.kindOf((String)data.getKind())) == null) {
            throw new IllegalArgumentException("Null-kind control was detected");
        }
        if (kind == ElementKind.Item && ((indexes = data.getIndexes()) == null || indexes.isEmpty())) {
            Command selector2 = TeslaParserUtil.makeItem((List<String>)data.getPath());
            Command parent = this.selectorOf(data.getParent());
            if (parent != null) {
                return TeslaSelectorParser.makePipe((Command[])new Command[]{parent, selector2});
            }
            return selector2;
        }
        if (kind == ElementKind.Menu) {
            selector = TeslaParserUtil.makeMenu((List<String>)data.getPath());
            Command parent = this.selectorOf(data.getParent());
            if (parent != null) {
                return TeslaSelectorParser.makePipe((Command[])new Command[]{parent, selector});
            }
            return selector;
        }
        selector = null;
        if (kind == ElementKind.Custom) {
            for (ISelectorParserExtension extension : extensions) {
                selector = extension.selector(data.getKind(), data.getPattern(), (List<String>)data.getPath(), (List<Integer>)data.getIndexes());
                if (selector != null) break;
            }
        }
        if (selector == null) {
            selector = this.selector(kind, data);
        }
        if (kind.equals((Object)ElementKind.Region) && data instanceof IMLSelectData) {
            selector = this.selector(kind, ((IMLSelectData)data).getImage(), (EList<Integer>)data.getIndexes());
        }
        if (selector == null) {
            return null;
        }
        selector.setId(id);
        selector.setIndex(data.getIndex());
        Command parent = this.selectorOf(data.getParent());
        Command after = this.selectorOf(data.getAfter());
        if (after instanceof Pipeline && parent != null) {
            Command cutAfter = TeslaParserUtil.cut(after, parent);
            if (cutAfter == null) {
                EList afterCommands = ((Pipeline)after).getCommands();
                if (afterCommands.size() > 1) {
                    after = (Command)afterCommands.get(afterCommands.size() - 1);
                }
            } else {
                after = cutAfter;
            }
        }
        if (after != null) {
            ScriptletFactory.bind((Command)selector, (EStructuralFeature)TeslaPackage.eINSTANCE.getSelector_After(), (Command)after);
        }
        if (parent != null) {
            return TeslaSelectorParser.makePipe((Command[])new Command[]{parent, selector});
        }
        return selector;
    }

    private Selector selector(ElementKind kind, byte[] image, EList<Integer> indexes) {
        switch (kind) {
            case Region: {
                GetRegion region = TeslaSelectorParser.makeRegion();
                region.setImageURI("base64://");
                region.setRawImage(Base64.encode((byte[])image));
                region.setX(((Integer)indexes.get(0)).intValue());
                region.setY(((Integer)indexes.get(1)).intValue());
                return region;
            }
        }
        return null;
    }

    protected Selector selector(ElementKind kind, SelectData data) {
        String text = data.getPattern();
        EList path = data.getPath();
        EList indexes = data.getIndexes();
        Integer index = data.getIndex();
        switch (kind) {
            case Button: {
                return TeslaSelectorParser.makeButton((String)text);
            }
            case Canvas: {
                return TeslaSelectorParser.makeCanvas();
            }
            case CBanner: {
                return TeslaSelectorParser.makeCBanner();
            }
            case Combo: {
                return TeslaSelectorParser.makeCombo();
            }
            case CoolBar: {
                return TeslaSelectorParser.makeCoolbar();
            }
            case DiagramViewer: {
                return TeslaSelectorParser.makeDiagramViewer((Integer)index);
            }
            case DiagramFigure: {
                if (path.size() == 2) {
                    String first = (String)path.get(0);
                    String second = (String)path.get(1);
                    if ("editpart".equals(first) && "address".equals(second)) {
                        return TeslaSelectorParser.makeEditPart((List)indexes);
                    }
                    if ("editpart.source.connection".equals(first) && "address".equals(second)) {
                        return TeslaSelectorParser.makeSourceConnection((List)indexes);
                    }
                    if ("editpart.feature".equals(first)) {
                        return TeslaSelectorParser.makeEditPartByFeature((String)second, (String)text);
                    }
                    if ("editpart".equals(first) && "classname".equals(second)) {
                        return TeslaSelectorParser.makeEditPartByClassName((String)text);
                    }
                    if ("handle".equals(first) && "class".equals(second)) {
                        return TeslaSelectorParser.makeHandle((String)text);
                    }
                    if ("editpart".equals(first) && "name".equals(second)) {
                        return TeslaSelectorParser.makeEditPartByName((String)text);
                    }
                    if ("editpart".equals(first) && "text".equals(second)) {
                        return TeslaSelectorParser.makeEditPartByText((String)text);
                    }
                    if ("editpart.target.connection".equals(first) && "address".equals(second)) {
                        return TeslaSelectorParser.makeTargetConnection((List)indexes);
                    }
                    if ("rawFigure".equals(first) && "address".equals(second)) {
                        if (indexes.size() > 0) {
                            int value = (Integer)indexes.get(0);
                            switch (value) {
                                case -3: {
                                    return TeslaSelectorParser.makePopupBarItem((List)indexes);
                                }
                                case -2: {
                                    return TeslaSelectorParser.makeConnectionHandle((List)indexes);
                                }
                            }
                        }
                        return TeslaSelectorParser.makeFigure((List)indexes);
                    }
                }
                throw new IllegalArgumentException("Unexpected figure path: " + path.toArray(new String[0]).toString());
            }
            case EclipseWindow: {
                if (index != null && index != 0) {
                    return TeslaSelectorParser.makeEclipseWindow((int)index);
                }
                return null;
            }
            case QuickAccess: {
                return TeslaSelectorParser.makeQuickAccess();
            }
            case Editor: {
                return TeslaSelectorParser.makeEditor((String)text, (String)data.getClassPattern(), (Integer)index);
            }
            case TextViewer: {
                return TeslaSelectorParser.makeTextViewer();
            }
            case VerticalRuler: {
                return TeslaSelectorParser.makeVerticalRuler();
            }
            case VerticalColumn: {
                return TeslaSelectorParser.makeRulerColumn((String)text);
            }
            case LeftRuler: {
                return TeslaSelectorParser.makeLeftRuler();
            }
            case RightRuler: {
                return TeslaSelectorParser.makeRightRuler();
            }
            case Expandable: {
                return TeslaSelectorParser.makeExpandable((String)text);
            }
            case FormText: {
                return TeslaSelectorParser.makeLabel((String)text);
            }
            case Group: {
                return TeslaSelectorParser.makeGroup((String)text);
            }
            case Item: {
                if (indexes != null && !indexes.isEmpty()) {
                    if (indexes.size() != 2) {
                        throw new IllegalArgumentException("Invalid cell selector");
                    }
                    return TeslaSelectorParser.makeCell((int)((Integer)indexes.get(1)), (int)((Integer)indexes.get(0)));
                }
                return TeslaSelectorParser.makeItem((String)TeslaPathUtils.makePathFromList((List)path), null);
            }
            case Label: {
                return TeslaSelectorParser.makeLabel((String)text);
            }
            case Link: {
                return TeslaSelectorParser.makeLink((String)text);
            }
            case List: {
                return TeslaSelectorParser.makeList();
            }
            case Menu: {
                return TeslaSelectorParser.makeMenu((String)TeslaPathUtils.makePathFromList((List)path), null);
            }
            case PaletteViewer: {
                return TeslaSelectorParser.makePaletteViewer();
            }
            case State: {
                return null;
            }
            case TabFolder: {
                return TeslaSelectorParser.makeTabFolder();
            }
            case TabItem: {
                return TeslaSelectorParser.makeTabItem((String)text);
            }
            case Table: {
                return TeslaSelectorParser.makeTable();
            }
            case Text: {
                return TeslaSelectorParser.makeEditbox();
            }
            case Toolbar: {
                return TeslaSelectorParser.makeToolbar();
            }
            case Tree: {
                return TeslaSelectorParser.makeTree();
            }
            case DateTime: {
                return TeslaSelectorParser.makeDateTime();
            }
            case Slider: {
                return TeslaSelectorParser.makeSlider();
            }
            case View: {
                return TeslaSelectorParser.makeView((String)text);
            }
            case Window: {
                if (path.size() == 2) {
                    String first = (String)path.get(0);
                    String second = (String)path.get(1);
                    if ("-from".equals(first)) {
                        return TeslaSelectorParser.makeFromedWindow((String)second);
                    }
                    if ("-class".equals(first)) {
                        return TeslaSelectorParser.makeClassedWindow((String)second);
                    }
                }
                return TeslaSelectorParser.makeWindow((String)text);
            }
            case PaletteEntry: {
                return TeslaSelectorParser.paletteEntry((String)text);
            }
            case ColumnHeader: {
                return this.makeColumnHeader(text, index);
            }
            case PropertyTab: {
                return this.makePropertyTab(text);
            }
            case Custom: {
                return TeslaSelectorParser.makeControl((String)data.getKind(), (String)text);
            }
        }
        return TeslaSelectorParser.makeControl((String)kind.name(), (String)text);
    }

    private Selector makePropertyTab(String text) {
        GetPropertyTab getPropertyTab = TeslaFactory.eINSTANCE.createGetPropertyTab();
        getPropertyTab.setText(text);
        return getPropertyTab;
    }

    private Selector makeColumnHeader(String text, Integer index) {
        GetColumnHeader getColumnHeader = TeslaFactory.eINSTANCE.createGetColumnHeader();
        getColumnHeader.setText(text);
        getColumnHeader.setIndex(index);
        return getColumnHeader;
    }

    public Command selectorOf(Element element) {
        return this.selectorOf(element, true);
    }

    public Command selectorOf(Element element, boolean reduceEclipseWindow) {
        if (element == null) {
            return null;
        }
        String id = element.getId();
        Command selector = this.elements.get(id);
        if (ElementKind.EclipseWindow.name().equals(element.getKind()) && selector instanceof GetEclipseWindow && (((GetEclipseWindow)selector).getIndex() == null || ((GetEclipseWindow)selector).getIndex() == 0) && reduceEclipseWindow) {
            return null;
        }
        if (selector == null) {
            if (ElementKind.EclipseWindow.name().equals(element.getKind())) {
                if (reduceEclipseWindow) {
                    return null;
                }
                return TeslaFactory.eINSTANCE.createGetEclipseWindow();
            }
            return TeslaScriptletFactory.controlNotFound();
        }
        if (element.getKind() != null && element.getKind().equals(ElementKind.Text.name()) && element.getDescription() != null && element.getDescription().equals("quick-access")) {
            return TeslaFactory.eINSTANCE.createGetQuickAccess();
        }
        return (Command)EcoreUtil.copy((EObject)selector);
    }

    public Element elementOf(SelectCommand command) {
        for (CommandToElementEntry entry : this.scenario.getElementMapping()) {
            if (!command.equals(entry.getCommand())) continue;
            return (Element)entry.getElements().get(0);
        }
        throw new AssertionError();
    }
}

