/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.operations.internal.commands;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.BoxedValue;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CorePackage;
import org.eclipse.rcptt.ecl.core.EclBoolean;
import org.eclipse.rcptt.ecl.core.EclDouble;
import org.eclipse.rcptt.ecl.core.EclFloat;
import org.eclipse.rcptt.ecl.core.EclInteger;
import org.eclipse.rcptt.ecl.core.EclLong;
import org.eclipse.rcptt.ecl.core.EclString;
import org.eclipse.rcptt.ecl.operations.BinaryOp;
import org.eclipse.rcptt.ecl.operations.internal.OperationsPlugin;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public abstract class BinaryOpService
implements ICommandService {
    private static final EClass DOUBLE = CorePackage.Literals.ECL_DOUBLE;
    private static final EClass FLOAT = CorePackage.Literals.ECL_FLOAT;
    private static final EClass LONG = CorePackage.Literals.ECL_LONG;
    private static final EClass INT = CorePackage.Literals.ECL_INTEGER;
    private static final EClass[] DESCENDING = new EClass[]{DOUBLE, FLOAT, LONG, INT};

    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        if (!(command instanceof BinaryOp)) {
            return Status.CANCEL_STATUS;
        }
        BinaryOp op = (BinaryOp)command;
        BoxedValue left = BinaryOpService.convertToNumber(op.getLeft());
        BoxedValue right = BinaryOpService.convertToNumber(op.getRight());
        EClass widestType = BinaryOpService.max(left.eClass(), right.eClass());
        left = BoxedValues.toType((BoxedValue)left, (EClass)widestType);
        right = BoxedValues.toType((BoxedValue)right, (EClass)widestType);
        context.getOutput().write((Object)this.doOp(left, right));
        return Status.OK_STATUS;
    }

    public static EClass max(EClass ... args) {
        List<EClass> argList = Arrays.asList(args);
        EClass[] eClassArray = DESCENDING;
        int n = DESCENDING.length;
        int n2 = 0;
        while (n2 < n) {
            EClass clazz = eClassArray[n2];
            if (argList.contains(clazz)) {
                return clazz;
            }
            ++n2;
        }
        return INT;
    }

    protected final BoxedValue doOp(BoxedValue left, BoxedValue right) throws CoreException {
        if (left instanceof EclInteger) {
            return this.doIntOp(((EclInteger)left).getValue(), ((EclInteger)right).getValue());
        }
        if (left instanceof EclDouble) {
            return this.doDoubleOp(((EclDouble)left).getValue(), ((EclDouble)right).getValue());
        }
        if (left instanceof EclLong) {
            return this.doLongOp(((EclLong)left).getValue(), ((EclLong)right).getValue());
        }
        if (left instanceof EclFloat) {
            return this.doFloatOp(((EclFloat)left).getValue(), ((EclFloat)right).getValue());
        }
        throw new CoreException(OperationsPlugin.createErr("Unexpected argument type: %s", left.eClass().getName()));
    }

    protected abstract BoxedValue doDoubleOp(double var1, double var3);

    protected abstract BoxedValue doFloatOp(float var1, float var2);

    protected abstract BoxedValue doIntOp(int var1, int var2);

    protected abstract BoxedValue doLongOp(long var1, long var3);

    public static BoxedValue convertToNumber(EObject arg) throws CoreException {
        if (!(arg instanceof BoxedValue)) {
            throw new CoreException(OperationsPlugin.createErr("Cannot convert argument to number: '%s' ", arg));
        }
        if (arg instanceof EclString || arg instanceof EclBoolean) {
            return BoxedValues.toType((BoxedValue)((BoxedValue)arg), (EClass)CorePackage.Literals.ECL_LONG);
        }
        return (BoxedValue)arg;
    }
}

