/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext.ui.wizards;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.rcptt.internal.launching.aut.BaseAutManager;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.internal.launching.ext.UpdateVMArgs;
import org.eclipse.rcptt.internal.launching.ext.ui.wizards.NewAUTPage;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.launching.ext.Q7LaunchingUtil;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.utils.AUTLaunchArgumentsHelper;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class NewAUTWizard
extends Wizard {
    private static final String ATTR_D32 = "-d32";
    private NewAUTPage page;

    public NewAUTWizard() {
        this.setWindowTitle("New Application Under Test");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page = new NewAUTPage("new", "New Application Under Test", null);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        ITargetPlatformHelper target = this.page.getTarget();
        if (!target.getStatus().isOK()) {
            this.page.setStatus(target.getStatus());
            target.delete();
            return false;
        }
        try {
            String programArgs;
            target.setTargetName(Q7TargetPlatformManager.getTargetPlatformName((String)this.page.getTargetName()));
            target.save();
            ILaunchConfigurationWorkingCopy workingCopy = Q7LaunchingUtil.createLaunchConfiguration((ITargetPlatformHelper)target, (String)this.page.getTargetName());
            OSArchitecture autArch = this.page.getArchitecture();
            workingCopy.setAttribute("com.xored.launching.common.attrArch", autArch.name());
            OSArchitecture jvmArch = this.page.getJVMArch();
            List vmArgs = Q7LaunchDelegateUtils.getVMArgs((ITargetPlatformHelper)target, null);
            if (!autArch.equals((Object)jvmArch) && Platform.getOS().equals("macosx")) {
                UpdateVMArgs.addIfAbsent((List)vmArgs, (String)ATTR_D32, (String)"");
            }
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, Q7LaunchDelegateUtils.joinCommandArgs((Collection)vmArgs));
            IVMInstall install = this.page.getJVMInstall();
            if (install != null) {
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, String.format("org.eclipse.jdt.launching.JRE_CONTAINER/%s/%s", install.getVMInstallType().getId(), install.getName()));
            }
            if ((programArgs = AUTLaunchArgumentsHelper.getInitialProgramArguments((String)autArch.name())).length() > 0) {
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArgs);
            }
            workingCopy.setAttribute("append.args", true);
            String product = target.getDefaultProduct();
            if (product != null) {
                workingCopy.setAttribute("useProduct", true);
                workingCopy.setAttribute("product", product);
            }
            workingCopy.setAttribute("clearws", false);
            workingCopy.setAttribute("askclear", true);
            workingCopy.setAttribute("clearwslog", false);
            workingCopy.setAttribute("location", this.getUnoccupiedWorkspaceLocation(workingCopy.getName()));
            this.setDefaultsAttributes(workingCopy);
            workingCopy.doSave();
            if (this.page.isLaunchNeeded().booleanValue()) {
                LaunchUtils.launch((Aut)BaseAutManager.INSTANCE.getByName(workingCopy.getName()), (Shell)this.getShell());
            }
            return true;
        }
        catch (CoreException e) {
            Q7UIPlugin.log((Throwable)e);
            return false;
        }
    }

    private void setDefaultsAttributes(ILaunchConfigurationWorkingCopy configurationWc) throws CoreException {
        String log_directory = new Path(LaunchConfigurationHelper.getConfigurationArea((ILaunchConfiguration)configurationWc).getAbsolutePath()).append("console.log").toOSString();
        configurationWc.removeAttribute("org.eclipse.debug.core.capture_output");
        configurationWc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
        configurationWc.setAttribute("org.eclipse.debug.ui.ATTR_APPEND_TO_FILE", true);
        configurationWc.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", log_directory);
    }

    public static String getDefaultWorkspaceLocation(String uniqueName) {
        return "${workspace_loc}/../aut-" + uniqueName.replaceAll("\\s", "");
    }

    private String getUnoccupiedWorkspaceLocation(String name) {
        String stringPath = NewAUTWizard.getDefaultWorkspaceLocation(name);
        try {
            if (this.isLocationExists(stringPath)) {
                String newStringPath;
                int i = 1;
                while (this.isLocationExists(newStringPath = NewAUTWizard.getDefaultWorkspaceLocation(String.valueOf(name) + "-" + ++i))) {
                }
                stringPath = newStringPath;
            }
        }
        catch (CoreException e) {
            Q7UIPlugin.log((Throwable)e);
        }
        return stringPath;
    }

    private boolean isLocationExists(String location) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        location = manager.performStringSubstitution(location);
        Path autPath = new Path(location);
        File autDir = new File(autPath.toOSString());
        return autDir.exists() && autDir.isDirectory();
    }
}

