/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionRewrite {
    public static Type copyTypeAndAddDimensions(Type type, List<Dimension> extraDimensions, ASTRewrite rewrite) {
        ArrayType result;
        AST ast = rewrite.getAST();
        if (extraDimensions.isEmpty()) {
            return (Type)rewrite.createCopyTarget((ASTNode)type);
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type varElementType = (Type)rewrite.createCopyTarget((ASTNode)arrayType.getElementType());
            result = ast.newArrayType(varElementType, 0);
            result.dimensions().addAll(DimensionRewrite.copyDimensions(extraDimensions, rewrite));
            result.dimensions().addAll(DimensionRewrite.copyDimensions(arrayType.dimensions(), rewrite));
        } else {
            Type elementType = (Type)rewrite.createCopyTarget((ASTNode)type);
            result = ast.newArrayType(elementType, 0);
            result.dimensions().addAll(DimensionRewrite.copyDimensions(extraDimensions, rewrite));
        }
        return result;
    }

    public static List<Dimension> copyDimensions(List<Dimension> dimensions, ASTRewrite rewrite) {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        int i = 0;
        while (i < dimensions.size()) {
            result.add((Dimension)rewrite.createCopyTarget((ASTNode)dimensions.get(i)));
            ++i;
        }
        return result;
    }

    public static void removeAllChildren(ASTNode node, ChildListPropertyDescriptor childListProperty, ASTRewrite rewrite, TextEditGroup editGroup) {
        ListRewrite listRewrite = rewrite.getListRewrite(node, childListProperty);
        List children = (List)node.getStructuralProperty((StructuralPropertyDescriptor)childListProperty);
        for (ASTNode child : children) {
            listRewrite.remove(child, editGroup);
        }
    }
}

