/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.nested;

import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.navigator.resources.nested.PathComparator;

public class NestedProjectManager {
    private static NestedProjectManager INSTANCE = new NestedProjectManager();
    private SortedMap<IPath, IProject> locationsToProjects = new TreeMap<IPath, IProject>(new PathComparator());

    private NestedProjectManager() {
        this.refreshProjectsList();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 1 && event.getDelta().getResource().getType() == 4) {
                    NestedProjectManager.this.refreshProjectsList();
                }
            }
        });
    }

    private void refreshProjectsListIfNeeded() {
        if (this.locationsToProjects.size() != ResourcesPlugin.getWorkspace().getRoot().getProjects().length) {
            this.refreshProjectsList();
        }
    }

    private void refreshProjectsList() {
        this.locationsToProjects.clear();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.locationsToProjects.put(project.getLocation(), project);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NestedProjectManager getInstance() {
        NestedProjectManager nestedProjectManager = INSTANCE;
        synchronized (nestedProjectManager) {
            if (INSTANCE == null) {
                INSTANCE = new NestedProjectManager();
            }
        }
        return INSTANCE;
    }

    public IProject getProject(IFolder folder) {
        if (folder == null) {
            return null;
        }
        this.refreshProjectsListIfNeeded();
        IProject res = (IProject)this.locationsToProjects.get(folder.getLocation());
        if (!(res == null || res.exists() && res.getLocation().equals((Object)folder.getLocation()))) {
            this.refreshProjectsList();
            return this.getProject(folder);
        }
        return res;
    }

    public boolean isShownAsProject(IFolder folder) {
        return this.getProject(folder) != null;
    }

    public boolean isShownAsNested(IProject project) {
        if (!project.exists()) {
            return false;
        }
        IPath queriedLocation = project.getLocation().removeLastSegments(1);
        while (queriedLocation.segmentCount() > 0) {
            if (this.locationsToProjects.containsKey(queriedLocation)) {
                return true;
            }
            queriedLocation = queriedLocation.removeLastSegments(1);
        }
        return false;
    }

    public IContainer getMostDirectOpenContainer(IProject project) {
        IProject mostDirectParentProject = null;
        IPath queriedLocation = project.getLocation().removeLastSegments(1);
        while (mostDirectParentProject == null && queriedLocation.segmentCount() > 0) {
            if (this.locationsToProjects.containsKey(queriedLocation)) {
                mostDirectParentProject = (IProject)this.locationsToProjects.get(queriedLocation);
            }
            queriedLocation = queriedLocation.removeLastSegments(1);
        }
        if (mostDirectParentProject != null) {
            IPath parentContainerAbsolutePath = project.getLocation().removeLastSegments(1);
            if (parentContainerAbsolutePath.equals((Object)mostDirectParentProject.getLocation())) {
                return mostDirectParentProject;
            }
            IPath parentFolderPathRelativeToProject = parentContainerAbsolutePath.removeFirstSegments(mostDirectParentProject.getLocation().segmentCount());
            return mostDirectParentProject.getFolder(parentFolderPathRelativeToProject);
        }
        return null;
    }
}

