/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.parser.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rcptt.core.ecl.parser.ast.Node;
import org.eclipse.rcptt.core.ecl.parser.ast.NodeVisitor;
import org.eclipse.rcptt.core.ecl.parser.ast.Script;
import org.eclipse.rcptt.core.ecl.parser.model.NodePath;

public class PathBuilder
implements NodeVisitor {
    private int offset;
    private boolean inclusiveEnd;
    private List<Node> nodes = new ArrayList<Node>();

    public static NodePath path(Script script, int offset) {
        return PathBuilder.path(script, offset, false);
    }

    public static NodePath path(Script script, int offset, boolean inclusiveEnd) {
        PathBuilder visitor = new PathBuilder(offset, inclusiveEnd);
        script.accept(visitor);
        return new NodePath(visitor.nodes, script, offset);
    }

    public PathBuilder(int offset, boolean inclusiveEnd) {
        this.offset = offset;
        this.inclusiveEnd = inclusiveEnd;
    }

    @Override
    public boolean enter(Node node) {
        boolean after;
        if (node.begin > this.offset) {
            return false;
        }
        boolean bl = this.inclusiveEnd ? node.end < this.offset : (after = node.end <= this.offset);
        if (after) {
            return false;
        }
        this.nodes.add(node);
        return true;
    }

    @Override
    public void exit(Node node) {
    }
}

