/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.Java50Fix;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java50CleanUp
extends AbstractMultiFix {
    public Java50CleanUp(Map<String, String> options) {
        super(options);
    }

    public Java50CleanUp() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.requireAST();
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    private boolean requireAST() {
        boolean addAnotations = this.isEnabled("cleanup.add_missing_annotations");
        return addAnotations && this.isEnabled("cleanup.add_missing_override_annotations") || addAnotations && this.isEnabled("cleanup.add_missing_deprecated_annotations") || this.isEnabled("cleanup.use_arguments_for_raw_type_references");
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        boolean addAnotations = this.isEnabled("cleanup.add_missing_annotations");
        boolean addOverride = this.isEnabled("cleanup.add_missing_override_annotations");
        return Java50Fix.createCleanUp(compilationUnit, addAnotations && addOverride, addAnotations && addOverride && this.isEnabled("cleanup.add_missing_override_annotations_interface_methods"), addAnotations && this.isEnabled("cleanup.add_missing_deprecated_annotations"), this.isEnabled("cleanup.use_arguments_for_raw_type_references"));
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean addAnnotations = this.isEnabled("cleanup.add_missing_annotations");
        boolean addOverride = this.isEnabled("cleanup.add_missing_override_annotations");
        return Java50Fix.createCleanUp(compilationUnit, problems, addAnnotations && addOverride, addAnnotations && addOverride && this.isEnabled("cleanup.add_missing_override_annotations_interface_methods"), addAnnotations && this.isEnabled("cleanup.add_missing_deprecated_annotations"), this.isEnabled("cleanup.use_arguments_for_raw_type_references"));
    }

    private Map<String, String> getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            result.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "warning");
            if (this.isEnabled("cleanup.add_missing_override_annotations_interface_methods")) {
                result.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotationForInterfaceMethodImplementation", "enabled");
            }
        }
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            result.put("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", "warning");
        }
        if (this.isEnabled("cleanup.use_arguments_for_raw_type_references")) {
            result.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "warning");
        }
        return result;
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            result.add(MultiFixMessages.Java50MultiFix_AddMissingOverride_description);
            if (this.isEnabled("cleanup.add_missing_override_annotations_interface_methods")) {
                result.add(MultiFixMessages.Java50MultiFix_AddMissingOverride_description2);
            }
        }
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            result.add(MultiFixMessages.Java50MultiFix_AddMissingDeprecated_description);
        }
        if (this.isEnabled("cleanup.use_arguments_for_raw_type_references")) {
            result.add(MultiFixMessages.Java50CleanUp_AddTypeParameters_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("class E {\n");
        buf.append("    /**\n");
        buf.append("     * @deprecated\n");
        buf.append("     */\n");
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            buf.append("    @Deprecated\n");
        }
        buf.append("    public void foo() {}\n");
        buf.append("}\n");
        buf.append("class ESub extends E implements Runnable {\n");
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            buf.append("    @Override\n");
        }
        buf.append("    public void foo() {}\n");
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations") && this.isEnabled("cleanup.add_missing_override_annotations_interface_methods")) {
            buf.append("    @Override\n");
        }
        buf.append("    public void run() {}\n");
        buf.append("}\n");
        return buf.toString();
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        int id = problem.getProblemId();
        if (Java50Fix.isMissingOverrideAnnotationProblem(id)) {
            if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
                return !Java50Fix.isMissingOverrideAnnotationInterfaceProblem(id) || this.isEnabled("cleanup.add_missing_override_annotations_interface_methods");
            }
        } else {
            if (Java50Fix.isMissingDeprecationProblem(id)) {
                return this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations");
            }
            if (Java50Fix.isRawTypeReferenceProblem(id)) {
                return this.isEnabled("cleanup.use_arguments_for_raw_type_references");
            }
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        boolean addAnnotations = this.isEnabled("cleanup.add_missing_annotations");
        boolean addMissingOverride = addAnnotations && this.isEnabled("cleanup.add_missing_override_annotations");
        boolean addMissingOverrideInterfaceMethods = addMissingOverride && this.isEnabled("cleanup.add_missing_override_annotations_interface_methods");
        boolean addMissingDeprecated = addAnnotations && this.isEnabled("cleanup.add_missing_deprecated_annotations");
        boolean useTypeArgs = this.isEnabled("cleanup.use_arguments_for_raw_type_references");
        IProblem[] problems = compilationUnit.getProblems();
        int i = 0;
        while (i < problems.length) {
            int id = problems[i].getID();
            if (addMissingOverride && Java50Fix.isMissingOverrideAnnotationProblem(id) && (!Java50Fix.isMissingOverrideAnnotationInterfaceProblem(id) || addMissingOverrideInterfaceMethods)) {
                ++result;
            }
            if (addMissingDeprecated && Java50Fix.isMissingDeprecationProblem(id)) {
                ++result;
            }
            if (useTypeArgs && Java50Fix.isRawTypeReferenceProblem(id)) {
                ++result;
            }
            ++i;
        }
        return result;
    }
}

