/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateRepositoryPage
extends WizardPage {
    private final boolean hideBare;
    private Text directoryText;
    private Button bareButton;

    public CreateRepositoryPage(boolean hideBareOption) {
        super(CreateRepositoryPage.class.getName());
        this.hideBare = hideBareOption;
        this.setTitle(UIText.CreateRepositoryPage_PageTitle);
        this.setMessage(UIText.CreateRepositoryPage_PageMessage);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        Label directoryLabel = new Label(main, 0);
        directoryLabel.setText(UIText.CreateRepositoryPage_DirectoryLabel);
        this.directoryText = new Text(main, 2048);
        this.directoryText.setText(UIUtils.getDefaultRepositoryDir());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.directoryText);
        Button browseButton = new Button(main, 8);
        browseButton.setText(UIText.CreateRepositoryPage_BrowseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result;
                String previous = CreateRepositoryPage.this.directoryText.getText();
                File previousFile = new File(previous);
                DirectoryDialog dialog = new DirectoryDialog(CreateRepositoryPage.this.getShell());
                if (previousFile.exists() && previousFile.isDirectory()) {
                    dialog.setFilterPath(previousFile.getPath());
                }
                if ((result = dialog.open()) != null) {
                    CreateRepositoryPage.this.directoryText.setText(result);
                }
            }
        });
        if (!this.hideBare) {
            this.bareButton = new Button(main, 32);
            this.bareButton.setText(UIText.CreateRepositoryPage_BareCheckbox);
            GridDataFactory.fillDefaults().indent(10, 0).span(3, 1).applyTo((Control)this.bareButton);
            this.bareButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CreateRepositoryPage.this.checkPage();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    CreateRepositoryPage.this.checkPage();
                }
            });
        }
        this.directoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateRepositoryPage.this.checkPage();
            }
        });
        this.setControl((Control)main);
        this.directoryText.setFocus();
        this.directoryText.setSelection(this.directoryText.getText().length());
    }

    public String getDirectory() {
        Path path = new Path(this.directoryText.getText().trim());
        return path.toOSString();
    }

    public boolean getBare() {
        return this.bareButton != null && this.bareButton.getSelection();
    }

    void checkPage() {
        boolean hasFiles;
        String dir;
        block11: {
            File testFile;
            block10: {
                block9: {
                    block8: {
                        this.setErrorMessage(null);
                        try {
                            dir = this.directoryText.getText().trim();
                            if (dir.length() != 0) break block8;
                            this.setErrorMessage(UIText.CreateRepositoryPage_PleaseSelectDirectoryMessage);
                        }
                        catch (Throwable throwable) {
                            this.setPageComplete(this.getErrorMessage() == null);
                            throw throwable;
                        }
                        this.setPageComplete(this.getErrorMessage() == null);
                        return;
                    }
                    testFile = new File(dir);
                    IPath path = Path.fromOSString((String)dir);
                    if (path.isAbsolute()) break block9;
                    this.setErrorMessage(UIText.CreateRepositoryPage_PleaseUseAbsolutePathMessage);
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                if (!testFile.exists() || testFile.isDirectory()) break block10;
                this.setErrorMessage(NLS.bind((String)UIText.CreateRepositoryPage_NotADirectoryMessage, (Object)dir));
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            boolean bl = hasFiles = testFile.exists() && testFile.list().length > 0;
            if (!hasFiles || !this.getBare()) break block11;
            this.setErrorMessage(NLS.bind((String)UIText.CreateRepositoryPage_NotEmptyMessage, (Object)dir));
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        if (hasFiles && !this.getBare()) {
            this.setMessage(NLS.bind((String)UIText.CreateRepositoryPage_NotEmptyMessage, (Object)dir), 1);
        } else {
            this.setMessage(UIText.CreateRepositoryPage_PageMessage);
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

