/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.handlers;

import java.util.Objects;
import java.util.Optional;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.equinox.app.IApplicationContext;

public class OpenPerspectiveHandler {
    @Execute
    public void execute(IApplicationContext applicationContext, MWindow window, EPartService partService, @Named(value="org.eclipse.passage.loc.workbench.commandparameter.perspective.id") String perspectiveId) {
        String brandingName = applicationContext.getBrandingName();
        Optional switched = partService.switchPerspective(perspectiveId);
        if (switched.isPresent()) {
            MPerspective perspective = (MPerspective)switched.get();
            String label = perspective.getLocalizedLabel();
            String title = brandingName + " - " + label;
            window.setLabel(title);
        }
    }

    @CanExecute
    public boolean canExecute(MWindow window, EModelService modelService, @Named(value="org.eclipse.passage.loc.workbench.commandparameter.perspective.id") String perspectiveId) {
        MUIElement found = modelService.find(perspectiveId, (MUIElement)window);
        if (found instanceof MPerspective) {
            MPerspective active = modelService.getActivePerspective(window);
            if (active == null) {
                return true;
            }
            return !Objects.equals(perspectiveId, active.getElementId());
        }
        return false;
    }
}

