/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.passage.loc.jface.LocImages;
import org.eclipse.swt.graphics.Image;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component
public final class LocImageRegistry
implements LocImages {
    private final ImageRegistry images = new ImageRegistry();

    @Activate
    public void register() {
        this.addBaseImages();
    }

    private void addBaseImages() {
        String pattern = "platform:/plugin/org.eclipse.passage.loc.workbench/images/%s";
        this.register("IMG_TOOL_ADD", String.format(pattern, "add.png"));
        this.register("IMG_TOOL_EDIT", String.format(pattern, "edit.png"));
        this.register("IMG_TOOL_REMOVE", String.format(pattern, "remove.png"));
    }

    private void register(String key, String url) {
        try {
            ImageDescriptor created = ImageDescriptor.createFromURL((URL)new URL(url));
            this.images.put(key, created);
        }
        catch (MalformedURLException e) {
            Platform.getLog(this.getClass()).log(Status.error((String)key, (Throwable)e));
        }
    }

    @Deactivate
    public void deactivate() {
        this.images.dispose();
    }

    @Override
    public Image getImage(String identifier) {
        return this.images.get(identifier);
    }

    @Override
    public ImageDescriptor getImageDescriptor(String identifier) {
        return this.images.getDescriptor(identifier);
    }
}

