/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.license;

import java.util.Optional;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.passage.lic.internal.api.MandatoryService;
import org.eclipse.passage.loc.dashboard.ui.wizards.license.LabeledField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

abstract class TextField
extends LabeledField<String> {
    private Text text;

    protected TextField(Optional<String> source, Runnable modified, LabelProvider labels, MandatoryService context) {
        super(source, modified, labels, context);
    }

    @Override
    public Optional<String> error() {
        return this.noData() ? Optional.of(this.errorText()) : Optional.empty();
    }

    private boolean noData() {
        return this.data().isEmpty() || ((String)this.data().get()).trim().isEmpty();
    }

    @Override
    protected Control control(Composite parent) {
        this.installText(parent);
        return this.text;
    }

    @Override
    protected void reflectData(String data) {
        this.text.setText(this.labels.getText((Object)data));
    }

    private void installText(Composite parent) {
        this.text = new Text(parent, 2048);
        this.text.addModifyListener(m -> this.onModify());
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
    }

    private void onModify() {
        this.text.setData((Object)this.text.getText().trim());
        this.modified.run();
    }

    @Override
    protected void enableAuxiliaryControls(boolean enable) {
    }

    @Override
    protected abstract String label();

    protected abstract String errorText();
}

