/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.osgi.framework.FrameworkUtil;

public final class StatusFromException
implements Supplier<IStatus> {
    private final Throwable throwable;

    public StatusFromException(Throwable throwable) {
        this.throwable = throwable;
    }

    @Override
    public IStatus get() {
        String identifier = this.identifier(Diagnostic.class);
        Status[] children = this.causes().stream().flatMap(this::segments).map(segment -> new Status(4, identifier, segment)).collect(Collectors.toList()).toArray(new Status[0]);
        return new MultiStatus(identifier, 4, (IStatus[])children, this.throwable.toString(), this.throwable);
    }

    private String identifier(Class<?> caller) {
        return Optional.ofNullable(caller).flatMap(c -> Optional.ofNullable(FrameworkUtil.getBundle((Class)c))).map(b -> b.getSymbolicName()).orElseGet(() -> Optional.ofNullable(caller).map(c -> c.getName()).orElse(this.getClass().getName()));
    }

    private List<Throwable> causes() {
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        Throwable current = this.throwable;
        while (current != null) {
            causes.add(current);
            current = current.getCause();
        }
        return causes;
    }

    private Stream<String> segments(Throwable thro) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(String.format("|>>>>> %s", thro.getLocalizedMessage()));
        StackTraceElement[] stackTraceElementArray = thro.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            out.add(element.toString());
            ++n2;
        }
        return out.stream();
    }
}

