/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.function.Supplier;
import org.eclipse.passage.lic.internal.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.internal.base.diagnostic.NoErrors;
import org.eclipse.passage.lic.internal.base.restrictions.ExaminationExplained;
import org.eclipse.passage.lic.internal.equinox.ProductContacts;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.ButtonConfig;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.CertificateSummary;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.CopyToClipboard;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.GoodIntention;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.HereTable;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.LicensingStatus;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.NotificationDialog;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.RequirementStatus;
import org.eclipse.passage.lic.internal.jface.i18n.LicenseStatusDialogMessages;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public final class LicenseStatusDialog
extends NotificationDialog {
    private final ExaminationCertificate certificate;
    private final Diagnostic diagnostic;
    private GoodIntention intention = new GoodIntention.Nope();
    private StyledText notice;

    public LicenseStatusDialog(Shell shell, ExaminationCertificate certificate, Diagnostic diagnostic) {
        super(shell);
        this.certificate = certificate;
        this.diagnostic = diagnostic;
    }

    public GoodIntention goodIntention() {
        return this.intention;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(LicenseStatusDialogMessages.LicenseStatusDialog_title);
        shell.setImage(LicenseStatusDialog.getDefaultImage());
        shell.setSize(740, 600);
    }

    @Override
    protected void buildUI(Composite parent) {
        this.viewer = new HereTable<RequirementStatus>(parent, RequirementStatus.class).withColumn(LicenseStatusDialogMessages.LicenseStatusDialog_column_id, 500, RequirementStatus::feature).withColumn(LicenseStatusDialogMessages.LicenseStatusDialog_column_status, 200, RequirementStatus::status).viewer();
        this.notice = new StyledText(parent, 2056);
        this.notice.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    @Override
    protected void inplaceData() {
        this.viewer.setInput(new LicensingStatus(this.certificate).get());
        this.notice.setText(new ProductContacts().get());
    }

    @Override
    protected void initButtons() {
        new ButtonConfig(1, this::requestLicense, LicenseStatusDialogMessages.LicenseStatusDialog_intention_request, LicenseStatusDialogMessages.LicenseStatusDialog_intention_request_tooltip, "").reside(this.buttons);
        new ButtonConfig(2, this::importLicense, LicenseStatusDialogMessages.LicenseStatusDialog_intention_import, LicenseStatusDialogMessages.LicenseStatusDialog_intention_import_tooltip, "").reside(this.buttons);
        new ButtonConfig(3, this.copy(), LicenseStatusDialogMessages.LicenseStatusDialog_intention_copy, LicenseStatusDialogMessages.LicenseStatusDialog_intention_copy_tooltip, "").reside(this.buttons);
        if (!new NoErrors().test(this.diagnostic)) {
            new ButtonConfig(4, this::diagnose, LicenseStatusDialogMessages.LicenseStatusDialog_intention_diagnose, LicenseStatusDialogMessages.LicenseStatusDialog_intention_diagnose_tooltip, "").reside(this.buttons);
        }
    }

    @Override
    protected void updateButtonsEnablement() {
    }

    @Override
    protected void initMessage() {
        new CertificateSummary(this.certificate).accept(this);
    }

    private void requestLicense() {
        this.intention = new GoodIntention.RequestLicense(() -> ((LicenseStatusDialog)this).getShell());
        super.okPressed();
    }

    private void importLicense() {
        this.intention = new GoodIntention.ImportLicense(() -> ((LicenseStatusDialog)this).getShell());
        super.okPressed();
    }

    private void diagnose() {
        this.intention = new GoodIntention.Diagnose(() -> ((LicenseStatusDialog)this).getShell(), this.diagnostic);
        super.okPressed();
    }

    private Runnable copy() {
        return new CopyToClipboard(() -> ((LicenseStatusDialog)this).getShell(), new Supplier[]{new ExaminationExplained(this.certificate), new DiagnosticExplained(this.diagnostic)});
    }
}

