/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl.mine;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.passage.lic.floating.model.api.FloatingServerConnection;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.internal.api.conditions.ConditionOrigin;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransportRegistry;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.ServiceId;
import org.eclipse.passage.lic.internal.base.conditions.BaseConditionOrigin;
import org.eclipse.passage.lic.internal.base.conditions.BaseConditionPack;
import org.eclipse.passage.lic.internal.hc.i18n.MineMessages;
import org.eclipse.passage.lic.internal.hc.remote.ResponseHandler;
import org.eclipse.passage.lic.internal.hc.remote.impl.ResultsTransfered;

final class DecryptedConditions
implements ResponseHandler<Collection<ConditionPack>> {
    private final ConditionTransportRegistry transports;
    private final FloatingServerConnection coordinates;
    private final ConditionMiningTarget target;

    DecryptedConditions(ConditionTransportRegistry transports, FloatingServerConnection coordinates, ConditionMiningTarget target) {
        this.transports = transports;
        this.coordinates = coordinates;
        this.target = target;
    }

    @Override
    public Collection<ConditionPack> read(ResultsTransfered results) throws LicensingException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(results.data());){
                return Collections.singleton(new BaseConditionPack((ConditionOrigin)new BaseConditionOrigin(this.target, this.source()), this.transport(results.contentType()).read((InputStream)stream)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new LicensingException(MineMessages.DecryptedConditions_reading_error, (Throwable)e);
        }
    }

    private String source() {
        return String.format("%s:%d", this.coordinates.getIp(), this.coordinates.getPort());
    }

    private ConditionTransport transport(ContentType contentType) throws LicensingException {
        if (!((Registry)this.transports.get()).hasService((ServiceId)contentType)) {
            throw new LicensingException(String.format(MineMessages.DecryptedConditions_no_transport_for_content_type, contentType.contentType()));
        }
        return (ConditionTransport)((Registry)this.transports.get()).service((ServiceId)contentType);
    }
}

