/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.wizards;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.lic.emf.edit.ClassifierInitializer;
import org.eclipse.passage.loc.workbench.LocWokbench;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateFileWizardPage
extends WizardPage {
    protected final EObject eObject;
    protected Text txtResourceURI;
    protected Text txtId;
    protected Text txtName;
    private Button resourceURIBrowseFileSystemButton;
    protected ModifyListener validator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CreateFileWizardPage.this.setPageComplete(CreateFileWizardPage.this.validatePage());
        }
    };
    private String extension;
    private ClassifierInitializer initializer;
    private boolean createName;
    private boolean createId;

    public CreateFileWizardPage(String pageName, EObject eObject, String extension, ClassifierInitializer initializer, boolean createId, boolean createName) {
        super(pageName);
        this.extension = extension;
        this.initializer = initializer;
        this.createId = createId;
        this.createName = createName;
        this.eObject = eObject;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createFileControls(composite);
        this.createOtherControls(composite);
        this.initControls(this.initializer);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    protected void createFileControls(Composite composite) {
        GridData data;
        if (this.createId) {
            Label idFieldLabel = new Label(composite, 16384);
            idFieldLabel.setText("&Identifier:");
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = false;
            data.horizontalSpan = 1;
            idFieldLabel.setLayoutData((Object)data);
            this.txtId = new Text(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 2;
            this.txtId.setLayoutData((Object)data);
        }
        if (this.createName) {
            Label nameFieldILabel = new Label(composite, 16384);
            nameFieldILabel.setText("&Name:");
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = false;
            data.horizontalSpan = 1;
            nameFieldILabel.setLayoutData((Object)data);
            this.txtName = new Text(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 2;
            this.txtName.setLayoutData((Object)data);
        }
        Label resourceURILabel = new Label(composite, 16384);
        resourceURILabel.setText("&File:");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = false;
        data.horizontalSpan = 1;
        resourceURILabel.setLayoutData((Object)data);
        this.txtResourceURI = new Text(composite, 2048);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 1;
        this.txtResourceURI.setLayoutData((Object)data);
        this.resourceURIBrowseFileSystemButton = new Button(composite, 8);
        this.resourceURIBrowseFileSystemButton.setText("Browse ...");
        this.txtResourceURI.addModifyListener(this.validator);
        this.resourceURIBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String selected = LocWokbench.selectSavePath(CreateFileWizardPage.this.getShell(), CreateFileWizardPage.this.extension);
                if (selected != null) {
                    CreateFileWizardPage.this.txtResourceURI.setText(selected);
                }
            }
        });
    }

    protected void initControls(ClassifierInitializer initializer) {
        String basePath = this.getBasePath();
        String fileName = initializer.newFileName();
        String resourceURI = String.valueOf(basePath) + File.separator + fileName + '.' + this.extension;
        this.txtResourceURI.setText(resourceURI);
        if (this.txtId != null) {
            this.txtId.setText(initializer.newObjectIdentifier());
        }
        if (this.txtName != null) {
            this.txtName.setText(initializer.newObjectName());
        }
    }

    protected String getBasePath() {
        return System.getProperty("user.home");
    }

    protected boolean validatePage() {
        String textName;
        String textId;
        URI fileURI = this.getFileURI();
        boolean validationResult = true;
        if (fileURI == null || fileURI.isEmpty()) {
            this.setMessage("Please specify a file path");
            validationResult = false;
        }
        if (this.createId && ((textId = this.getIdentifier()) == null || textId.isEmpty())) {
            this.setMessage("Please specify the identifier");
            validationResult = false;
        }
        if (this.createName && ((textName = this.getName()) == null || textName.isEmpty())) {
            this.setMessage("Please specify the name");
            validationResult = false;
        }
        return validationResult;
    }

    public String getIdentifier() {
        if (this.txtId == null) {
            return "";
        }
        return this.txtId.getText();
    }

    public String getName() {
        if (this.txtName == null) {
            return "";
        }
        return this.txtName.getText();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.txtResourceURI.setFocus();
        }
    }

    public URI getFileURI() {
        try {
            String text = this.txtResourceURI.getText();
            if (text != null && !text.endsWith(String.valueOf('.') + this.extension)) {
                text = String.valueOf(text) + '.' + this.extension;
            }
            return URI.createFileURI((String)text);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void selectFileField() {
        this.txtResourceURI.selectAll();
        this.txtResourceURI.setFocus();
    }

    protected void createOtherControls(Composite composite) {
    }
}

