/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.sync;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SyncActionType implements Enumerator
{
    NONE(0, "None", "None"),
    SET_LOCAL(1, "SetLocal", "SetLocal"),
    SET_REMOTE(2, "SetRemote", "SetRemote"),
    REMOVE_LOCAL(3, "RemoveLocal", "RemoveLocal"),
    REMOVE_REMOTE(4, "RemoveRemote", "RemoveRemote"),
    CONFLICT(5, "Conflict", "Conflict"),
    EXCLUDE(6, "Exclude", "Exclude");

    public static final int NONE_VALUE = 0;
    public static final int SET_LOCAL_VALUE = 1;
    public static final int SET_REMOTE_VALUE = 2;
    public static final int REMOVE_LOCAL_VALUE = 3;
    public static final int REMOVE_REMOTE_VALUE = 4;
    public static final int CONFLICT_VALUE = 5;
    public static final int EXCLUDE_VALUE = 6;
    private static final SyncActionType[] VALUES_ARRAY;
    public static final List<SyncActionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SyncActionType[]{NONE, SET_LOCAL, SET_REMOTE, REMOVE_LOCAL, REMOVE_REMOTE, CONFLICT, EXCLUDE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SyncActionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SyncActionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SyncActionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SyncActionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SyncActionType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return SET_LOCAL;
            }
            case 2: {
                return SET_REMOTE;
            }
            case 3: {
                return REMOVE_LOCAL;
            }
            case 4: {
                return REMOVE_REMOTE;
            }
            case 5: {
                return CONFLICT;
            }
            case 6: {
                return EXCLUDE;
            }
        }
        return null;
    }

    private SyncActionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

