/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.oomph.internal.ui.FlatButton;
import org.eclipse.oomph.internal.ui.ImageHoverButton;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.oomph.ui.SearchField;
import org.eclipse.oomph.ui.StackComposite;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchMessages;

public class SimpleSearchField
extends Composite {
    private Text searchField;
    private Label searchLabel;
    private FlatButton clearSearchButton;
    private StackComposite buttonComposite;

    public SimpleSearchField(Composite parent, final SearchField.FilterHandler filterHandler) {
        super(parent, 0);
        GridLayout layout = UIUtil.createGridLayout((int)2);
        layout.horizontalSpacing = 0;
        layout.marginLeft = 18;
        layout.marginRight = 24;
        this.setLayout((Layout)layout);
        this.setBackgroundMode(2);
        this.searchField = new Text((Composite)this, 0);
        this.searchField.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true).create());
        this.searchField.setMessage(WorkbenchMessages.FilteredTree_FilterMessage);
        this.searchField.setFont(SimpleInstallerDialog.getFont(2, "normal"));
        this.searchField.setBackground(this.getDisplay().getSystemColor(1));
        this.searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                filterHandler.handleFilter(SimpleSearchField.this.searchField.getText());
                SimpleSearchField.this.updateSearchAction();
            }
        });
        this.searchField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 27 && !"".equals(SimpleSearchField.this.searchField.getText())) {
                    SimpleSearchField.this.searchField.setText("");
                    e.doit = false;
                }
            }
        });
        this.searchField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000002) {
                    SimpleSearchField.this.finishFilter();
                    e.doit = false;
                }
            }
        });
        this.buttonComposite = new StackComposite((Composite)this, 0);
        this.buttonComposite.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(false, true).create());
        this.searchLabel = new Label((Composite)this.buttonComposite, 0);
        this.searchLabel.setImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/search.png"));
        this.clearSearchButton = new ImageHoverButton((Composite)this.buttonComposite, 8, SetupInstallerPlugin.INSTANCE.getSWTImage("simple/search_erase.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/search_erase_hover.png"));
        this.clearSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleSearchField.this.searchField.setText("");
            }
        });
        this.setBackground(UIUtil.getDisplay().getSystemColor(1));
        this.updateSearchAction();
    }

    public String getFilterText() {
        return this.searchField.getText();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.searchField.setFont(font);
    }

    protected void finishFilter() {
    }

    private void updateSearchAction() {
        boolean containsText = !StringUtil.isEmpty((String)this.searchField.getText());
        this.buttonComposite.setTopControl((Control)(containsText ? this.clearSearchButton : this.searchLabel));
    }
}

