/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.felix.resolver.Candidates;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.Util;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

class ProblemReduction {
    private static final Capability[] EMPTY_CAPABILITIES = new Capability[0];

    ProblemReduction() {
    }

    static List<Candidates> removeUsesViolations(Candidates candidates, Requirement requirement, Logger logger) {
        boolean repeat;
        Resource targetResource = requirement.getResource();
        Capability currentCandidate = candidates.getFirstCandidate(requirement);
        Resource candidateResource = currentCandidate.getResource();
        TreeSet<String> uses = new TreeSet<String>(Util.getUses(currentCandidate));
        if (uses.isEmpty()) {
            return Collections.emptyList();
        }
        if (logger.isDebugEnabled()) {
            logger.logRequirement("=== remove uses violations for %s", requirement);
            logger.logCapability("== current candidate is %s", currentCandidate);
            logger.logCandidates(targetResource, req -> ProblemReduction.getCapabilityList(candidates, req));
        }
        int round = 0;
        ArrayList<Candidates> dropped = new ArrayList<Candidates>();
        do {
            repeat = false;
            ++round;
            if (logger.isDebugEnabled()) {
                logger.debug("Round " + round + ":");
                for (String usedPackage : uses) {
                    logger.debug(" uses: " + usedPackage);
                }
            }
            for (Requirement packageRequirement : targetResource.getRequirements("osgi.wiring.package")) {
                Capability providedPackage;
                if (packageRequirement == requirement || (providedPackage = candidates.getCapability(candidateResource, packageRequirement)) == null || !uses.contains(Util.getPackageName(providedPackage))) continue;
                Capability capability = ProblemReduction.removeViolators(candidates, candidateResource, packageRequirement, dropped);
                repeat |= uses.addAll(Util.getUses(capability));
            }
        } while (repeat);
        if (logger.isDebugEnabled() && !dropped.isEmpty()) {
            logger.debug("After removal (" + dropped.size() + " dropped)");
            logger.logCandidates(targetResource, req -> ProblemReduction.getCapabilityList(candidates, req));
        }
        return dropped;
    }

    private static Capability removeViolators(Candidates candidates, Resource candidateResource, Requirement packageRequirement, List<Candidates> dropped) {
        Capability capability;
        while ((capability = candidates.getFirstCandidate(packageRequirement)).getResource() != candidateResource) {
            dropped.add(candidates.copy());
            candidates.removeFirstCandidate(packageRequirement);
        }
        return capability;
    }

    private static List<Capability> getCapabilityList(Candidates candidates, Requirement requirement) {
        List<Capability> list = candidates.getCandidates(requirement);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }
}

