/*
 * Copyright (c) 2014, 2015 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.oomph.p2;

import org.eclipse.emf.ecore.EFactory;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.oomph.p2.P2Package
 * @generated
 */
public interface P2Factory extends EFactory
{
  /**
   * The singleton instance of the factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  P2Factory eINSTANCE = org.eclipse.oomph.p2.impl.P2FactoryImpl.init();

  /**
   * Returns a new object of class '<em>Profile Definition</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>Profile Definition</em>'.
   * @generated
   */
  ProfileDefinition createProfileDefinition();

  /**
   * Returns a new object of class '<em>Configuration</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>Configuration</em>'.
   * @generated
   */
  Configuration createConfiguration();

  /**
   * Returns a new object of class '<em>Requirement</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>Requirement</em>'.
   * @generated
   */
  Requirement createRequirement();

  Requirement createRequirement(String id);

  Requirement createRequirement(String id, VersionRange versionRange);

  Requirement createRequirement(String id, VersionRange versionRange, boolean optional);

  Requirement createRequirement(String id, VersionRange versionRange, boolean optional, boolean greedy);

  Requirement createRequirement(String id, Version version);

  Requirement createRequirement(String id, Version version, boolean optional);

  Requirement createRequirement(String id, Version version, boolean optional, boolean greedy);

  /**
   * Returns a new object of class '<em>Repository List</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>Repository List</em>'.
   * @generated
   */
  RepositoryList createRepositoryList();

  /**
   * Returns a new object of class '<em>Repository</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>Repository</em>'.
   * @generated
   */
  Repository createRepository();

  Repository createRepository(String url);

  VersionRange createVersionRange(Version version, VersionSegment segment);

  VersionRange createVersionRange(Version version, VersionSegment segment, boolean compatible);

  /**
   * Returns the package supported by this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the package supported by this factory.
   * @generated
   */
  P2Package getP2Package();

} // P2Factory
