/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.oomph.internal.version.Activator;
import org.eclipse.oomph.internal.version.IVersionBuilderArguments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionBuilderArguments
extends HashMap<String, String>
implements IVersionBuilderArguments {
    private static final long serialVersionUID = 1L;

    public VersionBuilderArguments() {
    }

    public VersionBuilderArguments(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public VersionBuilderArguments(int initialCapacity) {
        super(initialCapacity);
    }

    public VersionBuilderArguments(Map<? extends String, ? extends String> m) {
        super(m);
    }

    public VersionBuilderArguments(IProject project) {
        this((Map<? extends String, ? extends String>)VersionBuilderArguments.getArgumentsFromProject(project));
    }

    @Override
    public String getReleasePath() {
        return (String)this.get("release.path");
    }

    public void setReleasePath(String value) {
        this.setString("release.path", value);
    }

    @Override
    public String getValidatorClassName() {
        return (String)this.get("validator.class");
    }

    public void setValidatorClassName(String value) {
        this.setString("validator.class", value);
    }

    @Override
    public boolean isIgnoreMalformedVersions() {
        return "true".equals(this.get("ignore.malformed.versions"));
    }

    public void setIgnoreMalformedVersions(boolean value) {
        this.setBoolean("ignore.malformed.versions", value);
    }

    @Override
    public boolean isIgnoreFeatureNature() {
        return "true".equals(this.get("ignore.feature.nature"));
    }

    public void setIgnoreFeatureNature(boolean value) {
        this.setBoolean("ignore.feature.nature", value);
    }

    @Override
    public boolean isIgnoreSchemaBuilder() {
        return "true".equals(this.get("ignore.schema.builder"));
    }

    public void setIgnoreSchemaBuilder(boolean value) {
        this.setBoolean("ignore.schema.builder", value);
    }

    @Override
    public boolean isIgnoreDebugOptions() {
        return "true".equals(this.get("ignore.debug.options"));
    }

    public void setIgnoreDebugOptions(boolean value) {
        this.setBoolean("ignore.debug.options", value);
    }

    @Override
    public boolean isIgnoreMissingDependencyRanges() {
        return "true".equals(this.get("ignore.missing.dependency.ranges"));
    }

    public void setIgnoreMissingDependencyRanges(boolean value) {
        this.setBoolean("ignore.missing.dependency.ranges", value);
    }

    @Override
    public boolean isIgnoreLaxLowerBoundDependencyVersions() {
        return "true".equals(this.get("ignore.lower.bound.dependency.ranges"));
    }

    public void setIgnoreLaxLowerBoundDependencyVersions(boolean value) {
        this.setBoolean("ignore.lower.bound.dependency.ranges", value);
    }

    @Override
    public boolean isIgnoreMissingExportVersions() {
        return "true".equals(this.get("ignore.missing.export.versions"));
    }

    public void setIgnoreMissingExportVersions(boolean value) {
        this.setBoolean("ignore.missing.export.versions", value);
    }

    @Override
    public boolean isIgnoreFeatureContentChanges() {
        return "true".equals(this.get("ignore.feature.content.changes"));
    }

    public void setIgnoreFeatureContentChanges(boolean value) {
        this.setBoolean("ignore.feature.content.changes", value);
    }

    @Override
    public boolean isIgnoreFeatureContentRedundancy() {
        return "true".equals(this.get("ignore.feature.content.redundancy"));
    }

    public void setIgnoreFeatureContentRedundancy(boolean value) {
        this.setBoolean("ignore.feature.content.redundancy", value);
    }

    @Override
    public boolean isCheckFeatureClosureCompleteness() {
        return "true".equals(this.get("check.feature.closure.completeness"));
    }

    public void setCheckFeatureClosureCompleteness(boolean value) {
        this.setBoolean("check.feature.closure.completeness", value);
    }

    @Override
    public boolean isCheckMavenPom() {
        return "true".equals(this.get("check.maven.pom"));
    }

    public void setCheckMavenPom(boolean value) {
        this.setBoolean("check.maven.pom", value);
    }

    @Override
    public void applyTo(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        List<String> ids = VersionBuilderArguments.getOtherNatures(description);
        ids.add("org.eclipse.oomph.version.VersionNature");
        description.setNatureIds(ids.toArray(new String[ids.size()]));
        List<ICommand> commands = VersionBuilderArguments.getOtherBuildCommands(description);
        commands.add(this.createBuildCommand(description));
        description.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
        project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
    }

    private ICommand createBuildCommand(IProjectDescription description) {
        ICommand command = description.newCommand();
        command.setBuilderName("org.eclipse.oomph.version.VersionBuilder");
        command.setArguments((Map)this);
        return command;
    }

    private void setString(String key, String value) {
        if (value != null) {
            this.put(key, value);
        } else {
            this.remove(key);
        }
    }

    private void setBoolean(String key, boolean value) {
        if (value) {
            this.put(key, Boolean.toString(true));
        } else {
            this.remove(key);
        }
    }

    public static List<String> getOtherNatures(IProjectDescription description) {
        String[] natureIds = description.getNatureIds();
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList(natureIds));
        ids.remove("org.eclipse.oomph.version.VersionNature");
        return ids;
    }

    private static List<ICommand> getOtherBuildCommands(IProjectDescription description) {
        ICommand[] buildSpec = description.getBuildSpec();
        ArrayList<ICommand> commands = new ArrayList<ICommand>(Arrays.asList(buildSpec));
        Iterator it = commands.iterator();
        while (it.hasNext()) {
            ICommand command = (ICommand)it.next();
            if (!"org.eclipse.oomph.version.VersionBuilder".equals(command.getBuilderName())) continue;
            it.remove();
            break;
        }
        return commands;
    }

    private static Map<String, String> getArgumentsFromProject(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] iCommandArray = description.getBuildSpec();
            int n = iCommandArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand command = iCommandArray[n2];
                if ("org.eclipse.oomph.version.VersionBuilder".equals(command.getBuilderName())) {
                    return command.getArguments();
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            Activator.log(ex);
        }
        return new HashMap<String, String>();
    }
}

