/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.base.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLString;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.BaseResource;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.internal.base.BasePlugin;
import org.eclipse.oomph.util.ReflectUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseResourceImpl
extends XMIResourceImpl
implements BaseResource {
    private static final Method GET_ELEMENT_INDENT_METHOD = ReflectUtil.getMethod(XMLString.class, (String)"getElementIndent", (Class[])new Class[]{Integer.TYPE});
    private static final String[] ESCAPE;

    static {
        GET_ELEMENT_INDENT_METHOD.setAccessible(true);
        String[] stringArray = new String[64];
        stringArray[0] = "%00";
        stringArray[1] = "%01";
        stringArray[2] = "%02";
        stringArray[3] = "%03";
        stringArray[4] = "%04";
        stringArray[5] = "%05";
        stringArray[6] = "%06";
        stringArray[7] = "%07";
        stringArray[8] = "%08";
        stringArray[9] = "%09";
        stringArray[10] = "%0A";
        stringArray[11] = "%0B";
        stringArray[12] = "%0C";
        stringArray[13] = "%0D";
        stringArray[14] = "%0E";
        stringArray[15] = "%0F";
        stringArray[16] = "%10";
        stringArray[17] = "%11";
        stringArray[18] = "%12";
        stringArray[19] = "%13";
        stringArray[20] = "%14";
        stringArray[21] = "%15";
        stringArray[22] = "%16";
        stringArray[23] = "%17";
        stringArray[24] = "%18";
        stringArray[25] = "%19";
        stringArray[26] = "%1A";
        stringArray[27] = "%1B";
        stringArray[28] = "%1C";
        stringArray[29] = "%1D";
        stringArray[30] = "%1E";
        stringArray[31] = "%1F";
        stringArray[32] = "%20";
        stringArray[34] = "%22";
        stringArray[35] = "%23";
        stringArray[37] = "%25";
        stringArray[38] = "%26";
        stringArray[39] = "%27";
        stringArray[44] = "%2C";
        stringArray[47] = "%2F";
        stringArray[58] = "%3A";
        stringArray[60] = "%3C";
        stringArray[62] = "%3E";
        ESCAPE = stringArray;
    }

    public BaseResourceImpl(URI uri) {
        super(uri);
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        if (options.get("EXTENDED_META_DATA") instanceof Boolean) {
            ResourceSet resourceSet = this.getResourceSet();
            HashMap effectiveOptions = new HashMap(options);
            effectiveOptions.put("EXTENDED_META_DATA", new BasicExtendedMetaData(resourceSet == null ? EPackage.Registry.INSTANCE : resourceSet.getPackageRegistry()){

                public EStructuralFeature getElement(EClass eClass, String namespace, String name) {
                    EStructuralFeature eStructuralFeature = super.getElement(eClass, namespace, name);
                    if (eStructuralFeature == null) {
                        eStructuralFeature = super.getElement(eClass, namespace, name.substring(0, name.length() - 1));
                    }
                    if (eStructuralFeature == null) {
                        eStructuralFeature = eClass.getEStructuralFeature(name);
                    }
                    return eStructuralFeature;
                }
            });
            options = effectiveOptions;
        }
        super.doLoad(inputStream, options);
    }

    protected XMLLoad createXMLLoad() {
        return new XMILoadImpl(this.createXMLHelper()){

            protected DefaultHandler makeDefaultHandler() {
                return new SAXXMIHandler(this.resource, this.helper, this.options){

                    protected String getLocation() {
                        String normalizedURI;
                        String result = super.getLocation();
                        URI uri = BaseResourceImpl.this.getURI();
                        if (uri != null && !result.equals(normalizedURI = this.getURIConverter().normalize(uri).toString())) {
                            result = String.valueOf(result) + " -> " + normalizedURI;
                        }
                        return result;
                    }

                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                        URI uri = BaseResourceImpl.this.getURI();
                        String message = BasePlugin.INSTANCE.getStringX("_UI_BadEntity_diagnostic", new Object[]{publicId, systemId, uri});
                        URI normalizedURI = this.getURIConverter().normalize(uri);
                        if (!normalizedURI.equals(uri)) {
                            message = String.valueOf(message) + ", normalizedURI=" + normalizedURI;
                        }
                        throw new SAXException(message);
                    }

                    protected void setFeatureValue(EObject object, EStructuralFeature feature, Object value) {
                        String stringValue;
                        String[] lines;
                        if (value != null && feature.getEType() == BasePackage.Literals.TEXT && (lines = (stringValue = value.toString()).split("\n", Integer.MAX_VALUE)).length > 1) {
                            int end;
                            int start = lines[0].trim().length() == 0 ? 1 : 0;
                            String lastLine = lines[lines.length - 1];
                            int n = end = lastLine.trim().length() == 0 ? lines.length - 1 : lines.length;
                            if (start < end) {
                                int minIndent = Integer.MAX_VALUE;
                                int i = start == 0 ? 1 : start;
                                while (i < end) {
                                    int indent;
                                    String line = lines[i];
                                    String trimmedLine = line.trim();
                                    if (trimmedLine.length() > 0 && minIndent > (indent = line.indexOf(trimmedLine))) {
                                        minIndent = indent;
                                    }
                                    ++i;
                                }
                                if (minIndent == Integer.MAX_VALUE) {
                                    minIndent = lastLine.length();
                                    int depth = this.elements.size();
                                    minIndent += minIndent / depth;
                                }
                                StringBuilder s = new StringBuilder();
                                if (start == 0) {
                                    s.append(lines[0]);
                                    if (++start < end) {
                                        s.append("\n");
                                    }
                                }
                                int i2 = start;
                                while (i2 < end) {
                                    String line = lines[i2];
                                    int length = line.length();
                                    if (length > minIndent) {
                                        s.append(line, minIndent, length);
                                    }
                                    if (++i2 >= end) continue;
                                    s.append("\n");
                                }
                                value = s.toString();
                            }
                        }
                        super.setFeatureValue(object, feature, value);
                    }
                };
            }
        };
    }

    protected XMLSave createXMLSave() {
        return new XMISaveImpl(this.createXMLHelper()){

            protected String getDatatypeValue(Object value, EStructuralFeature f, boolean isAttribute) {
                if (value != null && !isAttribute && f.getEType() == BasePackage.Literals.TEXT) {
                    String stringValue = value.toString();
                    String[] lines = stringValue.split("\r?\n", Integer.MAX_VALUE);
                    if (lines.length == 1) {
                        return this.escape == null ? stringValue : this.escape.convertText(stringValue);
                    }
                    String elementIdent = this.getElementIndent(1);
                    String contentIndent = this.getElementIndent(2);
                    StringBuilder s = new StringBuilder("\n");
                    int i = 0;
                    while (i < lines.length) {
                        String line = lines[i];
                        if (line.length() != 0) {
                            s.append(contentIndent);
                            s.append(line);
                        }
                        s.append("\n");
                        ++i;
                    }
                    s.append(elementIdent);
                    return this.escape == null ? s.toString() : this.escape.convertText(s.toString());
                }
                return super.getDatatypeValue(value, f, isAttribute);
            }

            private String getElementIndent(int extraIndent) {
                try {
                    return GET_ELEMENT_INDENT_METHOD.invoke((Object)this.doc, extraIndent).toString();
                }
                catch (Exception ex) {
                    return "";
                }
            }
        };
    }

    protected XMLHelper createXMLHelper() {
        return new BaseHelperImpl((XMLResource)this);
    }

    private static void encode(StringBuilder result, String value) {
        int length = value.length();
        boolean encode = false;
        int i = 0;
        while (i < length) {
            String escape;
            char character = value.charAt(i);
            if (character < ESCAPE.length && (escape = ESCAPE[character]) != null) {
                if (!encode) {
                    encode = true;
                    result.append(value, 0, i);
                }
                result.append(escape);
            } else if (encode) {
                result.append(character);
            }
            ++i;
        }
        if (!encode) {
            result.append(value);
        }
    }

    public static class BaseHelperImpl
    extends XMIHelperImpl {
        public BaseHelperImpl(XMLResource resource) {
            super(resource);
        }

        public URI getHREF(Resource otherResource, EObject obj) {
            InternalEObject internalEObject = (InternalEObject)obj;
            InternalEObject basisObject = null;
            boolean checkedID = false;
            String id = null;
            InternalEObject container = (InternalEObject)internalEObject.eContainer();
            while (container != null) {
                Resource.Internal eDirectResource = container.eDirectResource();
                if (eDirectResource == this.resource) {
                    return super.getHREF(otherResource, obj);
                }
                if (eDirectResource != null && basisObject == null) {
                    if (!checkedID) {
                        checkedID = true;
                        id = EcoreUtil.getID((EObject)obj);
                    }
                    if (id != null && container instanceof ModelElement) {
                        basisObject = container;
                    }
                }
                internalEObject = container;
                container = (InternalEObject)container.eContainer();
            }
            Resource rootContainerResource = internalEObject.eResource();
            if (rootContainerResource != otherResource && rootContainerResource != null) {
                String fragmentPath = EcoreUtil.getRelativeURIFragmentPath((EObject)internalEObject, (EObject)(basisObject == null ? obj : basisObject));
                URI proxyURI = super.getHREF(rootContainerResource, (EObject)internalEObject);
                StringBuilder fragment = new StringBuilder(proxyURI.fragment());
                fragment.append('/');
                fragment.append(fragmentPath);
                if (basisObject != null) {
                    fragment.append("/'");
                    BaseResourceImpl.encode(fragment, id);
                    fragment.append('\'');
                }
                return proxyURI.appendFragment(fragment.toString());
            }
            return super.getHREF(otherResource, obj);
        }

        public String getIDREF(EObject obj) {
            if (this.resource != null) {
                String id = EcoreUtil.getID((EObject)obj);
                if (id != null) {
                    return id;
                }
                InternalEObject internalEObject = (InternalEObject)obj;
                InternalEObject basisObject = null;
                InternalEObject container = (InternalEObject)internalEObject.eContainer();
                while (container != null) {
                    Resource.Internal eDirectResource = container.eDirectResource();
                    if (eDirectResource == this.resource) break;
                    id = EcoreUtil.getID((EObject)container);
                    if (id != null && container instanceof ModelElement) {
                        basisObject = container;
                        break;
                    }
                    internalEObject = container;
                    container = (InternalEObject)container.eContainer();
                }
                if (basisObject != null) {
                    StringBuilder fragment = new StringBuilder();
                    fragment.append("//'");
                    BaseResourceImpl.encode(fragment, id);
                    fragment.append('\'');
                    String fragmentPath = EcoreUtil.getRelativeURIFragmentPath((EObject)basisObject, (EObject)obj);
                    fragment.append('/');
                    fragment.append(fragmentPath);
                    return fragment.toString();
                }
            }
            return super.getIDREF(obj);
        }

        public URI deresolve(URI uri) {
            return super.deresolve(BaseUtil.resolveBogusURI(uri));
        }
    }
}

