/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.editor;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.ui.LabelDecorator;
import org.eclipse.oomph.ui.PropertiesViewer;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class ProjectTemplate {
    public static final String PRODUCT_GROUP = "org.eclipse.oomph.setup.projectTemplates";
    private final String label;
    private final String description;
    private Resource resource;
    private Container container;

    protected ProjectTemplate(String label) {
        this(label, null);
    }

    protected ProjectTemplate(String label, String description) {
        this.label = label;
        this.description = StringUtil.safe((String)description);
    }

    public abstract Control createControl(Composite var1);

    public abstract boolean isValid();

    protected void init() {
        ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
        this.resource = resourceSet.createResource(URI.createURI((String)"*.setup"));
    }

    public void updatePreview() {
    }

    public LabelDecorator getDecorator() {
        return null;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Resource getResource() {
        if (this.resource == null) {
            this.init();
        }
        return this.resource;
    }

    public final Container getContainer() {
        return this.container;
    }

    public final void init(Container container) {
        this.container = container;
    }

    public final String toString() {
        return this.getLabel();
    }

    public static interface Container {
        public TreeViewer getPreviewer();

        public PropertiesViewer getPropertiesViewer();

        public void validate();

        public String getDefaultLocation();
    }
}

