/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.util;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.compiler.OTNameUtils;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TSuperMessageSend;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstConverter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class TSuperHelper {
    public static char[] getTSuperMarkName(ReferenceBinding superTeam) {
        char[] name = superTeam.sourceName();
        while ((superTeam = superTeam.enclosingType()) != null) {
            name = CharOperation.concat(superTeam.sourceName(), IOTConstants.OT_DELIM_NAME, name);
        }
        return CharOperation.concat(IOTConstants.TSUPER_OT_NAME, name);
    }

    public static void addMarkerInterface(TeamModel teamModel, ReferenceBinding superTeam) {
        TypeDeclaration markerInterface;
        TypeDeclaration teamDeclaration = teamModel.getAst();
        teamModel.markerInterface = markerInterface = TSuperHelper.createMarkerInterface(teamDeclaration, superTeam);
        markerInterface.getRoleModel().setState(7);
    }

    private static TypeDeclaration createMarkerInterface(TypeDeclaration teamTypeDeclaration, ReferenceBinding superteam) {
        char[] superMarkName = TSuperHelper.getTSuperMarkName(superteam);
        if (teamTypeDeclaration.memberTypes != null) {
            int i = 0;
            while (i < teamTypeDeclaration.memberTypes.length) {
                if (CharOperation.equals(teamTypeDeclaration.memberTypes[i].name, superMarkName)) {
                    return teamTypeDeclaration.memberTypes[i];
                }
                ++i;
            }
        }
        return AstConverter.createNestedType(superMarkName, 16781828, false, false, teamTypeDeclaration, null);
    }

    public static TypeBinding getMarkerInterface(Scope scope, ReferenceBinding superteam) {
        return scope.getType(TSuperHelper.getTSuperMarkName(superteam));
    }

    private static TypeReference markerTypeRef(ReferenceBinding superTeam, AstGenerator gen) {
        return gen.singleTypeReference(TSuperHelper.getTSuperMarkName(superTeam));
    }

    public static boolean isMarkerInterface(TypeBinding type) {
        if (type.isWildcard()) {
            return false;
        }
        if (type instanceof ReferenceBinding && type.isValidBinding()) {
            return OTNameUtils.isTSuperMarkerInterface(((ReferenceBinding)type).internalName());
        }
        return false;
    }

    public static boolean isMarkerArg(Expression expression) {
        if (!(expression instanceof CastExpression)) {
            return false;
        }
        CastExpression cast = (CastExpression)expression;
        if (!(cast.type instanceof SingleTypeReference)) {
            return false;
        }
        return OTNameUtils.isTSuperMarkerInterface(((SingleTypeReference)cast.type).token);
    }

    public static boolean isTSuper(MethodBinding method) {
        TypeBinding lastParam;
        if (method == null) {
            return false;
        }
        TypeBinding[] params = method.parameters;
        if (params.length > 0 && (lastParam = params[params.length - 1]) != null) {
            return TSuperHelper.isMarkerInterface(lastParam);
        }
        return false;
    }

    public static Expression[] addMarkerArgument(ReferenceBinding qualifyingType, Statement tsuperCall, Expression[] arguments, BlockScope scope) {
        Expression[] newArgs;
        ReferenceBinding superTeam;
        if (scope == null) {
            return null;
        }
        int sStart = tsuperCall.sourceStart;
        int sEnd = tsuperCall.sourceEnd;
        SourceTypeBinding roleType = scope.enclosingSourceType();
        if (!roleType.isSourceRole()) {
            scope.problemReporter().tsuperOutsideRole((AbstractMethodDeclaration)scope.methodScope().referenceContext, tsuperCall, roleType);
            return arguments;
        }
        ReferenceBinding[] tsuperRoleBindings = roleType.roleModel.getTSuperRoleBindings();
        if (tsuperRoleBindings.length == 0) {
            scope.problemReporter().tsuperCallWithoutTsuperRole(roleType, tsuperCall);
            return null;
        }
        if (qualifyingType == null) {
            superTeam = tsuperRoleBindings[0].enclosingType();
        } else {
            TSuperMessageSend tsuperMsg = (TSuperMessageSend)tsuperCall;
            ReferenceBinding superRole = (ReferenceBinding)tsuperMsg.tsuperReference.resolveType(scope);
            superTeam = superRole.enclosingType();
            if (superTeam == null) {
                return null;
            }
        }
        AstGenerator gen = new AstGenerator(sStart, sEnd);
        CastExpression cast = TSuperHelper.createMarkerArgExpr(superTeam, gen);
        if (arguments == null) {
            newArgs = new Expression[]{cast};
        } else {
            newArgs = new Expression[arguments.length + 1];
            System.arraycopy(arguments, 0, newArgs, 0, arguments.length);
            newArgs[newArgs.length - 1] = cast;
        }
        return newArgs;
    }

    public static CastExpression createMarkerArgExpr(ReferenceBinding superTeam, AstGenerator gen) {
        return gen.castExpression(gen.nullLiteral(), TSuperHelper.markerTypeRef(superTeam, gen), 2);
    }

    public static void addMarkerArg(AbstractMethodDeclaration methodDeclaration, ReferenceBinding origin) {
        AstGenerator gen = new AstGenerator(methodDeclaration.sourceStart, methodDeclaration.sourceEnd);
        SingleTypeReference marker = gen.singleTypeReference(TSuperHelper.getTSuperMarkName(origin));
        int argPos = 0;
        if (methodDeclaration.arguments == null) {
            methodDeclaration.arguments = new Argument[1];
        } else {
            int argumentlength = methodDeclaration.arguments.length;
            if (argumentlength == 0) {
                methodDeclaration.arguments = new Argument[1];
            } else {
                Argument[] arguments = new Argument[argumentlength + 1];
                System.arraycopy(methodDeclaration.arguments, 0, arguments, 0, argumentlength);
                methodDeclaration.arguments = arguments;
                argPos = argumentlength;
            }
        }
        methodDeclaration.arguments[argPos] = new Argument(IOTConstants.MARKER_ARG_NAME, 0L, marker, 0);
        methodDeclaration.isTSuper = true;
        if (methodDeclaration.binding != null) {
            TypeBinding[] oldParams = methodDeclaration.binding.parameters;
            TypeBinding[] newParams = new TypeBinding[oldParams.length + 1];
            System.arraycopy(oldParams, 0, newParams, 0, oldParams.length);
            newParams[oldParams.length] = marker.resolveType(methodDeclaration.scope);
            methodDeclaration.binding.parameters = newParams;
            methodDeclaration.binding.resetSignature();
        }
    }

    public static boolean isTSubOf(ReferenceBinding class1, ReferenceBinding other) {
        if (!class1.isRole() || !other.isRole()) {
            return false;
        }
        if (StateHelper.hasState(other, 6) && StateHelper.hasState(class1, 6) && StateHelper.hasState(class1.enclosingType(), 6)) {
            return class1.roleModel.hasTSuperRole(other);
        }
        if (!CharOperation.equals(class1.sourceName(), other.sourceName())) {
            return false;
        }
        return class1.enclosingType().superclass().erasure() == other.enclosingType().erasure() || TSuperHelper.isTSubOf(class1.enclosingType(), other.enclosingType());
    }

    public static boolean isEquivalentField(ITeamAnchor currentAnchor, ITeamAnchor tsuperAnchor) {
        if (currentAnchor == tsuperAnchor) {
            return true;
        }
        if (currentAnchor == null || tsuperAnchor == null) {
            return false;
        }
        if (!(currentAnchor instanceof FieldBinding)) {
            return false;
        }
        if (!(tsuperAnchor instanceof FieldBinding)) {
            return false;
        }
        FieldBinding currentField = (FieldBinding)currentAnchor;
        FieldBinding tsuperField = (FieldBinding)tsuperAnchor;
        if (!CharOperation.equals(currentField.name, tsuperField.name)) {
            return false;
        }
        if (currentField.declaringClass.isCompatibleWith(tsuperField.declaringClass)) {
            return (currentField.tagBits & 0x4000000000000000L) != 0L;
        }
        return TSuperHelper.isTSubOf(currentField.declaringClass, tsuperField.declaringClass);
    }
}

