/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByComparator;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByDataLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByObject;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;

public class SortModelGroupByComparator<T>
extends GroupByComparator<T> {
    private boolean sortBySummaryRows = true;

    public SortModelGroupByComparator(GroupByModel groupByModel, IColumnAccessor<T> columnAccessor, GroupByDataLayer<T> dataLayer) {
        super(groupByModel, columnAccessor, dataLayer);
    }

    @Override
    public int compare(Object o1, Object o2) {
        int result = 0;
        if (o1 instanceof GroupByObject && o2 instanceof GroupByObject) {
            result = this.compareGroupByObjects((GroupByObject)o1, (GroupByObject)o2);
        } else if (!(o1 instanceof GroupByObject) && !(o2 instanceof GroupByObject)) {
            result = 0;
        } else {
            throw new IllegalStateException("Comparison of GroupByObjects with non-GroupByObjects is not supported: " + String.valueOf(o1) + " vs. " + String.valueOf(o2));
        }
        return result;
    }

    protected int compareGroupByObjects(GroupByObject g1, GroupByObject g2) {
        List sortColumns = this.sortModel.getSortedColumnIndexes();
        int result = 0;
        Iterator iterator = sortColumns.iterator();
        while (iterator.hasNext()) {
            int sortColumnIndex = (Integer)iterator.next();
            result = this.compareSummaryRows(g1, g2, sortColumnIndex);
            if (result == 0) {
                Object o1 = g1.getDescriptor().get(sortColumnIndex);
                Object o2 = g2.getDescriptor().get(sortColumnIndex);
                result = this.getComparator(sortColumnIndex).compare(o1, o2);
            }
            if (result == 0) continue;
            if (!SortDirectionEnum.DESC.equals((Object)this.sortModel.getSortDirection(sortColumnIndex))) break;
            result *= -1;
            break;
        }
        if (result == 0) {
            result = this.defaultCompareGroupByColumns(g1, g2);
        }
        return result;
    }

    protected int compareSummaryRows(GroupByObject g1, GroupByObject g2, int columnIndex) {
        if (!this.isSortBySummaryRows()) {
            return 0;
        }
        if (this.groupByModel.getGroupByColumnIndexes().contains(columnIndex)) {
            return 0;
        }
        Boolean summaryColumn = this.isSummaryColumn(g1, columnIndex);
        if (summaryColumn == null) {
            summaryColumn = this.isSummaryColumn(g2, columnIndex);
        }
        if (summaryColumn != null && summaryColumn.booleanValue()) {
            Object sumValue1 = this.getSummaryValueFromCache(g1, columnIndex);
            Object sumValue2 = this.getSummaryValueFromCache(g2, columnIndex);
            return this.getComparator(columnIndex).compare(sumValue1, sumValue2);
        }
        return 0;
    }

    protected int defaultCompareGroupByColumns(GroupByObject g1, GroupByObject g2) {
        int result = 0;
        int groupByIndex = 0;
        for (Map.Entry<Integer, Object> entry : g1.getDescriptor().entrySet()) {
            groupByIndex = entry.getKey();
        }
        Comparator comparator = this.getComparator(groupByIndex);
        result = comparator.compare(g1.getValue(), g2.getValue());
        return result;
    }

    public boolean isSortBySummaryRows() {
        return this.sortBySummaryRows;
    }

    public void setSortBySummaryRows(boolean sortBySummaryRows) {
        this.sortBySummaryRows = sortBySummaryRows;
    }
}

