/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style.editor.command;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnVisualUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.persistence.StylePersistor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.editor.ColumnStyleEditorDialog;
import org.eclipse.nebula.widgets.nattable.style.editor.command.DisplayColumnStyleEditorCommand;
import org.eclipse.swt.widgets.Display;

public class DisplayColumnStyleEditorCommandHandler
extends AbstractLayerCommandHandler<DisplayColumnStyleEditorCommand>
implements IPersistable {
    protected static final String PERSISTENCE_PREFIX = "userDefinedColumnStyle";
    protected static final String USER_EDITED_STYLE_LABEL = "USER_EDITED_STYLE";
    protected static final String USER_EDITED_COLUMN_STYLE_LABEL_PREFIX = "USER_EDITED_STYLE_FOR_INDEX_";
    protected final SelectionLayer selectionLayer;
    protected ColumnOverrideLabelAccumulator columnLabelAccumulator;
    private final IConfigRegistry configRegistry;
    protected ColumnStyleEditorDialog dialog;
    protected final Map<String, Style> stylesToPersist = new HashMap<String, Style>();

    public DisplayColumnStyleEditorCommandHandler(SelectionLayer selectionLayer, ColumnOverrideLabelAccumulator labelAccumulator, IConfigRegistry configRegistry) {
        this.selectionLayer = selectionLayer;
        this.columnLabelAccumulator = labelAccumulator;
        this.configRegistry = configRegistry;
    }

    @Override
    public boolean doCommand(DisplayColumnStyleEditorCommand command) {
        int columnIndexOfClick = command.getNattableLayer().getColumnIndexByPosition(command.columnPosition);
        LabelStack configLabels = new LabelStack(new String[0]);
        this.columnLabelAccumulator.accumulateConfigLabels(configLabels, columnIndexOfClick, 0);
        configLabels.addLabel(this.getConfigLabel(columnIndexOfClick));
        Style clickedCellStyle = (Style)this.configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, DisplayMode.NORMAL, (List<String>)configLabels);
        this.dialog = new ColumnStyleEditorDialog(Display.getCurrent().getActiveShell(), clickedCellStyle);
        this.dialog.open();
        if (!this.dialog.isCancelPressed()) {
            int[] selectedColumns = this.getSelectedColumnIndeces();
            if (selectedColumns.length > 0) {
                this.applySelectedStyleToColumns(command, selectedColumns);
                this.selectionLayer.fireLayerEvent(new ColumnVisualUpdateEvent((IUniqueIndexLayer)this.selectionLayer, this.selectionLayer.getSelectedColumnPositions()));
            } else {
                this.applySelectedStyle();
                this.selectionLayer.fireLayerEvent(new VisualRefreshEvent(this.selectionLayer));
            }
        }
        return true;
    }

    private int[] getSelectedColumnIndeces() {
        int[] selectedColumnPositions = this.selectionLayer.getFullySelectedColumnPositions();
        int[] selectedColumnIndeces = new int[selectedColumnPositions.length];
        int i = 0;
        while (i < selectedColumnPositions.length) {
            selectedColumnIndeces[i] = this.selectionLayer.getColumnIndexByPosition(selectedColumnPositions[i]);
            ++i;
        }
        return selectedColumnIndeces;
    }

    @Override
    public Class<DisplayColumnStyleEditorCommand> getCommandClass() {
        return DisplayColumnStyleEditorCommand.class;
    }

    protected void applySelectedStyleToColumns(DisplayColumnStyleEditorCommand command, int[] columnIndeces) {
        Style newColumnCellStyle = this.dialog.getNewColumnCellStyle();
        int i = 0;
        while (i < columnIndeces.length) {
            int columnIndex = columnIndeces[i];
            String configLabel = this.getConfigLabel(columnIndex);
            this.applySelectedStyle(newColumnCellStyle, configLabel);
            if (newColumnCellStyle != null) {
                this.columnLabelAccumulator.registerColumnOverridesOnTop(columnIndex, configLabel);
            } else {
                this.columnLabelAccumulator.unregisterOverrides(columnIndex, configLabel);
            }
            ++i;
        }
    }

    protected void applySelectedStyle() {
        Style newColumnCellStyle = this.dialog.getNewColumnCellStyle();
        this.applySelectedStyle(newColumnCellStyle, USER_EDITED_STYLE_LABEL);
        if (newColumnCellStyle != null) {
            this.columnLabelAccumulator.registerOverridesOnTop(USER_EDITED_STYLE_LABEL);
        } else {
            this.columnLabelAccumulator.unregisterOverrides(USER_EDITED_STYLE_LABEL);
        }
    }

    protected void applySelectedStyle(Style newColumnCellStyle, String configLabel) {
        if (newColumnCellStyle == null) {
            this.stylesToPersist.remove(configLabel);
        } else {
            newColumnCellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.dialog.getNewColumnBorderStyle());
            this.stylesToPersist.put(configLabel, newColumnCellStyle);
        }
        this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, newColumnCellStyle, DisplayMode.NORMAL, configLabel);
    }

    protected String getConfigLabel(int columnIndex) {
        return USER_EDITED_COLUMN_STYLE_LABEL_PREFIX + columnIndex;
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        prefix = String.valueOf(prefix) + "." + PERSISTENCE_PREFIX;
        Set<Object> keySet = properties.keySet();
        for (Object key : keySet) {
            String keyString = (String)key;
            if (!keyString.contains(PERSISTENCE_PREFIX)) continue;
            if (keyString.contains(USER_EDITED_COLUMN_STYLE_LABEL_PREFIX)) {
                int colIndex = this.parseColumnIndexFromKey(keyString);
                String configLabel = this.getConfigLabel(colIndex);
                if (this.stylesToPersist.keySet().contains(configLabel)) continue;
                Style savedStyle = StylePersistor.loadStyle(String.valueOf(prefix) + "." + configLabel, properties);
                this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, savedStyle, DisplayMode.NORMAL, configLabel);
                this.stylesToPersist.put(configLabel, savedStyle);
                this.columnLabelAccumulator.registerColumnOverrides(colIndex, configLabel);
                continue;
            }
            if (this.stylesToPersist.keySet().contains(USER_EDITED_STYLE_LABEL)) continue;
            Style savedStyle = StylePersistor.loadStyle(String.valueOf(prefix) + "." + USER_EDITED_STYLE_LABEL, properties);
            this.configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, savedStyle, DisplayMode.NORMAL, USER_EDITED_STYLE_LABEL);
            this.stylesToPersist.put(USER_EDITED_STYLE_LABEL, savedStyle);
            this.columnLabelAccumulator.registerOverrides((Serializable)((Object)USER_EDITED_STYLE_LABEL), USER_EDITED_STYLE_LABEL);
        }
    }

    protected int parseColumnIndexFromKey(String keyString) {
        int colLabelStartIndex = keyString.indexOf(USER_EDITED_COLUMN_STYLE_LABEL_PREFIX);
        String columnConfigLabel = keyString.substring(colLabelStartIndex, keyString.indexOf(46, colLabelStartIndex));
        int lastUnderscoreInLabel = columnConfigLabel.lastIndexOf(95, colLabelStartIndex);
        return Integer.parseInt(columnConfigLabel.substring(lastUnderscoreInLabel + 1));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        prefix = String.valueOf(prefix) + "." + PERSISTENCE_PREFIX;
        for (Map.Entry<String, Style> labelToStyle : this.stylesToPersist.entrySet()) {
            Style style = labelToStyle.getValue();
            String label = labelToStyle.getKey();
            StylePersistor.saveStyle(String.valueOf(prefix) + "." + label, properties, style);
        }
    }
}

