/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.combobox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.event.DataUpdateEvent;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboUpdateEvent;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.IFilterRowComboUpdateListener;
import org.eclipse.nebula.widgets.nattable.filterrow.event.FilterAppliedEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class FilterRowComboBoxDataProvider<T>
implements IComboBoxDataProvider,
ILayerListener,
ILayerCommandHandler<UpdateDataCommand> {
    private Collection<T> baseCollection;
    private IColumnAccessor<T> columnAccessor;
    private final Map<Integer, List<?>> valueCache = new HashMap();
    private Map<Integer, List<?>> allValueCache = this.valueCache;
    private List<IFilterRowComboUpdateListener> cacheUpdateListener = new ArrayList<IFilterRowComboUpdateListener>();
    protected final boolean lazyLoading;
    protected boolean cachingEnabled = true;
    private boolean updateEventsEnabled = true;
    private final ReadWriteLock valueCacheLock;
    private ReadWriteLock allValueCacheLock = this.valueCacheLock = new ReentrantReadWriteLock();
    private boolean distinctNullAndEmpty = false;
    private Collection<T> filterCollection;
    private ILayer columnHeaderLayer;
    private ILayer bodyLayer;
    private Collection<T> previousAppliedFilterCollection;
    private int lastAppliedFilterColumn = -1;

    public FilterRowComboBoxDataProvider(ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> columnAccessor) {
        this(bodyLayer, baseCollection, columnAccessor, true);
    }

    public FilterRowComboBoxDataProvider(ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> columnAccessor, boolean lazy) {
        this.baseCollection = baseCollection;
        this.columnAccessor = columnAccessor;
        this.lazyLoading = lazy;
        if (!this.lazyLoading) {
            this.valueCacheLock.writeLock().lock();
            try {
                this.buildValueCache();
            }
            finally {
                this.valueCacheLock.writeLock().unlock();
            }
        }
        this.bodyLayer = bodyLayer;
        this.bodyLayer.addLayerListener(this);
    }

    @Override
    public List<?> getValues(int columnIndex, int rowIndex) {
        if (this.previousAppliedFilterCollection != null && columnIndex == this.lastAppliedFilterColumn) {
            return this.getValues(this.previousAppliedFilterCollection, columnIndex, this.valueCache, this.valueCacheLock);
        }
        if (this.getFilterCollection() != null && columnIndex != this.lastAppliedFilterColumn) {
            return this.getValues(this.getFilterCollection(), columnIndex, this.valueCache, this.valueCacheLock);
        }
        return this.getAllValues(columnIndex);
    }

    public List<?> getAllValues(int columnIndex) {
        return this.getValues(this.baseCollection, columnIndex, this.allValueCache, this.allValueCacheLock);
    }

    protected List<?> getValues(Collection<T> collection, int columnIndex, Map<Integer, List<?>> cache, ReadWriteLock cacheLock) {
        if (this.cachingEnabled) {
            cacheLock.readLock().lock();
            List<?> result = null;
            try {
                result = cache.get(columnIndex);
            }
            finally {
                cacheLock.readLock().unlock();
            }
            if (result == null) {
                cacheLock.writeLock().lock();
                try {
                    result = this.collectValues(collection, columnIndex);
                    cache.put(columnIndex, result);
                }
                finally {
                    cacheLock.writeLock().unlock();
                }
                if (this.isUpdateEventsEnabled() && (this.valueCache == this.allValueCache || cache != this.allValueCache)) {
                    this.fireCacheUpdateEvent(this.buildUpdateEvent(columnIndex, null, result));
                }
            }
            if (cache != this.allValueCache && !this.allValueCache.containsKey(columnIndex)) {
                this.allValueCache.put(columnIndex, result);
            }
            return result;
        }
        return this.collectValues(collection, columnIndex);
    }

    protected void buildValueCache() {
        this.buildValueCache(this.allValueCache);
    }

    private void buildValueCache(Map<Integer, List<?>> cache) {
        int i = 0;
        while (i < this.columnAccessor.getColumnCount()) {
            cache.put(i, this.collectValues(i));
            ++i;
        }
    }

    public Collection<Integer> getCachedColumnIndexes() {
        this.valueCacheLock.readLock().lock();
        try {
            Set<Integer> set = this.valueCache.keySet();
            return set;
        }
        finally {
            this.valueCacheLock.readLock().unlock();
        }
    }

    protected List<?> collectValues(int columnIndex) {
        return this.collectValues(this.baseCollection, columnIndex);
    }

    protected List<?> collectValuesForColumn(int columnIndex) {
        if (this.previousAppliedFilterCollection != null && columnIndex == this.lastAppliedFilterColumn) {
            return this.collectValues(this.previousAppliedFilterCollection, columnIndex);
        }
        if (this.getFilterCollection() != null && columnIndex != this.lastAppliedFilterColumn) {
            return this.collectValues(this.getFilterCollection(), columnIndex);
        }
        return this.collectValues(columnIndex);
    }

    protected List<?> collectValues(Collection<T> collection, int columnIndex) {
        List result = ((Stream)((Stream)collection.stream().unordered()).parallel()).map(x -> this.columnAccessor.getDataValue(x, columnIndex)).map(x -> {
            if (this.isDistinctNullAndEmpty()) {
                return x instanceof String && ((String)x).isEmpty() ? null : x;
            }
            return x;
        }).distinct().collect(Collectors.toList());
        Object firstNonNull = result.stream().filter(Objects::nonNull).findFirst().orElse(null);
        if (firstNonNull instanceof Comparable) {
            result.sort(Comparator.nullsFirst(Comparator.naturalOrder()));
        } else {
            int index = result.indexOf(null);
            if (index >= 0) {
                result.remove(index);
                result.add(0, null);
            }
        }
        return result;
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (this.cachingEnabled && this.isEventFromBodyLayer(event)) {
            if (event instanceof DataUpdateEvent) {
                this.updateCache(((DataUpdateEvent)event).getColumnPosition());
            } else if (event instanceof IStructuralChangeEvent && ((IStructuralChangeEvent)event).isVerticalStructureChanged()) {
                this.clearCache(false);
            }
        }
        if (event instanceof FilterAppliedEvent && this.filterCollection != null) {
            FilterAppliedEvent filterEvent = (FilterAppliedEvent)event;
            boolean filterChanged = this.isFilterChanged(filterEvent.getColumnIndex(), filterEvent.getOldValue(), filterEvent.getNewValue());
            if (filterEvent.isCleared() && filterEvent.getColumnIndex() != this.lastAppliedFilterColumn || filterEvent.isFilterComboEditor() && (filterEvent.isCleared() || filterEvent.getColumnIndex() == -1) || filterEvent.getColumnIndex() == -1 && filterEvent.getOldValue() == null && filterEvent.getNewValue() == null) {
                this.setLastFilter(-1, null);
            }
            if (this.cachingEnabled && filterChanged) {
                this.valueCacheLock.writeLock().lock();
                try {
                    int column = filterEvent.getColumnIndex();
                    for (Map.Entry<Integer, List<?>> entry : this.valueCache.entrySet()) {
                        if (entry.getKey() == column && !filterEvent.isCleared()) continue;
                        this.valueCache.put(entry.getKey(), this.collectValues(this.getFilterCollection(), entry.getKey()));
                    }
                }
                finally {
                    this.valueCacheLock.writeLock().unlock();
                }
            }
        }
    }

    protected void updateCache(int columnIndex) {
        this.updateCache(columnIndex, this.valueCache, this.valueCacheLock);
        if (this.valueCache != this.allValueCache) {
            boolean wasEnabled = this.updateEventsEnabled;
            this.updateEventsEnabled = false;
            this.updateCache(columnIndex, this.allValueCache, this.allValueCacheLock);
            this.updateEventsEnabled = wasEnabled;
        }
    }

    protected void updateCache(int columnIndex, Map<Integer, List<?>> cache, ReadWriteLock cacheLock) {
        cacheLock.writeLock().lock();
        try {
            List<?> cacheBefore = cache.get(columnIndex);
            if (!this.lazyLoading || cacheBefore != null) {
                cache.put(columnIndex, cache == this.allValueCache ? this.collectValues(columnIndex) : this.collectValuesForColumn(columnIndex));
            }
            if (this.isUpdateEventsEnabled()) {
                this.fireCacheUpdateEvent(this.buildUpdateEvent(columnIndex, cacheBefore, cache.get(columnIndex)));
            }
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    protected void clearCache(boolean updateEventsFromAll) {
        boolean fireUpdateEvents = this.isUpdateEventsEnabled();
        if (fireUpdateEvents) {
            boolean bl = fireUpdateEvents = this.valueCache == this.allValueCache || this.valueCache != this.allValueCache && !updateEventsFromAll;
        }
        if (this.valueCache != this.allValueCache) {
            this.clearCache(this.allValueCache, this.allValueCacheLock, !fireUpdateEvents);
        }
        this.clearCache(this.valueCache, this.valueCacheLock, fireUpdateEvents);
    }

    protected void clearCache(Map<Integer, List<?>> cache, ReadWriteLock cacheLock, boolean fireUpdateEvents) {
        cacheLock.writeLock().lock();
        try {
            HashMap cacheBefore = new HashMap(cache);
            cache.clear();
            if (!this.lazyLoading) {
                this.buildValueCache();
            } else {
                for (Map.Entry entry : cacheBefore.entrySet()) {
                    cache.put((Integer)entry.getKey(), cache == this.allValueCache ? this.collectValues((Integer)entry.getKey()) : this.collectValuesForColumn((Integer)entry.getKey()));
                }
            }
            if (fireUpdateEvents) {
                FilterRowComboUpdateEvent updateEvent = null;
                for (Map.Entry entry : cacheBefore.entrySet()) {
                    updateEvent = this.buildUpdateEvent(updateEvent, (Integer)entry.getKey(), (List)entry.getValue(), cache.get(entry.getKey()));
                }
                this.fireCacheUpdateEvent(updateEvent);
            }
        }
        finally {
            cacheLock.writeLock().unlock();
        }
    }

    protected boolean isEventFromBodyLayer(ILayerEvent event) {
        return event instanceof IVisualChangeEvent && ((IVisualChangeEvent)event).getLayer() == this.bodyLayer;
    }

    protected boolean isFilterChanged(int columnIndex, Object oldValue, Object newValue) {
        if (columnIndex == -1 && oldValue == null && newValue == null) {
            return true;
        }
        if ("SELECT_ALL".equals(oldValue) && newValue instanceof Collection) {
            return !ObjectUtils.collectionsEqual((Collection)newValue, this.getValues(columnIndex, 0));
        }
        if ("SELECT_ALL".equals(newValue) && oldValue instanceof Collection) {
            return !ObjectUtils.collectionsEqual((Collection)oldValue, this.getValues(columnIndex, 0));
        }
        if (oldValue instanceof Collection && newValue instanceof Collection) {
            Collection oldFilter = (Collection)oldValue;
            Collection newFilter = (Collection)newValue;
            return !ObjectUtils.collectionsEqual(oldFilter, newFilter);
        }
        return !(oldValue == null && newValue == null || oldValue != null && newValue != null && oldValue.equals(newValue));
    }

    protected FilterRowComboUpdateEvent buildUpdateEvent(int columnIndex, List<?> cacheBefore, List<?> cacheAfter) {
        return this.buildUpdateEvent(null, columnIndex, cacheBefore, cacheAfter);
    }

    protected FilterRowComboUpdateEvent buildUpdateEvent(FilterRowComboUpdateEvent event, int columnIndex, List<?> cacheBefore, List<?> cacheAfter) {
        HashSet addedValues = new HashSet();
        HashSet removedValues = new HashSet();
        if (cacheAfter != null && cacheBefore != null) {
            for (Object after : cacheAfter) {
                if (cacheBefore.contains(after)) continue;
                addedValues.add(after);
            }
            for (Object before : cacheBefore) {
                if (cacheAfter.contains(before)) continue;
                removedValues.add(before);
            }
        } else if ((cacheBefore == null || cacheBefore.isEmpty()) && cacheAfter != null) {
            addedValues.addAll(cacheAfter);
        } else if (cacheBefore != null && (cacheAfter == null || cacheAfter.isEmpty())) {
            removedValues.addAll(cacheBefore);
        }
        if (!addedValues.isEmpty() || !removedValues.isEmpty()) {
            if (event == null) {
                return new FilterRowComboUpdateEvent(columnIndex, addedValues, removedValues);
            }
            event.addUpdate(columnIndex, addedValues, removedValues);
        }
        return event;
    }

    protected void fireCacheUpdateEvent(FilterRowComboUpdateEvent event) {
        if (event != null) {
            for (IFilterRowComboUpdateListener listener : this.cacheUpdateListener) {
                listener.handleEvent(event);
            }
        }
    }

    public void addCacheUpdateListener(IFilterRowComboUpdateListener listener) {
        this.cacheUpdateListener.add(listener);
    }

    public void removeCacheUpdateListener(IFilterRowComboUpdateListener listener) {
        this.cacheUpdateListener.remove(listener);
    }

    protected Map<Integer, List<?>> getValueCache() {
        return this.valueCache;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public void dispose() {
    }

    public boolean isUpdateEventsEnabled() {
        return this.updateEventsEnabled;
    }

    public void enableUpdateEvents() {
        this.updateEventsEnabled = true;
    }

    public void disableUpdateEvents() {
        this.updateEventsEnabled = false;
    }

    public ReadWriteLock getValueCacheLock() {
        return this.valueCacheLock;
    }

    public boolean isDistinctNullAndEmpty() {
        return this.distinctNullAndEmpty;
    }

    public void setDistinctNullAndEmpty(boolean distinctNullAndEmpty) {
        this.distinctNullAndEmpty = distinctNullAndEmpty;
    }

    public Collection<T> getFilterCollection() {
        return this.filterCollection;
    }

    public void setFilterCollection(Collection<T> filterCollection, ILayer columnHeaderLayer) {
        if (filterCollection != null && columnHeaderLayer != null) {
            this.filterCollection = filterCollection;
            this.columnHeaderLayer = columnHeaderLayer;
            this.allValueCache = new HashMap();
            this.allValueCacheLock = new ReentrantReadWriteLock();
            this.columnHeaderLayer.addLayerListener(this);
            this.columnHeaderLayer.registerCommandHandler(this);
            boolean wasEnabled = this.updateEventsEnabled;
            this.updateEventsEnabled = false;
            this.clearCache(true);
            this.updateEventsEnabled = wasEnabled;
        } else if (filterCollection == null && columnHeaderLayer == null) {
            if (this.columnHeaderLayer != null) {
                this.columnHeaderLayer.removeLayerListener(this);
                this.columnHeaderLayer.unregisterCommandHandler(this.getCommandClass());
            }
            this.filterCollection = null;
            this.columnHeaderLayer = null;
            this.allValueCache = this.valueCache;
            this.allValueCacheLock = this.valueCacheLock;
            this.setLastFilter(-1, null);
            boolean wasEnabled = this.updateEventsEnabled;
            this.updateEventsEnabled = false;
            this.clearCache(true);
            this.updateEventsEnabled = wasEnabled;
        } else {
            throw new IllegalArgumentException("not supported to have only one null value");
        }
    }

    protected void setLastFilter(int columnIndex, Collection<T> collection) {
        this.lastAppliedFilterColumn = columnIndex;
        this.previousAppliedFilterCollection = collection;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, UpdateDataCommand command) {
        if (this.columnHeaderLayer != null && command.convertToTargetLayer(targetLayer)) {
            Object newValue = command.getNewValue();
            Collection filterValue = newValue instanceof Collection ? (Collection)newValue : null;
            int columnIndex = this.columnHeaderLayer.getColumnIndexByPosition(command.getColumnPosition());
            if (filterValue != null && ObjectUtils.collectionsEqual(filterValue, this.getValues(columnIndex, 0))) {
                Object dataValue = this.columnHeaderLayer.getDataValueByPosition(command.getColumnPosition(), this.columnHeaderLayer.getRowCount() - 1);
                if ("SELECT_ALL".equals(dataValue) || dataValue instanceof Collection && (ObjectUtils.collectionsEqual(filterValue, (Collection)dataValue) || ((Collection)dataValue).containsAll(filterValue))) {
                    return true;
                }
            } else if (this.lastAppliedFilterColumn != columnIndex) {
                this.setLastFilter(columnIndex, new ArrayList<T>(this.previousAppliedFilterCollection == null ? this.baseCollection : this.filterCollection));
            }
        }
        return false;
    }

    @Override
    public Class<UpdateDataCommand> getCommandClass() {
        return UpdateDataCommand.class;
    }
}

