/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.Matchers;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import ca.odell.glazedlists.matchers.ThresholdMatcherEditor;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.FilterRowUtils;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.ParseResult;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGlazedListsFilterStrategy<T>
implements IFilterStrategy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultGlazedListsFilterStrategy.class);
    protected final IColumnAccessor<T> columnAccessor;
    protected final IConfigRegistry configRegistry;
    private final CompositeMatcherEditor<T> matcherEditor;
    protected FilterList<T> filterList;
    protected ReadWriteLock filterLock;
    private MatcherEditor<T> matchAll = GlazedLists.fixedMatcherEditor((Matcher)Matchers.trueMatcher());

    public DefaultGlazedListsFilterStrategy(FilterList<T> filterList, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        this(filterList, new CompositeMatcherEditor(), columnAccessor, configRegistry);
        this.matcherEditor.setMode(42);
    }

    public DefaultGlazedListsFilterStrategy(FilterList<T> filterList, CompositeMatcherEditor<T> matcherEditor, IColumnAccessor<T> columnAccessor, IConfigRegistry configRegistry) {
        this.columnAccessor = columnAccessor;
        this.configRegistry = configRegistry;
        this.matcherEditor = matcherEditor;
        this.filterList = filterList;
        this.filterList.setMatcherEditor(this.matcherEditor);
        this.filterLock = filterList.getReadWriteLock();
    }

    public void applyFilter(Map<Integer, Object> filterIndexToObjectMap) {
        if (filterIndexToObjectMap.isEmpty()) {
            try {
                this.filterLock.writeLock().lock();
                this.matcherEditor.getMatcherEditors().clear();
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
            return;
        }
        try {
            BasicEventList matcherEditors = new BasicEventList();
            for (Map.Entry<Integer, Object> mapEntry : filterIndexToObjectMap.entrySet()) {
                Integer columnIndex = mapEntry.getKey();
                String filterText = this.getStringFromColumnObject(columnIndex, mapEntry.getValue());
                String textDelimiter = (String)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.TEXT_DELIMITER, DisplayMode.NORMAL, new String[]{"FILTER_COLUMN_" + columnIndex});
                TextMatchingMode textMatchingMode = (TextMatchingMode)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, DisplayMode.NORMAL, new String[]{"FILTER_COLUMN_" + columnIndex});
                IDisplayConverter displayConverter = this.getFilterContentDisplayConverter(columnIndex);
                Comparator comparator = (Comparator)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_COMPARATOR, DisplayMode.NORMAL, new String[]{"FILTER_COLUMN_" + columnIndex});
                FunctionList.Function<T, Object> columnValueProvider = this.getColumnValueProvider(columnIndex);
                List<ParseResult> parseResults = FilterRowUtils.parse(filterText, textDelimiter, textMatchingMode);
                BasicEventList stringMatcherEditors = new BasicEventList();
                BasicEventList thresholdMatcherEditors = new BasicEventList();
                for (ParseResult parseResult : parseResults) {
                    try {
                        ParseResult.MatchType matchOperation = parseResult.getMatchOperation();
                        if (matchOperation == ParseResult.MatchType.NONE) {
                            stringMatcherEditors.add(this.getTextMatcherEditor(columnIndex, textMatchingMode, displayConverter, parseResult.getValueToMatch()));
                            continue;
                        }
                        Object threshold = displayConverter.displayToCanonicalValue((Object)parseResult.getValueToMatch());
                        thresholdMatcherEditors.add(this.getThresholdMatcherEditor(columnIndex, threshold, comparator, columnValueProvider, matchOperation));
                    }
                    catch (PatternSyntaxException e) {
                        LOG.warn("Error on applying a filter: {}", (Object)e.getLocalizedMessage());
                    }
                }
                String[] separator = FilterRowUtils.getSeparatorCharacters(textDelimiter);
                if (!stringMatcherEditors.isEmpty()) {
                    CompositeMatcherEditor stringCompositeMatcherEditor = new CompositeMatcherEditor((EventList)stringMatcherEditors);
                    if (separator == null || filterText.contains(separator[1])) {
                        stringCompositeMatcherEditor.setMode(24);
                    } else {
                        stringCompositeMatcherEditor.setMode(42);
                    }
                    matcherEditors.add((Object)stringCompositeMatcherEditor);
                }
                if (thresholdMatcherEditors.isEmpty()) continue;
                CompositeMatcherEditor thresholdCompositeMatcherEditor = new CompositeMatcherEditor((EventList)thresholdMatcherEditors);
                if (separator == null || filterText.contains(separator[0])) {
                    thresholdCompositeMatcherEditor.setMode(42);
                } else {
                    thresholdCompositeMatcherEditor.setMode(24);
                }
                matcherEditors.add((Object)thresholdCompositeMatcherEditor);
            }
            try {
                this.filterLock.writeLock().lock();
                boolean changed = false;
                Iterator existingMatcherEditors = this.matcherEditor.getMatcherEditors().iterator();
                while (existingMatcherEditors.hasNext()) {
                    MatcherEditor existingMatcherEditor = (MatcherEditor)existingMatcherEditors.next();
                    if (this.containsMatcherEditor((List<MatcherEditor<T>>)matcherEditors, (MatcherEditor<T>)existingMatcherEditor)) continue;
                    existingMatcherEditors.remove();
                    changed = true;
                }
                for (MatcherEditor me : matcherEditors) {
                    if (this.containsMatcherEditor((List<MatcherEditor<T>>)this.matcherEditor.getMatcherEditors(), (MatcherEditor<T>)me)) continue;
                    this.matcherEditor.getMatcherEditors().add((Object)me);
                    changed = true;
                }
                if (!changed) {
                    this.matcherEditor.getMatcherEditors().add(this.matchAll);
                    this.matcherEditor.getMatcherEditors().remove(this.matchAll);
                }
            }
            finally {
                this.filterLock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            LOG.error("Error on applying a filter", (Throwable)e);
        }
    }

    protected IDisplayConverter getFilterContentDisplayConverter(int columnIndex) {
        IDisplayConverter displayConverter = (IDisplayConverter)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_CONTENT_DISPLAY_CONVERTER, DisplayMode.NORMAL, new String[]{"FILTER_COLUMN_" + columnIndex});
        if (displayConverter == null) {
            displayConverter = (IDisplayConverter)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, DisplayMode.NORMAL, new String[]{"FILTER_COLUMN_" + columnIndex});
        }
        return displayConverter;
    }

    protected String getStringFromColumnObject(int columnIndex, Object object) {
        IDisplayConverter displayConverter = (IDisplayConverter)this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, DisplayMode.NORMAL, new String[]{"FILTER_COLUMN_" + columnIndex});
        return displayConverter.canonicalToDisplayValue((ILayerCell)new LayerCell(null, columnIndex, 0), this.configRegistry, object).toString();
    }

    protected ThresholdMatcherEditor<T, Object> getThresholdMatcherEditor(Integer columnIndex, Object threshold, Comparator<Object> comparator, FunctionList.Function<T, Object> columnValueProvider, ParseResult.MatchType matchOperation) {
        ThresholdMatcherEditor thresholdMatcherEditor = new ThresholdMatcherEditor(threshold, null, comparator, columnValueProvider);
        FilterRowUtils.setMatchOperation(thresholdMatcherEditor, matchOperation);
        return thresholdMatcherEditor;
    }

    protected FunctionList.Function<T, Object> getColumnValueProvider(int columnIndex) {
        return rowObject -> this.columnAccessor.getDataValue(rowObject, columnIndex);
    }

    protected TextMatcherEditor<T> getTextMatcherEditor(Integer columnIndex, TextMatchingMode textMatchingMode, IDisplayConverter converter, String filterText) {
        TextMatcherEditor textMatcherEditor = new TextMatcherEditor(this.getTextFilterator(columnIndex, converter));
        textMatcherEditor.setFilterText(new String[]{filterText});
        textMatcherEditor.setMode(this.getGlazedListsTextMatcherEditorMode(textMatchingMode));
        return textMatcherEditor;
    }

    protected TextFilterator<T> getTextFilterator(Integer columnIndex, IDisplayConverter converter) {
        return new ColumnTextFilterator(converter, columnIndex);
    }

    public int getGlazedListsTextMatcherEditorMode(TextMatchingMode textMatchingMode) {
        switch (textMatchingMode) {
            case EXACT: {
                return 3;
            }
            case STARTS_WITH: {
                return 1;
            }
            case REGULAR_EXPRESSION: {
                return 2;
            }
        }
        return 0;
    }

    protected boolean containsMatcherEditor(List<MatcherEditor<T>> existingMatcherEditors, MatcherEditor<T> matcherEditor) {
        boolean result = false;
        Iterator<MatcherEditor<T>> existingMatcherEditorsIterator = existingMatcherEditors.iterator();
        while (existingMatcherEditorsIterator.hasNext() && !result) {
            result = this.matcherEditorEqual(existingMatcherEditorsIterator.next(), matcherEditor);
        }
        return result;
    }

    protected boolean matcherEditorEqual(MatcherEditor<T> first, MatcherEditor<T> second) {
        boolean result = false;
        if (first.getClass().equals(second.getClass())) {
            if (first instanceof CompositeMatcherEditor) {
                CompositeMatcherEditor firstComp = (CompositeMatcherEditor)first;
                CompositeMatcherEditor secondComp = (CompositeMatcherEditor)second;
                boolean bl = result = firstComp.getMatcherEditors().size() == secondComp.getMatcherEditors().size() && firstComp.getMode() == secondComp.getMode();
                if (result) {
                    Iterator matcherEditors = firstComp.getMatcherEditors().iterator();
                    while (matcherEditors.hasNext() && result) {
                        MatcherEditor e = (MatcherEditor)matcherEditors.next();
                        Iterator iterator = secondComp.getMatcherEditors().iterator();
                        boolean found = false;
                        while (iterator.hasNext() && !found) {
                            found = this.matcherEditorEqual((MatcherEditor)iterator.next(), e);
                        }
                        result = found;
                    }
                }
            } else if (first instanceof TextMatcherEditor) {
                TextMatcherEditor firstText = (TextMatcherEditor)first;
                TextMatcherEditor secondText = (TextMatcherEditor)second;
                result = first.getMatcher().equals(second.getMatcher()) && firstText.getFilterator().equals(secondText.getFilterator()) && firstText.getMode() == secondText.getMode() && firstText.getStrategy().equals(secondText.getStrategy());
            } else if (first instanceof ThresholdMatcherEditor) {
                ThresholdMatcherEditor firstThreshold = (ThresholdMatcherEditor)first;
                ThresholdMatcherEditor secondThreshold = (ThresholdMatcherEditor)second;
                result = firstThreshold.getThreshold() != null && secondThreshold.getThreshold() != null && firstThreshold.getThreshold().equals(secondThreshold.getThreshold()) && firstThreshold.getComparator().equals(secondThreshold.getComparator()) && firstThreshold.getMatchOperation() == secondThreshold.getMatchOperation();
            }
        }
        return result;
    }

    public CompositeMatcherEditor<T> getMatcherEditor() {
        return this.matcherEditor;
    }

    public class ColumnTextFilterator
    implements TextFilterator<T> {
        private final IDisplayConverter converter;
        private final Integer columnIndex;

        public ColumnTextFilterator(IDisplayConverter converter, Integer columnIndex) {
            this.converter = converter;
            this.columnIndex = columnIndex;
        }

        public void getFilterStrings(List<String> objectAsListOfStrings, T rowObject) {
            Object cellData = DefaultGlazedListsFilterStrategy.this.columnAccessor.getDataValue(rowObject, this.columnIndex.intValue());
            Object displayValue = this.converter.canonicalToDisplayValue(cellData);
            displayValue = displayValue != null ? displayValue : "";
            objectAsListOfStrings.add(displayValue.toString());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.columnIndex == null ? 0 : this.columnIndex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ColumnTextFilterator other = (ColumnTextFilterator)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.columnIndex == null ? other.columnIndex != null : !this.columnIndex.equals(other.columnIndex));
        }

        private DefaultGlazedListsFilterStrategy<T> getOuterType() {
            return DefaultGlazedListsFilterStrategy.this;
        }
    }
}

