/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByConfigAttributes;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.AbstractCellPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class GroupByHeaderPainter
extends AbstractCellPainter {
    private static final int LEFT_INDENT = 2;
    private static final int ENDCAP_WIDTH = 8;
    private static final int X_PADDING = 4;
    private static final int Y_PADDING = 2;
    private final GroupByModel groupByModel;
    private final IDataProvider columnHeaderDataProvider;
    private final ColumnHeaderLayer columnHeaderLayer;
    private List<Rectangle> groupByCellBounds = new ArrayList<Rectangle>();

    public GroupByHeaderPainter(GroupByModel groupByModel, IDataProvider columnHeaderDataProvider) {
        this.groupByModel = groupByModel;
        this.columnHeaderDataProvider = columnHeaderDataProvider;
        this.columnHeaderLayer = null;
    }

    public GroupByHeaderPainter(GroupByModel groupByModel, IDataProvider columnHeaderDataProvider, ColumnHeaderLayer columnHeaderLayer) {
        this.groupByModel = groupByModel;
        this.columnHeaderDataProvider = columnHeaderDataProvider;
        this.columnHeaderLayer = columnHeaderLayer;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Color originalBackground = gc.getBackground();
        Color originalForeground = gc.getForeground();
        Font originalFont = gc.getFont();
        Color headerBgColor = (Color)configRegistry.getConfigAttribute(GroupByConfigAttributes.GROUP_BY_HEADER_BACKGROUND_COLOR, DisplayMode.NORMAL, new String[0]);
        if (headerBgColor != null) {
            gc.setBackground(headerBgColor);
        }
        gc.fillRectangle(bounds);
        this.groupByCellBounds.clear();
        IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
        gc.setBackground((Color)cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        gc.setForeground((Color)cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        gc.setFont((Font)cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        gc.setAntialias(-1);
        gc.setTextAntialias(-1);
        List<Integer> groupByColumnIndexes = this.groupByModel.getGroupByColumnIndexes();
        if (!groupByColumnIndexes.isEmpty()) {
            int textHeight = gc.textExtent((String)"X").y;
            int x0 = bounds.x + 2;
            int y0 = bounds.y + bounds.height / 2 - textHeight / 2 - 2;
            int yHeight = 2 + textHeight + 2;
            gc.drawLine(x0, y0, x0, y0 + yHeight);
            ++x0;
            int lastColumnIndex = groupByColumnIndexes.size() - 1;
            int i = 0;
            while (i <= lastColumnIndex) {
                int columnIndex = groupByColumnIndexes.get(i);
                String columnName = null;
                columnName = this.columnHeaderLayer != null && this.columnHeaderLayer.isColumnRenamed(columnIndex) ? this.columnHeaderLayer.getRenamedColumnLabelByIndex(columnIndex) : (String)this.columnHeaderDataProvider.getDataValue(columnIndex, 0);
                int textWidth = gc.textExtent((String)columnName).x;
                this.groupByCellBounds.add(new Rectangle(x0, y0, 4 + textWidth + 4, yHeight));
                gc.fillRectangle(x0, y0, 4 + textWidth + 4, yHeight);
                gc.drawLine(x0, y0, x0 + 4 + textWidth + 4, y0);
                gc.drawLine(x0, y0 + yHeight, x0 + 4 + textWidth + 4, y0 + yHeight);
                gc.drawText(columnName, x0 + 4, y0 + 2);
                x0 += 4 + textWidth + 4;
                if (i < lastColumnIndex) {
                    gc.fillRectangle(x0, y0, 8, yHeight);
                    gc.drawLine(x0, y0, x0 + 8, y0);
                    gc.drawLine(x0, y0 + yHeight, x0 + 8, y0 + yHeight);
                } else {
                    gc.fillPolygon(new int[]{x0, y0, x0 + 8, y0 + yHeight / 2, x0, y0 + yHeight});
                }
                gc.drawLine(x0, y0, x0 + 8 - 1, y0 + yHeight / 2);
                gc.drawLine(x0, y0 + yHeight, x0 + 8 - 1, y0 + yHeight / 2);
                x0 += 8;
                ++i;
            }
        } else {
            String hint = (String)configRegistry.getConfigAttribute(GroupByConfigAttributes.GROUP_BY_HINT, DisplayMode.NORMAL, new String[0]);
            if (hint != null) {
                IStyle hintStyle = (IStyle)configRegistry.getConfigAttribute(GroupByConfigAttributes.GROUP_BY_HINT_STYLE, DisplayMode.NORMAL, new String[0]);
                if (hintStyle != null) {
                    Font hintFont;
                    Color hintBackground = (Color)hintStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
                    gc.setBackground(hintBackground != null ? hintBackground : originalBackground);
                    Color hintForeground = (Color)hintStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
                    if (hintForeground != null) {
                        gc.setForeground(hintForeground);
                    }
                    if ((hintFont = CellStyleUtil.getFont((IStyle)hintStyle, (IConfigRegistry)configRegistry)) != null) {
                        gc.setFont(hintFont);
                    }
                } else {
                    gc.setBackground(originalBackground);
                }
                int textHeight = gc.textExtent((String)"X").y;
                int x0 = bounds.x + 2;
                int y0 = bounds.y + bounds.height / 2 - textHeight / 2 - 2;
                gc.drawText(hint, x0 + 4, y0);
            }
        }
        gc.setBackground(originalBackground);
        gc.setForeground(originalForeground);
        gc.setFont(originalFont);
    }

    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return 0;
    }

    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.getPreferredHeight();
    }

    public int getPreferredHeight() {
        return 30;
    }

    public int getGroupByColumnIndexAtXY(int x, int y) {
        int i = 0;
        while (i < this.groupByCellBounds.size()) {
            Rectangle bounds = this.groupByCellBounds.get(i);
            if (bounds.contains(x, y)) {
                return this.groupByModel.getGroupByColumnIndexes().get(i);
            }
            ++i;
        }
        return -1;
    }
}

