/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.dataset.person;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.eclipse.nebula.widgets.nattable.dataset.person.Address;
import org.eclipse.nebula.widgets.nattable.dataset.person.ExtendedPersonWithAddress;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonWithAddress;

public class PersonService {
    static String[] maleNames = new String[]{"Bart", "Homer", "Lenny", "Carl", "Waylon", "Ned", "Timothy", "Rodd", "Todd"};
    static String[] femaleNames = new String[]{"Marge", "Lisa", "Maggie", "Edna", "Helen", "Jessica", "Maude"};
    static String[] lastNames = new String[]{"Simpson", "Leonard", "Carlson", "Smithers", "Flanders", "Krabappel", "Lovejoy"};
    static String[] streetNames = new String[]{"Evergreen Terrace", "Main Street", "South Street", "Plympton Street", "Highland Avenue", "Elm Street", "Oak Grove Street"};
    static String[] cityNames = new String[]{"Springfield", "Shelbyville", "Ogdenville", "Waverly Hills", "North Haverbrook", "Capital City"};
    static String[] foodList = new String[]{"Donut", "Bacon", "Fish", "Vegetables", "Ham", "Prezels"};
    static String[] drinkList = new String[]{"Beer", "Water", "Soda", "Milk", "Coke", "Fizzy Bubblech"};
    static String baseText = "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.";

    public static List<Person> getRandomPersons(int numberOfPersons) {
        ArrayList<Person> result = new ArrayList<Person>();
        int i = 0;
        while (i < numberOfPersons) {
            result.add(PersonService.createPerson(i));
            ++i;
        }
        return result;
    }

    public static List<Person> getFixedPersons() {
        ArrayList<Person> result = new ArrayList<Person>();
        result.add(new Person(1, maleNames[1], lastNames[0], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(2, maleNames[1], lastNames[0], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(3, maleNames[1], lastNames[0], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(4, maleNames[0], lastNames[0], Person.Gender.MALE, false, new Date(), 100.0));
        result.add(new Person(5, maleNames[0], lastNames[0], Person.Gender.MALE, false, new Date(), 100.0));
        result.add(new Person(6, maleNames[0], lastNames[0], Person.Gender.MALE, false, new Date(), 100.0));
        result.add(new Person(7, femaleNames[0], lastNames[0], Person.Gender.FEMALE, true, new Date(), 100.0));
        result.add(new Person(8, femaleNames[0], lastNames[0], Person.Gender.FEMALE, true, new Date(), 100.0));
        result.add(new Person(9, femaleNames[1], lastNames[0], Person.Gender.FEMALE, false, new Date(), 100.0));
        result.add(new Person(10, femaleNames[1], lastNames[0], Person.Gender.FEMALE, false, new Date(), 100.0));
        result.add(new Person(11, maleNames[5], lastNames[4], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(12, maleNames[5], lastNames[4], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(13, femaleNames[6], lastNames[4], Person.Gender.FEMALE, true, new Date(), 100.0));
        result.add(new Person(14, femaleNames[6], lastNames[4], Person.Gender.FEMALE, true, new Date(), 100.0));
        result.add(new Person(15, maleNames[7], lastNames[4], Person.Gender.MALE, false, new Date(), 100.0));
        result.add(new Person(16, maleNames[7], lastNames[4], Person.Gender.MALE, false, new Date(), 100.0));
        result.add(new Person(17, maleNames[8], lastNames[4], Person.Gender.MALE, false, new Date(), 100.0));
        result.add(new Person(18, maleNames[8], lastNames[4], Person.Gender.MALE, false, new Date(), 100.0));
        return result;
    }

    public static List<Person> getFixedPersonsWithNull() {
        ArrayList<Person> result = new ArrayList<Person>();
        result.add(new Person(1, maleNames[1], lastNames[0], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(3, maleNames[1], lastNames[0], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(7, femaleNames[0], lastNames[0], Person.Gender.FEMALE, true, new Date(), 100.0));
        result.add(new Person(8, femaleNames[0], lastNames[0], Person.Gender.FEMALE, true, new Date(), 100.0));
        result.add(new Person(7, femaleNames[0], lastNames[0], Person.Gender.FEMALE, true, new Date(), null));
        result.add(new Person(11, maleNames[5], null, Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(13, femaleNames[6], null, Person.Gender.FEMALE, true, new Date(), 100.0));
        return result;
    }

    public static List<Person> getFixedMixedPersons() {
        ArrayList<Person> result = new ArrayList<Person>();
        result.add(new Person(21, maleNames[0], lastNames[2], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(22, maleNames[1], lastNames[2], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(23, maleNames[5], lastNames[2], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(24, femaleNames[0], lastNames[2], Person.Gender.FEMALE, false, new Date(), 100.0));
        result.add(new Person(25, femaleNames[6], lastNames[2], Person.Gender.FEMALE, false, new Date(), 100.0));
        result.add(new Person(30, maleNames[1], lastNames[0], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(31, maleNames[1], lastNames[0], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(32, maleNames[1], lastNames[2], Person.Gender.MALE, true, new Date(), 100.0));
        result.add(new Person(33, maleNames[1], lastNames[2], Person.Gender.MALE, true, new Date(), 100.0));
        return result;
    }

    public static List<Person> getPersons(int numberOfPersons) {
        ArrayList<Person> result = new ArrayList<Person>();
        int i = 0;
        while (i < numberOfPersons) {
            result.add(PersonService.createPerson(i));
            ++i;
        }
        return result;
    }

    public static List<Address> getAddress(int number) {
        ArrayList<Address> result = new ArrayList<Address>();
        int i = 0;
        while (i < number) {
            result.add(PersonService.createAddress());
            ++i;
        }
        return result;
    }

    public static List<PersonWithAddress> getPersonsWithAddress(int numberOfPersons) {
        ArrayList<PersonWithAddress> result = new ArrayList<PersonWithAddress>();
        int i = 0;
        while (i < numberOfPersons) {
            result.add(PersonService.createPersonWithAddress(i));
            ++i;
        }
        return result;
    }

    public static List<ExtendedPersonWithAddress> getExtendedPersonsWithAddress(int numberOfPersons) {
        ArrayList<ExtendedPersonWithAddress> result = new ArrayList<ExtendedPersonWithAddress>();
        int i = 0;
        while (i < numberOfPersons) {
            result.add(PersonService.createExtendedPersonWithAddress(i));
            ++i;
        }
        return result;
    }

    private static Person createPerson(int id) {
        Random randomGenerator = new Random();
        Person result = new Person(id);
        result.setGender(Person.Gender.values()[randomGenerator.nextInt(2)]);
        if (result.getGender().equals((Object)Person.Gender.MALE)) {
            result.setFirstName(maleNames[randomGenerator.nextInt(maleNames.length)]);
        } else {
            result.setFirstName(femaleNames[randomGenerator.nextInt(femaleNames.length)]);
        }
        result.setLastName(lastNames[randomGenerator.nextInt(lastNames.length)]);
        result.setMarried(randomGenerator.nextBoolean());
        int month = randomGenerator.nextInt(12);
        int day = 0;
        day = month == 2 ? randomGenerator.nextInt(28) : randomGenerator.nextInt(30);
        int year = 1920 + randomGenerator.nextInt(90);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            result.setBirthday(sdf.parse(year + "-" + month + "-" + day));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        result.setMoney(randomGenerator.nextDouble() * 100.0);
        return result;
    }

    public static Address createAddress() {
        String[] streets = PersonService.getStreetNames();
        int[] plz = new int[]{11111, 22222, 33333, 44444, 55555, 66666};
        String[] cities = PersonService.getCityNames();
        Random randomGenerator = new Random();
        Address result = new Address();
        result.setStreet(streets[randomGenerator.nextInt(streets.length)]);
        result.setHousenumber(randomGenerator.nextInt(200));
        int cityRandom = randomGenerator.nextInt(cities.length);
        result.setPostalCode(plz[cityRandom]);
        result.setCity(cities[cityRandom]);
        return result;
    }

    public static PersonWithAddress createPersonWithAddress(int id) {
        return new PersonWithAddress(PersonService.createPerson(id), PersonService.createAddress());
    }

    public static ExtendedPersonWithAddress createExtendedPersonWithAddress(int id) {
        return new ExtendedPersonWithAddress(PersonService.createPerson(id), PersonService.createAddress(), PersonService.generateSimplePassword(), PersonService.createRandomLengthText(), PersonService.createRandomMoneyAmount(), PersonService.createFavouriteFood(), PersonService.createFavouriteDrinks());
    }

    public static String generateSimplePassword() {
        String result = "";
        int i = 0;
        while (i < 7) {
            int rnd = (int)(Math.random() * 52.0);
            int base = rnd < 26 ? 65 : 97;
            result = String.valueOf(result) + (char)(base + rnd % 26);
            ++i;
        }
        return result;
    }

    private static List<String> createFavouriteFood() {
        String[] food = PersonService.getFoodList();
        Random rand = new Random();
        int favCount = rand.nextInt(food.length);
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < favCount) {
            int randIndex = rand.nextInt(food.length);
            if (!result.contains(food[randIndex])) {
                result.add(food[randIndex]);
            }
            ++i;
        }
        return result;
    }

    private static List<String> createFavouriteDrinks() {
        String[] drinks = PersonService.getDrinkList();
        Random rand = new Random();
        int favCount = rand.nextInt(drinks.length);
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < favCount) {
            int randIndex = rand.nextInt(drinks.length);
            if (!result.contains(drinks[randIndex])) {
                result.add(drinks[randIndex]);
            }
            ++i;
        }
        return result;
    }

    public static String[] getStreetNames() {
        return streetNames;
    }

    public static String[] getCityNames() {
        return cityNames;
    }

    public static String[] getFoodList() {
        return foodList;
    }

    public static String[] getDrinkList() {
        return drinkList;
    }

    public static String createRandomLengthText() {
        String[] words = baseText.split(" ");
        Random wordRandom = new Random();
        String msg = "";
        int randWords = wordRandom.nextInt(words.length);
        int j = 0;
        while (j < randWords) {
            msg = (msg = String.valueOf(msg) + words[j]).endsWith(",") || msg.endsWith(".") ? String.valueOf(msg) + "\n" : String.valueOf(msg) + " ";
            ++j;
        }
        return msg;
    }

    public static Double createRandomMoneyAmount() {
        Double result = new Random().nextDouble() * 1000.0;
        BigDecimal bd = new BigDecimal(result);
        bd = bd.setScale(2, 4);
        return bd.doubleValue();
    }
}

