/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupReorderEndCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupReorderStartCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.reorder.action.RowReorderDragMode;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderEndCommand;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderStartCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.ClearAllSelectionsCommand;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class RowGroupHeaderReorderDragMode
extends RowReorderDragMode {
    protected final RowGroupHeaderLayer rowGroupHeaderLayer;
    protected int level;
    protected int dragFromGridColumnPosition;

    public RowGroupHeaderReorderDragMode(RowGroupHeaderLayer columnGroupHeaderLayer) {
        this.rowGroupHeaderLayer = columnGroupHeaderLayer;
    }

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        this.natTable = natTable;
        this.currentEvent = this.initialEvent = event;
        this.dragFromGridColumnPosition = this.natTable.getColumnPositionByX(this.initialEvent.x);
        this.dragFromGridRowPosition = this.natTable.getRowPositionByY(this.initialEvent.y);
        RowPositionCoordinate convertedRow = LayerCommandUtil.convertRowPositionToTargetContext(new RowPositionCoordinate(natTable, this.dragFromGridRowPosition), this.rowGroupHeaderLayer);
        ColumnPositionCoordinate convertedColumn = LayerCommandUtil.convertColumnPositionToTargetContext(new ColumnPositionCoordinate(natTable, this.dragFromGridColumnPosition), this.rowGroupHeaderLayer);
        this.calculateLevel(convertedColumn.getColumnPosition(), convertedRow.getRowPosition());
        natTable.addOverlayPainter(this.targetOverlayPainter);
        natTable.doCommand(new ClearAllSelectionsCommand());
        this.fireMoveStartCommand(natTable, this.dragFromGridRowPosition);
    }

    @Override
    protected boolean isValidTargetRowPosition(ILayer natLayer, int fromGridRowPosition, int toGridRowPosition) {
        if (!this.rowGroupHeaderLayer.isReorderSupportedOnLevel(this.level)) {
            return false;
        }
        if (this.currentEvent != null) {
            CellEdgeEnum moveDirection = this.getMoveDirection(this.currentEvent.y);
            toGridRowPosition = this.getDragToGridRowPosition(moveDirection, this.natTable.getColumnPositionByX(this.currentEvent.y));
        }
        int toPosition = LayerUtil.convertRowPosition(natLayer, toGridRowPosition, this.rowGroupHeaderLayer.getPositionLayer());
        int fromPosition = this.rowGroupHeaderLayer.getReorderFromRowPosition();
        if (this.level >= 0) {
            GroupModel model;
            int lvl = this.level + 1;
            while (lvl < this.rowGroupHeaderLayer.getLevelCount()) {
                model = this.rowGroupHeaderLayer.getGroupModel(lvl);
                if (model.isPartOfAnUnbreakableGroup(fromPosition)) {
                    SelectionLayer.MoveDirectionEnum moveDirection;
                    int toCheck = toPosition;
                    toCheck = toPosition < 0 && toGridRowPosition == natLayer.getColumnCount() ? LayerUtil.convertRowPosition(natLayer, toGridRowPosition - 1, this.rowGroupHeaderLayer.getPositionLayer()) : (SelectionLayer.MoveDirectionEnum.DOWN == (moveDirection = PositionUtil.getVerticalMoveDirection(fromPosition, toCheck)) ? toCheck - 1 : toCheck);
                    return RowGroupUtils.isInTheSameGroup(this.rowGroupHeaderLayer, lvl, fromPosition, toCheck);
                }
                ++lvl;
            }
            lvl = this.level + 1;
            while (lvl < this.rowGroupHeaderLayer.getLevelCount()) {
                model = this.rowGroupHeaderLayer.getGroupModel(lvl);
                boolean betweenTwoGroups = false;
                if (this.currentEvent != null) {
                    int minX = this.currentEvent.x - 4;
                    int maxX = this.currentEvent.x + 4;
                    betweenTwoGroups = RowGroupUtils.isBetweenTwoGroups(natLayer, minX, maxX, this.rowGroupHeaderLayer, lvl);
                }
                if (!betweenTwoGroups && model.isPartOfAnUnbreakableGroup(toPosition)) {
                    return false;
                }
                ++lvl;
            }
            return RowGroupUtils.isBetweenTwoGroups(this.rowGroupHeaderLayer, this.level, toPosition, toPosition < this.rowGroupHeaderLayer.getColumnCount(), PositionUtil.getVerticalMoveDirection(fromGridRowPosition, toGridRowPosition));
        }
        int level = 0;
        while (level < this.rowGroupHeaderLayer.getLevelCount()) {
            if (!this.isValidTargetRowPosition(natLayer, fromGridRowPosition, toGridRowPosition, level, fromPosition, toPosition)) {
                return false;
            }
            ++level;
        }
        return true;
    }

    protected boolean isValidTargetRowPosition(ILayer natLayer, int fromGridRowPosition, int toGridRowPosition, int level, int fromPosition, int toPosition) {
        GroupModel model = this.rowGroupHeaderLayer.getGroupModel(level);
        if (model.isPartOfAnUnbreakableGroup(fromPosition) && model.getGroupByPosition(fromPosition).getOriginalSpan() > 1) {
            SelectionLayer.MoveDirectionEnum moveDirection;
            int toCheck = toPosition;
            toCheck = toPosition < 0 && toGridRowPosition == natLayer.getColumnCount() ? LayerUtil.convertRowPosition(natLayer, toGridRowPosition - 1, this.rowGroupHeaderLayer.getPositionLayer()) : (SelectionLayer.MoveDirectionEnum.DOWN == (moveDirection = PositionUtil.getVerticalMoveDirection(fromPosition, toCheck)) ? toCheck - 1 : toCheck);
            return RowGroupUtils.isInTheSameGroup(this.rowGroupHeaderLayer, level, fromPosition, toCheck);
        }
        boolean betweenTwoGroups = false;
        if (this.currentEvent != null) {
            int minX = this.currentEvent.x - 4;
            int maxX = this.currentEvent.x + 4;
            betweenTwoGroups = RowGroupUtils.isBetweenTwoGroups(natLayer, minX, maxX, this.rowGroupHeaderLayer, level);
        }
        return betweenTwoGroups || !model.isPartOfAnUnbreakableGroup(toPosition);
    }

    @Override
    protected void fireMoveStartCommand(NatTable natTable, int dragFromGridRowPosition) {
        if (this.level >= 0) {
            natTable.doCommand(new RowGroupReorderStartCommand(natTable, this.level, dragFromGridRowPosition));
        } else {
            natTable.doCommand(new RowReorderStartCommand(natTable, dragFromGridRowPosition));
        }
    }

    @Override
    protected void fireMoveEndCommand(NatTable natTable, int dragToGridRowPosition) {
        if (this.level >= 0) {
            natTable.doCommand(new RowGroupReorderEndCommand(natTable, this.level, dragToGridRowPosition));
        } else {
            natTable.doCommand(new RowReorderEndCommand(natTable, dragToGridRowPosition));
        }
    }

    @Override
    protected CellEdgeEnum getMoveDirection(int y) {
        ILayerCell cell = this.getRowCell(y);
        if (cell != null) {
            Rectangle selectedRowHeaderRect = cell.getBounds();
            return CellEdgeDetectUtil.getVerticalCellEdge(selectedRowHeaderRect, new Point(this.natTable.getStartXOfColumnPosition(this.dragFromGridColumnPosition), y));
        }
        return null;
    }

    @Override
    protected ILayerCell getRowCell(int y) {
        int gridRowPosition = this.natTable.getRowPositionByY(y);
        return this.natTable.getCellByPosition(this.dragFromGridColumnPosition, gridRowPosition);
    }

    protected void calculateLevel(int columnPosition, int rowPosition) {
        this.level = this.rowGroupHeaderLayer.getLevelForColumnPosition(columnPosition);
        GroupModel.Group group = this.rowGroupHeaderLayer.getGroupByPosition(this.level, rowPosition);
        while (group == null && this.level > 0) {
            --this.level;
            ++this.dragFromGridColumnPosition;
            group = this.rowGroupHeaderLayer.getGroupByPosition(this.level, rowPosition);
        }
        if (group == null) {
            this.level = -1;
            this.dragFromGridColumnPosition = this.rowGroupHeaderLayer.getColumnCount() - 1;
        }
    }
}

