/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.dataset.generator;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.nebula.widgets.nattable.dataset.generator.DataValueGenerator;
import org.eclipse.nebula.widgets.nattable.dataset.generator.GenerateDouble;
import org.eclipse.nebula.widgets.nattable.dataset.generator.GenerateListOfStrings;
import org.eclipse.nebula.widgets.nattable.dataset.generator.GeneratorException;
import org.eclipse.nebula.widgets.nattable.dataset.generator.IValueGenerator;
import org.eclipse.nebula.widgets.nattable.dataset.valuegenerator.DoubleValueGenerator;
import org.eclipse.nebula.widgets.nattable.dataset.valuegenerator.ListValueGenerator;

public class DataGenerator<T> {
    private static final Random random = new Random();
    private static final Lock lock = new ReentrantLock();

    public T generate(Class<T> dataClass) throws GeneratorException {
        try {
            T dataContainer = dataClass.newInstance();
            ValueGeneratorFactory generatorFactory = new ValueGeneratorFactory();
            Field[] fieldArray = dataClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                IValueGenerator generator = generatorFactory.createValueGenerator(field);
                if (generator != null) {
                    this.setField(dataClass, dataContainer, field, generator);
                }
                ++n2;
            }
            return dataContainer;
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            throw new GeneratorException(ie);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            throw new GeneratorException(iae);
        }
        catch (SecurityException se) {
            se.printStackTrace();
            throw new GeneratorException(se);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
            throw new GeneratorException(nsme);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
    }

    private void setField(Class<T> dataClass, T dataContainer, Field field, IValueGenerator generator) throws IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        lock.lock();
        try {
            Method setter = dataClass.getDeclaredMethod("set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1), field.getType());
            setter.invoke(dataContainer, generator.newValue(random));
        }
        finally {
            lock.unlock();
        }
    }

    private static class DataValueGeneratorFactory
    implements IValueGeneratorFactory {
        private DataValueGeneratorFactory() {
        }

        @Override
        public IValueGenerator createValueGenerator(Field field) throws InstantiationException, IllegalAccessException {
            field.setAccessible(true);
            DataValueGenerator annotation = field.getAnnotation(DataValueGenerator.class);
            Class<? extends IValueGenerator> generatorClass = annotation.value();
            return generatorClass.newInstance();
        }
    }

    private static class DoubleValueGeneratorFactory
    implements IValueGeneratorFactory {
        private DoubleValueGeneratorFactory() {
        }

        @Override
        public IValueGenerator createValueGenerator(Field field) throws InstantiationException, IllegalAccessException {
            field.setAccessible(true);
            GenerateDouble generateDouble = field.getAnnotation(GenerateDouble.class);
            return new DoubleValueGenerator(generateDouble.floor(), generateDouble.range());
        }
    }

    private static interface IValueGeneratorFactory {
        public IValueGenerator createValueGenerator(Field var1) throws InstantiationException, IllegalAccessException;
    }

    private static class StringListValueGeneratorFactory
    implements IValueGeneratorFactory {
        private StringListValueGeneratorFactory() {
        }

        @Override
        public IValueGenerator createValueGenerator(Field field) throws InstantiationException, IllegalAccessException {
            field.setAccessible(true);
            GenerateListOfStrings generateList = field.getAnnotation(GenerateListOfStrings.class);
            return new ListValueGenerator<String>(generateList.nullLoadFactor(), generateList.values());
        }
    }

    private static class ValueGeneratorFactory
    implements IValueGeneratorFactory {
        private ValueGeneratorFactory() {
        }

        @Override
        public IValueGenerator createValueGenerator(Field field) throws InstantiationException, IllegalAccessException {
            if (field.isAnnotationPresent(DataValueGenerator.class)) {
                return new DataValueGeneratorFactory().createValueGenerator(field);
            }
            if (field.isAnnotationPresent(GenerateDouble.class)) {
                return new DoubleValueGeneratorFactory().createValueGenerator(field);
            }
            if (field.isAnnotationPresent(GenerateListOfStrings.class)) {
                return new StringListValueGeneratorFactory().createValueGenerator(field);
            }
            return null;
        }
    }
}

