/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._100_Layers;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DummyBodyDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DummyColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.menu.DebugMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _002_Lateral_layer_composition
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _002_Lateral_layer_composition());
    }

    @Override
    public String getDescription() {
        return "In addition to being able to stack layers on top of each other, layers can also be arranged laterally to form aggregate layers. A common example of this is a 2 by 2 grid layer consisting of a corner, column header, row header, and body region. If you only need this common case, then you can use the provided DefaultGridLayer class. If you require more customization however, you can assemble your own composite grid layer. This example shows how to assemble a layer that only has a column header and body region.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        DummyBodyDataProvider bodyDataProvider = new DummyBodyDataProvider(200, 1000000);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)new ColumnReorderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)bodyDataProvider)));
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DummyColumnHeaderDataProvider((IDataProvider)bodyDataProvider)), (ILayer)viewportLayer, selectionLayer);
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)columnHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        NatTable natTable = new NatTable(parent, (ILayer)compositeLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new DebugMenuConfiguration(natTable));
        natTable.configure();
        return natTable;
    }
}

