/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._800_Integration;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.VisualRefreshCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.Address;
import org.eclipse.nebula.widgets.nattable.dataset.person.ExtendedPersonWithAddress;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByConfigAttributes;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByConfigLabelModifier;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByDataLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.summary.IGroupBySummaryProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.summary.SummationGroupBySummaryProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.persistence.command.DisplayPersistenceDialogCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommand;
import org.eclipse.nebula.widgets.nattable.ui.menu.AbstractHeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _808_SortableGroupByWithFilterExample
extends AbstractNatExample {
    private IGroupBySummaryProvider<ExtendedPersonWithAddress> sumMoneySummaryProvider;
    private IGroupBySummaryProvider<ExtendedPersonWithAddress> avgMoneySummaryProvider;
    private boolean useMoneySum = true;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _808_SortableGroupByWithFilterExample());
    }

    @Override
    public String getDescription() {
        return "This example shows the usage of the group by feature in conjunction with summary values of the groupings.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        final ConfigRegistry configRegistry = new ConfigRegistry();
        String[] propertyNames = new String[]{"firstName", "lastName", "age", "money", "married", "gender", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("age", "Age");
        propertyToLabelMap.put("money", "Money");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("birthday", "Birthday");
        ExtendedReflectiveColumnPropertyAccessor columnPropertyAccessor = new ExtendedReflectiveColumnPropertyAccessor(propertyNames);
        final BodyLayerStack bodyLayerStack = new BodyLayerStack(PersonService.getExtendedPersonsWithAddress((int)10000), columnPropertyAccessor, configRegistry);
        bodyLayerStack.getBodyDataLayer().setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnLabelAccumulator());
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)new GlazedListsSortModel(bodyLayerStack.getSortedList(), (IColumnPropertyAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry, (ILayer)columnHeaderDataLayer), false);
        bodyLayerStack.getBodyDataLayer().initializeTreeComparator(sortHeaderLayer.getSortModel(), (IUniqueIndexLayer)bodyLayerStack.getTreeLayer(), true);
        final FilterRowHeaderComposite filterRowHeaderLayer = new FilterRowHeaderComposite((IFilterStrategy)new DefaultGlazedListsFilterStrategy(bodyLayerStack.getFilterList(), (IColumnAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry), (ILayer)sortHeaderLayer, columnHeaderDataLayer.getDataProvider(), (IConfigRegistry)configRegistry);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyLayerStack.getBodyDataProvider());
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)filterRowHeaderLayer);
        GridLayer gridLayer = new GridLayer(bodyLayerStack, (ILayer)filterRowHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        CompositeLayer compositeGridLayer = new CompositeLayer(1, 2);
        final GroupByHeaderLayer groupByHeaderLayer = new GroupByHeaderLayer(bodyLayerStack.getGroupByModel(), (ILayer)gridLayer, (IDataProvider)columnHeaderDataProvider);
        compositeGridLayer.setChildLayer("GROUP_BY_REGION", (ILayer)groupByHeaderLayer, 0, 0);
        compositeGridLayer.setChildLayer("Grid", (ILayer)gridLayer, 0, 1);
        final NatTable natTable = new NatTable(container, (ILayer)compositeGridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", "COLUMN_4");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDoubleDisplayConverter(), "NORMAL", "COLUMN_3");
            }
        });
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        this.sumMoneySummaryProvider = new SummationGroupBySummaryProvider((IColumnAccessor)columnPropertyAccessor);
        this.avgMoneySummaryProvider = new AverageMoneyGroupBySummaryProvider();
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, (Object)_808_SortableGroupByWithFilterExample.this.sumMoneySummaryProvider, "NORMAL", "GROUP_BY_COLUMN_3");
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, (Object)new AverageAgeGroupBySummaryProvider(), "NORMAL", "GROUP_BY_COLUMN_2");
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_CHILD_COUNT_PATTERN, (Object)"[{0}] - ({1})");
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_HINT, (Object)"Drag columns here");
                Style hintStyle = new Style();
                hintStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)GUIHelper.getFont((FontData[])new FontData[]{new FontData("Arial", 10, 2)}));
                configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_HINT_STYLE, (Object)hintStyle);
            }
        });
        natTable.addConfiguration((IConfiguration)new GroupByHeaderMenuConfiguration(natTable, groupByHeaderLayer));
        natTable.addConfiguration((IConfiguration)new AbstractHeaderMenuConfiguration(natTable){

            protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
                return super.createColumnHeaderMenu(natTable).withHideColumnMenuItem().withShowAllColumnsMenuItem().withStateManagerMenuItemProvider();
            }

            protected PopupMenuBuilder createCornerMenu(NatTable natTable) {
                return super.createCornerMenu(natTable).withShowAllColumnsMenuItem().withStateManagerMenuItemProvider();
            }
        });
        natTable.configure();
        natTable.registerCommandHandler((ILayerCommandHandler)new DisplayPersistenceDialogCommandHandler(natTable));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        Composite buttonPanel = new Composite(container, 0);
        buttonPanel.setLayout((Layout)new RowLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        Button toggleHeaderButton = new Button(buttonPanel, 8);
        toggleHeaderButton.setText("Toggle Group By Header");
        toggleHeaderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                groupByHeaderLayer.setVisible(!groupByHeaderLayer.isVisible());
            }
        });
        Button toggleFilterButton = new Button(buttonPanel, 8);
        toggleFilterButton.setText("Toggle Filter Row");
        toggleFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                filterRowHeaderLayer.setFilterRowVisible(!filterRowHeaderLayer.isFilterRowVisible());
            }
        });
        Button collapseAllButton = new Button(buttonPanel, 8);
        collapseAllButton.setText("Collapse All");
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new TreeCollapseAllCommand());
            }
        });
        Button expandAllButton = new Button(buttonPanel, 8);
        expandAllButton.setText("Expand All");
        expandAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new TreeExpandAllCommand());
            }
        });
        Button toggleMoneySummaryButton = new Button(buttonPanel, 8);
        toggleMoneySummaryButton.setText("Toggle Money Group Summary (SUM/AVG)");
        toggleMoneySummaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bodyLayerStack.getBodyDataLayer().clearCache();
                _808_SortableGroupByWithFilterExample.this.useMoneySum = !_808_SortableGroupByWithFilterExample.this.useMoneySum;
                if (_808_SortableGroupByWithFilterExample.this.useMoneySum) {
                    configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, (Object)_808_SortableGroupByWithFilterExample.this.sumMoneySummaryProvider, "NORMAL", "GROUP_BY_COLUMN_3");
                } else {
                    configRegistry.registerConfigAttribute(GroupByConfigAttributes.GROUP_BY_SUMMARY_PROVIDER, (Object)_808_SortableGroupByWithFilterExample.this.avgMoneySummaryProvider, "NORMAL", "GROUP_BY_COLUMN_3");
                }
                natTable.doCommand((ILayerCommand)new VisualRefreshCommand());
            }
        });
        Button addDynamicDataButton = new Button(buttonPanel, 8);
        addDynamicDataButton.setText("Add Data");
        addDynamicDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Address address = new Address();
                address.setStreet("Some Street");
                address.setHousenumber(42);
                address.setPostalCode(12345);
                address.setCity("In the clouds");
                Person person = new Person(42, "Ralph", "Wiggum", Person.Gender.MALE, false, new Date());
                ExtendedPersonWithAddress entry = new ExtendedPersonWithAddress(person, address, "0000", "The little Ralphy", 0.0, new ArrayList(), new ArrayList());
                bodyLayerStack.getEventList().add((Object)entry);
                person = new Person(42, "Clancy", "Wiggum", Person.Gender.MALE, true, new Date());
                entry = new ExtendedPersonWithAddress(person, address, "XXXL", "It is Chief Wiggum", 0.0, new ArrayList(), new ArrayList());
                bodyLayerStack.getEventList().add((Object)entry);
                person = new Person(42, "Sarah", "Wiggum", Person.Gender.FEMALE, true, new Date());
                entry = new ExtendedPersonWithAddress(person, address, "mommy", "Little Ralphy's mother", 0.0, new ArrayList(), new ArrayList());
                bodyLayerStack.getEventList().add((Object)entry);
            }
        });
        return container;
    }

    class AverageAgeGroupBySummaryProvider
    implements IGroupBySummaryProvider<ExtendedPersonWithAddress> {
        AverageAgeGroupBySummaryProvider() {
        }

        public Object summarize(int columnIndex, List<ExtendedPersonWithAddress> children) {
            int summaryValue = 0;
            for (ExtendedPersonWithAddress child : children) {
                summaryValue += child.getAge();
            }
            return summaryValue / (children.size() > 0 ? children.size() : 1);
        }
    }

    class AverageMoneyGroupBySummaryProvider
    implements IGroupBySummaryProvider<ExtendedPersonWithAddress> {
        AverageMoneyGroupBySummaryProvider() {
        }

        public Object summarize(int columnIndex, List<ExtendedPersonWithAddress> children) {
            int summaryValue = 0;
            for (ExtendedPersonWithAddress child : children) {
                summaryValue = (int)((double)summaryValue + child.getMoney());
            }
            return summaryValue / (children.size() > 0 ? children.size() : 1);
        }
    }

    class BodyLayerStack<T>
    extends AbstractLayerTransform {
        private final EventList<T> eventList;
        private final SortedList<T> sortedList;
        private final FilterList<T> filterList;
        private final IDataProvider bodyDataProvider;
        private final GroupByDataLayer<T> bodyDataLayer;
        private final SelectionLayer selectionLayer;
        private final TreeLayer treeLayer;
        private final GroupByModel groupByModel = new GroupByModel();

        public BodyLayerStack(List<T> values, IColumnPropertyAccessor<T> columnPropertyAccessor, ConfigRegistry configRegistry) {
            this.eventList = GlazedLists.eventList(values);
            TransformedList rowObjectsGlazedList = GlazedLists.threadSafeList(this.eventList);
            this.sortedList = new SortedList((EventList)rowObjectsGlazedList, null);
            this.filterList = new FilterList(this.sortedList);
            this.bodyDataLayer = new GroupByDataLayer(this.getGroupByModel(), this.filterList, columnPropertyAccessor, (IConfigRegistry)configRegistry);
            this.bodyDataProvider = this.bodyDataLayer.getDataProvider();
            GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer(this.bodyDataLayer, this.filterList);
            ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)glazedListsEventLayer);
            ColumnHideShowLayer columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)columnHideShowLayer);
            this.treeLayer = new TreeLayer((IUniqueIndexLayer)this.selectionLayer, (ITreeRowModel)this.bodyDataLayer.getTreeRowModel());
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.treeLayer);
            viewportLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new GroupByConfigLabelModifier(this.getGroupByModel()));
            this.setUnderlyingLayer((ILayer)viewportLayer);
        }

        public TreeLayer getTreeLayer() {
            return this.treeLayer;
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public EventList<T> getEventList() {
            return this.eventList;
        }

        public SortedList<T> getSortedList() {
            return this.sortedList;
        }

        public FilterList<T> getFilterList() {
            return this.filterList;
        }

        public IDataProvider getBodyDataProvider() {
            return this.bodyDataProvider;
        }

        public GroupByDataLayer<T> getBodyDataLayer() {
            return this.bodyDataLayer;
        }

        public GroupByModel getGroupByModel() {
            return this.groupByModel;
        }
    }
}

