/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._600_GlazedLists._605_GroupBy;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByDataLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.persistence.command.DisplayPersistenceDialogCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandToLevelCommand;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class _6051_GroupByExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _6051_GroupByExample());
    }

    @Override
    public String getDescription() {
        return "This example has a 'Group By' region at the top.\nIf you drag a column header into this region, rows in the grid will be grouped by this column.\nIf you right-click on the names in the Group By region, you can ungroup by the clicked column.\nYou can also change the visibility of the Group By region by toggling the visibility via context menu in the corner region.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ConfigRegistry configRegistry = new ConfigRegistry();
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday", "address.street", "address.housenumber", "address.postalCode", "address.city"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        propertyToLabelMap.put("address.street", "Street");
        propertyToLabelMap.put("address.housenumber", "Housenumber");
        propertyToLabelMap.put("address.postalCode", "Postal Code");
        propertyToLabelMap.put("address.city", "City");
        ExtendedReflectiveColumnPropertyAccessor columnPropertyAccessor = new ExtendedReflectiveColumnPropertyAccessor(propertyNames);
        BodyLayerStack bodyLayerStack = new BodyLayerStack(PersonService.getPersonsWithAddress((int)100), columnPropertyAccessor);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyLayerStack.getBodyDataProvider());
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer(bodyLayerStack, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        CompositeLayer compositeGridLayer = new CompositeLayer(1, 2);
        final GroupByHeaderLayer groupByHeaderLayer = new GroupByHeaderLayer(bodyLayerStack.getGroupByModel(), (ILayer)gridLayer, (IDataProvider)columnHeaderDataProvider);
        compositeGridLayer.setChildLayer("GROUP_BY_REGION", (ILayer)groupByHeaderLayer, 0, 0);
        compositeGridLayer.setChildLayer("Grid", (ILayer)gridLayer, 0, 1);
        NatTable natTable = new NatTable(parent, (ILayer)compositeGridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new GroupByHeaderMenuConfiguration(natTable, groupByHeaderLayer));
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable){

            protected PopupMenuBuilder createCornerMenu(NatTable natTable) {
                return super.createCornerMenu(natTable).withStateManagerMenuItemProvider().withMenuItemProvider(new IMenuItemProvider(){

                    public void addMenuItem(NatTable natTable, Menu popupMenu) {
                        MenuItem menuItem = new MenuItem(popupMenu, 8);
                        menuItem.setText("Toggle Group By Header");
                        menuItem.setEnabled(true);
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                groupByHeaderLayer.setVisible(!groupByHeaderLayer.isVisible());
                            }
                        });
                    }
                }).withMenuItemProvider(new IMenuItemProvider(){

                    public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                        MenuItem menuItem = new MenuItem(popupMenu, 8);
                        menuItem.setText("Collapse All");
                        menuItem.setEnabled(true);
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                natTable.doCommand((ILayerCommand)new TreeCollapseAllCommand());
                            }
                        });
                    }
                }).withMenuItemProvider(new IMenuItemProvider(){

                    public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                        MenuItem menuItem = new MenuItem(popupMenu, 8);
                        menuItem.setText("Expand All");
                        menuItem.setEnabled(true);
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                natTable.doCommand((ILayerCommand)new TreeExpandAllCommand());
                            }
                        });
                    }
                }).withMenuItemProvider(new IMenuItemProvider(){

                    public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                        MenuItem menuItem = new MenuItem(popupMenu, 8);
                        menuItem.setText("Expand to Level 2");
                        menuItem.setEnabled(true);
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                natTable.doCommand((ILayerCommand)new TreeExpandToLevelCommand(2));
                            }
                        });
                    }
                });
            }
        });
        natTable.configure();
        natTable.registerCommandHandler((ILayerCommandHandler)new DisplayPersistenceDialogCommandHandler(natTable));
        return natTable;
    }

    class BodyLayerStack<T>
    extends AbstractLayerTransform {
        private final SortedList<T> sortedList;
        private final IDataProvider bodyDataProvider;
        private final SelectionLayer selectionLayer;
        private final GroupByModel groupByModel = new GroupByModel();

        public BodyLayerStack(List<T> values, IColumnPropertyAccessor<T> columnPropertyAccessor) {
            EventList eventList = GlazedLists.eventList(values);
            TransformedList rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
            this.sortedList = new SortedList((EventList)rowObjectsGlazedList, null);
            GroupByDataLayer bodyDataLayer = new GroupByDataLayer(this.getGroupByModel(), this.sortedList, columnPropertyAccessor);
            this.bodyDataProvider = bodyDataLayer.getDataProvider();
            GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)bodyDataLayer, this.sortedList);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)glazedListsEventLayer);
            TreeLayer treeLayer = new TreeLayer((IUniqueIndexLayer)this.selectionLayer, (ITreeRowModel)bodyDataLayer.getTreeRowModel());
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)treeLayer);
            this.setUnderlyingLayer((ILayer)viewportLayer);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public SortedList<T> getSortedList() {
            return this.sortedList;
        }

        public IDataProvider getBodyDataProvider() {
            return this.bodyDataProvider;
        }

        public GroupByModel getGroupByModel() {
            return this.groupByModel;
        }
    }
}

