/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._300_Data;

import java.util.HashMap;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDateDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.stack.DefaultBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _307_ChangeDataProviderExample
extends AbstractNatExample {
    private IDataProvider personBodyDataProvider;
    private IDataProvider personColumnHeaderDataProvider;
    private IDataProvider personRowHeaderDataProvider;
    private IConfigLabelAccumulator personAccumulator = new IConfigLabelAccumulator(){

        public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
            switch (columnPosition) {
                case 3: {
                    configLabels.addLabel("MARRIED");
                    break;
                }
                case 4: {
                    configLabels.addLabel("DATE");
                }
            }
        }
    };
    private IDataProvider addressBodyDataProvider;
    private IDataProvider addressColumnHeaderDataProvider;
    private IDataProvider addressRowHeaderDataProvider;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 650, new _307_ChangeDataProviderExample());
    }

    @Override
    public String getDescription() {
        return "This example shows how to exchange the IDataProvider at runtime. This feature allows to exchange the shown data structure without the need to re-create the layer stack.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        String[] personPropertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        HashMap<String, String> personPropertyToLabelMap = new HashMap<String, String>();
        personPropertyToLabelMap.put("firstName", "Firstname");
        personPropertyToLabelMap.put("lastName", "Lastname");
        personPropertyToLabelMap.put("gender", "Gender");
        personPropertyToLabelMap.put("married", "Married");
        personPropertyToLabelMap.put("birthday", "Birthday");
        this.personBodyDataProvider = new ListDataProvider(PersonService.getPersons((int)10), (IColumnAccessor)new ReflectiveColumnPropertyAccessor(personPropertyNames));
        this.personColumnHeaderDataProvider = new DefaultColumnHeaderDataProvider(personPropertyNames, personPropertyToLabelMap);
        this.personRowHeaderDataProvider = new DefaultRowHeaderDataProvider(this.personBodyDataProvider);
        String[] addressPropertyNames = new String[]{"street", "housenumber", "postalCode", "city"};
        HashMap<String, String> addressPropertyToLabelMap = new HashMap<String, String>();
        addressPropertyToLabelMap.put("street", "Street");
        addressPropertyToLabelMap.put("housenumber", "Housenumber");
        addressPropertyToLabelMap.put("postalCode", "Postal Code");
        addressPropertyToLabelMap.put("city", "City");
        this.addressBodyDataProvider = new ListDataProvider(PersonService.getAddress((int)20), (IColumnAccessor)new ReflectiveColumnPropertyAccessor(addressPropertyNames));
        this.addressColumnHeaderDataProvider = new DefaultColumnHeaderDataProvider(addressPropertyNames, addressPropertyToLabelMap);
        this.addressRowHeaderDataProvider = new DefaultRowHeaderDataProvider(this.addressBodyDataProvider);
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Composite gridPanel = new Composite(panel, 0);
        gridPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)gridPanel);
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)buttonPanel);
        ConfigRegistry configRegistry = new ConfigRegistry();
        final DataLayer bodyDataLayer = new DataLayer(this.personBodyDataProvider);
        bodyDataLayer.setConfigLabelAccumulator(this.personAccumulator);
        DefaultBodyLayerStack bodyLayerStack = new DefaultBodyLayerStack((IUniqueIndexLayer)bodyDataLayer);
        final DataLayer columnHeaderDataLayer = new DataLayer(this.personColumnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)bodyLayerStack.getViewportLayer(), bodyLayerStack.getSelectionLayer());
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer(this.personRowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)bodyLayerStack.getViewportLayer(), bodyLayerStack.getSelectionLayer());
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DefaultCornerDataProvider(this.personColumnHeaderDataProvider, this.personRowHeaderDataProvider)), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)bodyLayerStack, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(gridPanel, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable));
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", "MARRIED");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDateDisplayConverter("yyyy-MM-dd"), "NORMAL", "DATE");
            }
        });
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        Button showPersonsButton = new Button(buttonPanel, 8);
        showPersonsButton.setText("Show Persons");
        showPersonsButton.addSelectionListener((SelectionListener)new SelectionAdapter((DataLayer)rowHeaderDataLayer, natTable){
            private final /* synthetic */ DataLayer val$rowHeaderDataLayer;
            private final /* synthetic */ NatTable val$natTable;
            {
                this.val$rowHeaderDataLayer = dataLayer3;
                this.val$natTable = natTable;
            }

            public void widgetSelected(SelectionEvent e) {
                bodyDataLayer.setDataProvider(_307_ChangeDataProviderExample.this.personBodyDataProvider);
                columnHeaderDataLayer.setDataProvider(_307_ChangeDataProviderExample.this.personColumnHeaderDataProvider);
                this.val$rowHeaderDataLayer.setDataProvider(_307_ChangeDataProviderExample.this.personRowHeaderDataProvider);
                bodyDataLayer.setConfigLabelAccumulator(_307_ChangeDataProviderExample.this.personAccumulator);
                this.val$natTable.refresh();
                this.val$natTable.getHorizontalBar().setVisible(false);
                this.val$natTable.getVerticalBar().setVisible(false);
            }
        });
        Button showAddressButton = new Button(buttonPanel, 8);
        showAddressButton.setText("Show Address");
        showAddressButton.addSelectionListener((SelectionListener)new SelectionAdapter((DataLayer)rowHeaderDataLayer, natTable){
            private final /* synthetic */ DataLayer val$rowHeaderDataLayer;
            private final /* synthetic */ NatTable val$natTable;
            {
                this.val$rowHeaderDataLayer = dataLayer3;
                this.val$natTable = natTable;
            }

            public void widgetSelected(SelectionEvent e) {
                bodyDataLayer.setDataProvider(_307_ChangeDataProviderExample.this.addressBodyDataProvider);
                columnHeaderDataLayer.setDataProvider(_307_ChangeDataProviderExample.this.addressColumnHeaderDataProvider);
                this.val$rowHeaderDataLayer.setDataProvider(_307_ChangeDataProviderExample.this.addressRowHeaderDataProvider);
                bodyDataLayer.setConfigLabelAccumulator(null);
                this.val$natTable.refresh();
            }
        });
        return panel;
    }
}

